/*
 * Decompiled with CFR 0.152.
 */
package org.encog.solve.genetic.genome;

import java.util.Comparator;
import org.encog.solve.genetic.genome.CalculateGenomeScore;
import org.encog.solve.genetic.genome.Genome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenomeComparator
implements Comparator<Genome> {
    private final CalculateGenomeScore calculateScore;

    public GenomeComparator(CalculateGenomeScore calculateGenomeScore) {
        this.calculateScore = calculateGenomeScore;
    }

    public double applyBonus(double d, double d2) {
        double d3 = d * d2;
        if (this.calculateScore.shouldMinimize()) {
            return d - d3;
        }
        return d + d3;
    }

    public double applyPenalty(double d, double d2) {
        double d3 = d * d2;
        if (this.calculateScore.shouldMinimize()) {
            return d - d3;
        }
        return d + d3;
    }

    public double bestScore(double d, double d2) {
        if (this.calculateScore.shouldMinimize()) {
            return Math.min(d, d2);
        }
        return Math.max(d, d2);
    }

    @Override
    public int compare(Genome genome, Genome genome2) {
        return Double.compare(genome.getScore(), genome2.getScore());
    }

    public CalculateGenomeScore getCalculateScore() {
        return this.calculateScore;
    }

    public boolean isBetterThan(double d, double d2) {
        if (this.calculateScore.shouldMinimize()) {
            return d < d2;
        }
        return d > d2;
    }
}

