/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.location;

import java.io.InputStream;
import java.io.OutputStream;
import org.encog.persist.PersistError;
import org.encog.persist.location.PersistenceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputStreamPersistence
implements PersistenceLocation {
    private final Logger logger = LoggerFactory.getLogger(OutputStreamPersistence.class);
    private final OutputStream ostream;

    public OutputStreamPersistence(OutputStream outputStream) {
        this.ostream = outputStream;
    }

    public InputStream createInputStream() {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("The InputStreamPersistence location does not support output streams.");
        }
        throw new PersistError("The InputStreamPersistence location does not support output streams.");
    }

    public OutputStream createOutputStream() {
        return this.ostream;
    }

    public void delete() {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("The OutputStreamPersistence location does not support delete operations.");
        }
        throw new PersistError("The OutputStreamPersistence location does not support delete operations.");
    }

    public boolean exists() {
        return true;
    }

    public void renameTo(PersistenceLocation persistenceLocation) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("The OutputStreamPersistence location does not support rename operations.");
        }
        throw new PersistError("The OutputStreamPersistence location does not support rename operations.");
    }
}

