/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.encog.Encog;
import org.encog.neural.networks.BasicNetwork;
import org.encog.persist.DirectoryEntry;
import org.encog.persist.EncogCollection;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.PersistError;
import org.encog.persist.PersistReader;
import org.encog.persist.PersistWriter;
import org.encog.persist.location.FilePersistence;
import org.encog.persist.location.PersistenceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncogPersistedCollection
implements EncogCollection {
    private PersistenceLocation location;
    public static final String GENERAL_ERROR = "Malformed XML near tag: ";
    public static final String TYPE_TEXT = "TextData";
    public static final String TYPE_PROPERTY = "PropertyData";
    public static final String TYPE_BASIC_NET = "BasicNetwork";
    public static final String TYPE_BASIC_LAYER = "BasicLayer";
    public static final String TYPE_CONTEXT_LAYER = "ContextLayer";
    public static final String TYPE_RADIAL_BASIS_LAYER = "RadialBasisFunctionLayer";
    public static final String TYPE_TRAINING = "TrainingData";
    public static final String TYPE_WEIGHTED_SYNAPSE = "WeightedSynapse";
    public static final String TYPE_WEIGHTLESS_SYNAPSE = "WeightlessSynapse";
    public static final String TYPE_DIRECT_SYNAPSE = "DirectSynapse";
    public static final String TYPE_ONE2ONE_SYNAPSE = "OneToOneSynapse";
    public static final String TYPE_NORMALIZATION = "DataNormalization";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final Logger LOGGER = LoggerFactory.getLogger(EncogPersistedCollection.class);
    public static final String TYPE_TRAINING_CONTINUATION = "TrainingContinuation";
    public static final String TYPE_POPULATION = "BasicPopulation";
    public static final String TYPE_SVM = "SVMNetwork";
    public static final String TYPE_BINARY = "BufferedNeuralDataSet";
    public static final String TYPE_SCRIPT = "EncogScript";
    private final PersistenceLocation filePrimary;
    private PersistenceLocation fileTemp;
    private PersistWriter writer;
    private String platform = "Java";
    private int fileVersion = 1;
    private final Set<DirectoryEntry> directory = new TreeSet<DirectoryEntry>();
    private String encogVersion = Encog.getInstance().getProperties().get("encog.version");

    public static void throwError(String string) {
        String string2 = GENERAL_ERROR + string;
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error(string2);
        }
        throw new PersistError(string2);
    }

    public EncogPersistedCollection(File file) {
        this(new FilePersistence(file));
    }

    public EncogPersistedCollection(PersistenceLocation persistenceLocation) {
        this.filePrimary = persistenceLocation;
        if (this.filePrimary instanceof FilePersistence) {
            File file = ((FilePersistence)this.filePrimary).getFile();
            String string = file.getAbsolutePath();
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string = string.substring(0, n);
            }
            string = string + ".tmp";
            this.fileTemp = new FilePersistence(new File(string));
            if (this.filePrimary.exists()) {
                try {
                    this.buildDirectory();
                }
                catch (PersistError persistError) {
                    this.create();
                }
            } else {
                this.create();
            }
        } else {
            this.fileTemp = null;
        }
    }

    public EncogPersistedCollection(String string) {
        this(new File(string));
    }

    @Override
    public void add(String string, EncogPersistedObject encogPersistedObject) {
        if (encogPersistedObject instanceof BasicNetwork) {
            ((BasicNetwork)encogPersistedObject).getStructure().updateFlatNetwork();
        }
        encogPersistedObject.setName(string);
        PersistWriter persistWriter = new PersistWriter(this.fileTemp);
        persistWriter.begin();
        persistWriter.writeHeader();
        persistWriter.beginObjects();
        persistWriter.writeObject(encogPersistedObject);
        persistWriter.mergeObjects(this.filePrimary, string);
        persistWriter.endObjects();
        persistWriter.end();
        persistWriter.close();
        this.mergeTemp();
        this.buildDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildDirectory() {
        PersistReader persistReader = null;
        try {
            persistReader = new PersistReader(this.filePrimary);
            Map<String, String> map = persistReader.readHeader();
            if (map != null) {
                this.fileVersion = Integer.parseInt(map.get("fileVersion"));
                this.encogVersion = map.get("encogVersion");
                this.platform = map.get("platform");
            }
            Set<DirectoryEntry> set = persistReader.buildDirectory();
            this.directory.clear();
            this.directory.addAll(set);
        }
        finally {
            if (persistReader != null) {
                persistReader.close();
            }
        }
    }

    @Override
    public void clear() {
    }

    public void create() {
        PersistWriter persistWriter = new PersistWriter(this.filePrimary);
        persistWriter.begin();
        persistWriter.writeHeader();
        persistWriter.beginObjects();
        persistWriter.endObjects();
        persistWriter.end();
        persistWriter.close();
        this.directory.clear();
    }

    @Override
    public void delete(DirectoryEntry directoryEntry) {
        this.delete(directoryEntry.getName());
    }

    public void delete(EncogPersistedObject encogPersistedObject) {
        this.delete(encogPersistedObject.getName());
    }

    @Override
    public void delete(String string) {
        PersistWriter persistWriter = new PersistWriter(this.fileTemp);
        persistWriter.begin();
        persistWriter.writeHeader();
        persistWriter.beginObjects();
        persistWriter.mergeObjects(this.filePrimary, string);
        persistWriter.endObjects();
        persistWriter.end();
        persistWriter.close();
        this.mergeTemp();
        for (DirectoryEntry directoryEntry : this.directory) {
            if (!directoryEntry.getName().equals(string)) continue;
            this.directory.remove(directoryEntry);
            break;
        }
    }

    @Override
    public EncogPersistedObject find(DirectoryEntry directoryEntry) {
        return this.find(directoryEntry.getName());
    }

    @Override
    public EncogPersistedObject find(String string) {
        PersistReader persistReader = new PersistReader(this.filePrimary);
        EncogPersistedObject encogPersistedObject = persistReader.readObject(string);
        persistReader.close();
        if (encogPersistedObject != null) {
            encogPersistedObject.setCollection(this);
        }
        return encogPersistedObject;
    }

    @Override
    public Collection<DirectoryEntry> getDirectory() {
        return this.directory;
    }

    @Override
    public String getEncogVersion() {
        return this.encogVersion;
    }

    @Override
    public int getFileVersion() {
        return this.fileVersion;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public void mergeTemp() {
        this.filePrimary.delete();
        this.fileTemp.renameTo(this.filePrimary);
    }

    @Override
    public void updateProperties(String string, String string2, String string3) {
        PersistWriter persistWriter = new PersistWriter(this.fileTemp);
        persistWriter.begin();
        persistWriter.writeHeader();
        persistWriter.beginObjects();
        persistWriter.modifyObject(this.filePrimary, string, string2, string3);
        persistWriter.endObjects();
        persistWriter.end();
        persistWriter.close();
        this.mergeTemp();
        this.buildDirectory();
    }

    @Override
    public boolean exists(String string) {
        for (DirectoryEntry directoryEntry : this.directory) {
            if (!directoryEntry.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PersistenceLocation getLocation() {
        return this.location;
    }
}

