/*
 * Decompiled with CFR 0.152.
 */
package org.encog.normalize.segregate;

import java.util.HashMap;
import java.util.Map;
import org.encog.normalize.DataNormalization;
import org.encog.normalize.input.InputField;
import org.encog.normalize.segregate.Segregator;
import org.encog.persist.annotations.EGIgnore;
import org.encog.persist.annotations.EGReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerBalanceSegregator
implements Segregator {
    @EGReference
    private DataNormalization normalization;
    @EGReference
    private InputField target;
    private int count;
    @EGIgnore
    private final Map<Integer, Integer> runningCounts = new HashMap<Integer, Integer>();

    public IntegerBalanceSegregator(InputField inputField, int n) {
        this.target = inputField;
        this.count = n;
    }

    public IntegerBalanceSegregator() {
    }

    public String dumpCounts() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Integer, Integer> entry : this.runningCounts.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append(" -> ");
            stringBuilder.append(entry.getValue());
            stringBuilder.append(" count\n");
        }
        return stringBuilder.toString();
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public DataNormalization getNormalization() {
        return this.normalization;
    }

    public Map<Integer, Integer> getRunningCounts() {
        return this.runningCounts;
    }

    public InputField getTarget() {
        return this.target;
    }

    @Override
    public void init(DataNormalization dataNormalization) {
        this.normalization = dataNormalization;
    }

    @Override
    public void passInit() {
        this.runningCounts.clear();
    }

    @Override
    public boolean shouldInclude() {
        int n = (int)this.target.getCurrentValue();
        int n2 = 0;
        if (this.runningCounts.containsKey(n)) {
            n2 = this.runningCounts.get(n);
        }
        if (n2 < this.count) {
            this.runningCounts.put(n, ++n2);
            return true;
        }
        return false;
    }
}

