/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.strategy;

import org.encog.neural.networks.training.Strategy;
import org.encog.neural.networks.training.Train;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequiredImprovementStrategy
implements Strategy {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final double required;
    private final int cycles;
    private Train train;
    private int badCycleCount;
    private double lastError = Double.NaN;
    private double acceptableThreshold;

    public RequiredImprovementStrategy(double d, int n) {
        this(d, 0.1, n);
    }

    public RequiredImprovementStrategy(double d, double d2, int n) {
        this.required = d;
        this.cycles = n;
        this.badCycleCount = 0;
        this.acceptableThreshold = d2;
    }

    public RequiredImprovementStrategy(int n) {
        this(0.01, 0.1, 5);
    }

    public void init(Train train) {
        this.train = train;
    }

    public void postIteration() {
    }

    public void preIteration() {
        if (this.train.getError() > this.acceptableThreshold) {
            if (!Double.isNaN(this.lastError)) {
                double d = this.lastError - this.train.getError();
                if (d < this.required) {
                    ++this.badCycleCount;
                    if (this.badCycleCount > this.cycles) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Failed to improve network, resetting.");
                        }
                        this.train.getNetwork().reset();
                        this.badCycleCount = 0;
                        this.lastError = Double.NaN;
                    }
                } else {
                    this.badCycleCount = 0;
                }
            } else {
                this.lastError = this.train.getError();
            }
        }
        this.lastError = Math.min(this.train.getError(), this.lastError);
    }
}

