/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.neat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.encog.cloud.EncogCloud;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.engine.network.activation.ActivationSigmoid;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.training.CalculateScore;
import org.encog.neural.networks.training.Strategy;
import org.encog.neural.networks.training.Train;
import org.encog.neural.networks.training.TrainingError;
import org.encog.neural.networks.training.genetic.GeneticScoreAdapter;
import org.encog.neural.networks.training.neat.NEATGenome;
import org.encog.neural.networks.training.neat.NEATInnovationList;
import org.encog.neural.networks.training.neat.NEATLinkGene;
import org.encog.neural.networks.training.neat.NEATParent;
import org.encog.solve.genetic.GeneticAlgorithm;
import org.encog.solve.genetic.genome.Chromosome;
import org.encog.solve.genetic.genome.Genome;
import org.encog.solve.genetic.genome.GenomeComparator;
import org.encog.solve.genetic.population.BasicPopulation;
import org.encog.solve.genetic.population.Population;
import org.encog.solve.genetic.species.BasicSpecies;
import org.encog.solve.genetic.species.Species;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NEATTraining
extends GeneticAlgorithm
implements Train {
    private double averageFitAdjustment;
    private double bestEverScore;
    private BasicNetwork bestEverNetwork;
    private final int inputCount;
    private ActivationFunction neatActivationFunction = new ActivationSigmoid();
    private ActivationFunction outputActivationFunction = new ActivationLinear();
    private final int outputCount;
    private double paramActivationMutationRate = 0.1;
    private double paramChanceAddLink = 0.07;
    private double paramChanceAddNode = 0.04;
    private double paramChanceAddRecurrentLink = 0.05;
    private double paramCompatibilityThreshold = 0.26;
    private double paramCrossoverRate = 0.7;
    private double paramMaxActivationPerturbation = 0.1;
    private int paramMaxNumberOfSpecies = 0;
    private double paramMaxPermittedNeurons = 100.0;
    private double paramMaxWeightPerturbation = 0.5;
    private double paramMutationRate = 0.2;
    private int paramNumAddLinkAttempts = 5;
    private int paramNumGensAllowedNoImprovement = 15;
    private int paramNumTrysToFindLoopedLink = 5;
    private int paramNumTrysToFindOldLink = 5;
    private double paramProbabilityWeightReplaced = 0.1;
    private double totalFitAdjustment;
    private boolean snapshot;
    private EncogCloud cloud;
    private int iteration;

    public NEATTraining(CalculateScore calculateScore, BasicNetwork basicNetwork, Population population) {
        Layer layer = basicNetwork.getLayer("INPUT");
        Layer layer2 = basicNetwork.getLayer("OUTPUT");
        this.setCalculateScore(new GeneticScoreAdapter(calculateScore));
        this.setComparator(new GenomeComparator(this.getCalculateScore()));
        this.inputCount = layer.getNeuronCount();
        this.outputCount = layer2.getNeuronCount();
        this.setPopulation(population);
        for (Genome genome : population.getGenomes()) {
            if (!(genome instanceof NEATGenome)) {
                throw new TrainingError("Population can only contain objects of NEATGenome.");
            }
            NEATGenome nEATGenome = (NEATGenome)genome;
            if (nEATGenome.getInputCount() != this.inputCount || nEATGenome.getOutputCount() != this.outputCount) {
                throw new TrainingError("All NEATGenome's must have the same input and output sizes as the base network.");
            }
            nEATGenome.setGeneticAlgorithm(this);
        }
        this.init();
    }

    public NEATTraining(CalculateScore calculateScore, int n, int n2, int n3) {
        this.inputCount = n;
        this.outputCount = n2;
        this.setCalculateScore(new GeneticScoreAdapter(calculateScore));
        this.setComparator(new GenomeComparator(this.getCalculateScore()));
        this.setPopulation(new BasicPopulation(n3));
        for (int i = 0; i < n3; ++i) {
            this.getPopulation().add(new NEATGenome(this, this.getPopulation().assignGenomeID(), n, n2));
        }
        this.init();
    }

    public NEATTraining(CalculateScore calculateScore, Population population) {
        if (population.size() < 1) {
            throw new TrainingError("Population can not be empty.");
        }
        NEATGenome nEATGenome = (NEATGenome)population.getGenomes().get(0);
        this.setCalculateScore(new GeneticScoreAdapter(calculateScore));
        this.setPopulation(population);
        this.inputCount = nEATGenome.getInputCount();
        this.outputCount = nEATGenome.getOutputCount();
        for (Genome genome : population.getGenomes()) {
            NEATGenome nEATGenome2 = (NEATGenome)genome;
            nEATGenome2.setGeneticAlgorithm(this);
        }
        this.init();
    }

    public void addNeuronID(long l, List<Long> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != l) continue;
            return;
        }
        list.add(l);
    }

    @Override
    public void addStrategy(Strategy strategy) {
        throw new TrainingError("Strategies are not supported by this training method.");
    }

    public void adjustCompatibilityThreshold() {
        if (this.paramMaxNumberOfSpecies < 1) {
            return;
        }
        if (this.getPopulation().getSpecies().size() > this.paramMaxNumberOfSpecies) {
            this.paramCompatibilityThreshold += 0.01;
        } else if (this.getPopulation().getSpecies().size() < 2) {
            this.paramCompatibilityThreshold -= 0.01;
        }
    }

    public void adjustSpeciesScore() {
        for (Species species : this.getPopulation().getSpecies()) {
            for (Genome genome : species.getMembers()) {
                double d = genome.getScore();
                if (species.getAge() < this.getPopulation().getYoungBonusAgeThreshold()) {
                    d = this.getComparator().applyBonus(d, this.getPopulation().getYoungScoreBonus());
                }
                if (species.getAge() > this.getPopulation().getOldAgeThreshold()) {
                    d = this.getComparator().applyPenalty(d, this.getPopulation().getOldAgePenalty());
                }
                double d2 = d / (double)species.getMembers().size();
                genome.setAdjustedScore(d2);
            }
        }
    }

    public NEATGenome crossover(NEATGenome nEATGenome, NEATGenome nEATGenome2) {
        NEATParent nEATParent = nEATGenome.getScore() == nEATGenome2.getScore() ? (nEATGenome.getNumGenes() == nEATGenome2.getNumGenes() ? (Math.random() > 0.0 ? NEATParent.Mom : NEATParent.Dad) : (nEATGenome.getNumGenes() < nEATGenome2.getNumGenes() ? NEATParent.Mom : NEATParent.Dad)) : (this.getComparator().isBetterThan(nEATGenome.getScore(), nEATGenome2.getScore()) ? NEATParent.Mom : NEATParent.Dad);
        Chromosome chromosome = new Chromosome();
        Chromosome chromosome2 = new Chromosome();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        int n = 0;
        int n2 = 0;
        NEATLinkGene nEATLinkGene = null;
        while (n < nEATGenome.getNumGenes() || n2 < nEATGenome2.getNumGenes()) {
            NEATLinkGene nEATLinkGene2 = n < nEATGenome.getNumGenes() ? (NEATLinkGene)nEATGenome.getLinks().get(n) : null;
            NEATLinkGene nEATLinkGene3 = n2 < nEATGenome2.getNumGenes() ? (NEATLinkGene)nEATGenome2.getLinks().get(n2) : null;
            if (nEATLinkGene2 == null && nEATLinkGene3 != null) {
                if (nEATParent == NEATParent.Dad) {
                    nEATLinkGene = nEATLinkGene3;
                }
                ++n2;
            } else if (nEATLinkGene3 == null && nEATLinkGene2 != null) {
                if (nEATParent == NEATParent.Mom) {
                    nEATLinkGene = nEATLinkGene2;
                }
                ++n;
            } else if (nEATLinkGene2.getInnovationId() < nEATLinkGene3.getInnovationId()) {
                if (nEATParent == NEATParent.Mom) {
                    nEATLinkGene = nEATLinkGene2;
                }
                ++n;
            } else if (nEATLinkGene3.getInnovationId() < nEATLinkGene2.getInnovationId()) {
                if (nEATParent == NEATParent.Dad) {
                    nEATLinkGene = nEATLinkGene3;
                }
                ++n2;
            } else if (nEATLinkGene3.getInnovationId() == nEATLinkGene2.getInnovationId()) {
                nEATLinkGene = Math.random() < 0.5 ? nEATLinkGene2 : nEATLinkGene3;
                ++n;
                ++n2;
            }
            if (chromosome2.size() == 0) {
                chromosome2.add(nEATLinkGene);
            } else if (((NEATLinkGene)chromosome2.get(chromosome2.size() - 1)).getInnovationId() != nEATLinkGene.getInnovationId()) {
                chromosome2.add(nEATLinkGene);
            }
            this.addNeuronID(nEATLinkGene.getFromNeuronID(), arrayList);
            this.addNeuronID(nEATLinkGene.getToNeuronID(), arrayList);
        }
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            chromosome.add(this.getInnovations().createNeuronFromID((Long)arrayList.get(i)));
        }
        NEATGenome nEATGenome3 = new NEATGenome(this, this.getPopulation().assignGenomeID(), chromosome, chromosome2, nEATGenome.getInputCount(), nEATGenome.getOutputCount());
        return nEATGenome3;
    }

    @Override
    public void finishTraining() {
    }

    @Override
    public EncogCloud getCloud() {
        return this.cloud;
    }

    @Override
    public double getError() {
        return this.bestEverScore;
    }

    public NEATInnovationList getInnovations() {
        return (NEATInnovationList)this.getPopulation().getInnovations();
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public ActivationFunction getNeatActivationFunction() {
        return this.neatActivationFunction;
    }

    @Override
    public BasicNetwork getNetwork() {
        return this.bestEverNetwork;
    }

    public ActivationFunction getOutputActivationFunction() {
        return this.outputActivationFunction;
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public double getParamActivationMutationRate() {
        return this.paramActivationMutationRate;
    }

    public double getParamChanceAddLink() {
        return this.paramChanceAddLink;
    }

    public double getParamChanceAddNode() {
        return this.paramChanceAddNode;
    }

    public double getParamChanceAddRecurrentLink() {
        return this.paramChanceAddRecurrentLink;
    }

    public double getParamCompatibilityThreshold() {
        return this.paramCompatibilityThreshold;
    }

    public double getParamCrossoverRate() {
        return this.paramCrossoverRate;
    }

    public double getParamMaxActivationPerturbation() {
        return this.paramMaxActivationPerturbation;
    }

    public int getParamMaxNumberOfSpecies() {
        return this.paramMaxNumberOfSpecies;
    }

    public double getParamMaxPermittedNeurons() {
        return this.paramMaxPermittedNeurons;
    }

    public double getParamMaxWeightPerturbation() {
        return this.paramMaxWeightPerturbation;
    }

    public double getParamMutationRate() {
        return this.paramMutationRate;
    }

    public int getParamNumAddLinkAttempts() {
        return this.paramNumAddLinkAttempts;
    }

    public int getParamNumGensAllowedNoImprovement() {
        return this.paramNumGensAllowedNoImprovement;
    }

    public int getParamNumTrysToFindLoopedLink() {
        return this.paramNumTrysToFindLoopedLink;
    }

    public int getParamNumTrysToFindOldLink() {
        return this.paramNumTrysToFindOldLink;
    }

    public double getParamProbabilityWeightReplaced() {
        return this.paramProbabilityWeightReplaced;
    }

    @Override
    public List<Strategy> getStrategies() {
        return new ArrayList<Strategy>();
    }

    @Override
    public NeuralDataSet getTraining() {
        return null;
    }

    private void init() {
        NEATGenome nEATGenome = (NEATGenome)this.getPopulation().getGenomes().get(0);
        if (this.getInnovations() == null) {
            this.getPopulation().setInnovations(new NEATInnovationList(this.getPopulation(), nEATGenome.getLinks(), nEATGenome.getNeurons()));
        }
        this.bestEverScore = this.getCalculateScore().shouldMinimize() ? Double.MAX_VALUE : Double.MIN_VALUE;
        this.resetAndKill();
        this.sortAndRecord();
        this.speciateAndCalculateSpawnLevels();
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    @Override
    public void iteration() {
        ++this.iteration;
        ArrayList<NEATGenome> arrayList = new ArrayList<NEATGenome>();
        int n = 0;
        for (Species species : this.getPopulation().getSpecies()) {
            if (n >= this.getPopulation().size()) continue;
            int n2 = (int)Math.round(species.getNumToSpawn());
            boolean bl = false;
            while (n2-- > 0) {
                NEATGenome nEATGenome = null;
                if (!bl) {
                    nEATGenome = (NEATGenome)species.getLeader();
                    bl = true;
                } else {
                    if (species.getMembers().size() == 1) {
                        nEATGenome = new NEATGenome((NEATGenome)species.chooseParent());
                    } else {
                        NEATGenome nEATGenome2 = (NEATGenome)species.chooseParent();
                        if (Math.random() < this.paramCrossoverRate) {
                            NEATGenome nEATGenome3 = (NEATGenome)species.chooseParent();
                            int n3 = 5;
                            while (nEATGenome2.getGenomeID() == nEATGenome3.getGenomeID() && n3-- > 0) {
                                nEATGenome3 = (NEATGenome)species.chooseParent();
                            }
                            if (nEATGenome2.getGenomeID() != nEATGenome3.getGenomeID()) {
                                nEATGenome = this.crossover(nEATGenome2, nEATGenome3);
                            }
                        } else {
                            nEATGenome = new NEATGenome(nEATGenome2);
                        }
                    }
                    if (nEATGenome != null) {
                        nEATGenome.setGenomeID(this.getPopulation().assignGenomeID());
                        if ((double)nEATGenome.getNeurons().size() < this.paramMaxPermittedNeurons) {
                            nEATGenome.addNeuron(this.paramChanceAddNode, this.paramNumTrysToFindOldLink);
                        }
                        nEATGenome.addLink(this.paramChanceAddLink, this.paramChanceAddRecurrentLink, this.paramNumTrysToFindLoopedLink, this.paramNumAddLinkAttempts);
                        nEATGenome.mutateWeights(this.paramMutationRate, this.paramProbabilityWeightReplaced, this.paramMaxWeightPerturbation);
                        nEATGenome.mutateActivationResponse(this.paramActivationMutationRate, this.paramMaxActivationPerturbation);
                    }
                }
                if (nEATGenome == null) continue;
                nEATGenome.sortGenes();
                arrayList.add(nEATGenome);
                if (++n != this.getPopulation().size()) continue;
                n2 = 0;
            }
        }
        while (arrayList.size() < this.getPopulation().size()) {
            arrayList.add(this.tournamentSelection(this.getPopulation().size() / 5));
        }
        this.getPopulation().clear();
        this.getPopulation().addAll(arrayList);
        this.resetAndKill();
        this.sortAndRecord();
        this.speciateAndCalculateSpawnLevels();
    }

    public void resetAndKill() {
        Object[] objectArray;
        this.totalFitAdjustment = 0.0;
        this.averageFitAdjustment = 0.0;
        for (Object object : objectArray = this.getPopulation().getSpecies().toArray()) {
            Species species = (Species)object;
            species.purge();
            if (species.getGensNoImprovement() <= this.paramNumGensAllowedNoImprovement || !this.getComparator().isBetterThan(this.bestEverScore, species.getBestScore())) continue;
            this.getPopulation().getSpecies().remove(species);
        }
    }

    @Override
    public void setCloud(EncogCloud encogCloud) {
        this.cloud = encogCloud;
    }

    @Override
    public void setError(double d) {
    }

    public void setNeatActivationFunction(ActivationFunction activationFunction) {
        this.neatActivationFunction = activationFunction;
    }

    public void setOutputActivationFunction(ActivationFunction activationFunction) {
        this.outputActivationFunction = activationFunction;
    }

    public void setParamActivationMutationRate(double d) {
        this.paramActivationMutationRate = d;
    }

    public void setParamChanceAddLink(double d) {
        this.paramChanceAddLink = d;
    }

    public void setParamChanceAddNode(double d) {
        this.paramChanceAddNode = d;
    }

    public void setParamChanceAddRecurrentLink(double d) {
        this.paramChanceAddRecurrentLink = d;
    }

    public void setParamCompatibilityThreshold(double d) {
        this.paramCompatibilityThreshold = d;
    }

    public void setParamCrossoverRate(double d) {
        this.paramCrossoverRate = d;
    }

    public void setParamMaxActivationPerturbation(double d) {
        this.paramMaxActivationPerturbation = d;
    }

    public void setParamMaxNumberOfSpecies(int n) {
        this.paramMaxNumberOfSpecies = n;
    }

    public void setParamMaxPermittedNeurons(double d) {
        this.paramMaxPermittedNeurons = d;
    }

    public void setParamMaxWeightPerturbation(double d) {
        this.paramMaxWeightPerturbation = d;
    }

    public void setParamMutationRate(double d) {
        this.paramMutationRate = d;
    }

    public void setParamNumAddLinkAttempts(int n) {
        this.paramNumAddLinkAttempts = n;
    }

    public void setParamNumGensAllowedNoImprovement(int n) {
        this.paramNumGensAllowedNoImprovement = n;
    }

    public void setParamNumTrysToFindLoopedLink(int n) {
        this.paramNumTrysToFindLoopedLink = n;
    }

    public void setParamNumTrysToFindOldLink(int n) {
        this.paramNumTrysToFindOldLink = n;
    }

    public void setParamProbabilityWeightReplaced(double d) {
        this.paramProbabilityWeightReplaced = d;
    }

    public void setSnapshot(boolean bl) {
        this.snapshot = bl;
    }

    public void sortAndRecord() {
        for (Genome genome : this.getPopulation().getGenomes()) {
            genome.decode();
            this.calculateScore(genome);
        }
        this.getPopulation().sort();
        Genome genome = this.getPopulation().getBest();
        double d = genome.getScore();
        if (this.getComparator().isBetterThan(d, this.bestEverScore)) {
            this.bestEverScore = d;
            this.bestEverNetwork = (BasicNetwork)genome.getOrganism();
        }
        this.bestEverScore = this.getComparator().bestScore(this.getError(), this.bestEverScore);
    }

    public void speciateAndCalculateSpawnLevels() {
        NEATGenome nEATGenome;
        this.adjustCompatibilityThreshold();
        for (Genome object : this.getPopulation().getGenomes()) {
            nEATGenome = (NEATGenome)object;
            boolean bl = false;
            for (Species species : this.getPopulation().getSpecies()) {
                double d = nEATGenome.getCompatibilityScore((NEATGenome)species.getLeader());
                if (!(d <= this.paramCompatibilityThreshold)) continue;
                this.addSpeciesMember(species, nEATGenome);
                nEATGenome.setSpeciesID(species.getSpeciesID());
                bl = true;
                break;
            }
            if (bl) continue;
            this.getPopulation().getSpecies().add(new BasicSpecies(this.getPopulation(), nEATGenome, this.getPopulation().assignSpeciesID()));
        }
        this.adjustSpeciesScore();
        for (Genome genome : this.getPopulation().getGenomes()) {
            nEATGenome = (NEATGenome)genome;
            this.totalFitAdjustment += nEATGenome.getAdjustedScore();
        }
        this.averageFitAdjustment = this.totalFitAdjustment / (double)this.getPopulation().size();
        for (Genome genome : this.getPopulation().getGenomes()) {
            nEATGenome = (NEATGenome)genome;
            double d = nEATGenome.getAdjustedScore() / this.averageFitAdjustment;
            nEATGenome.setAmountToSpawn(d);
        }
        for (Species species : this.getPopulation().getSpecies()) {
            species.calculateSpawnAmount();
        }
    }

    public NEATGenome tournamentSelection(int n) {
        double d = 0.0;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = (int)RangeRandomizer.randomize(0.0, this.getPopulation().size() - 1);
            if (!(this.getPopulation().get(n3).getScore() > d)) continue;
            n2 = n3;
            d = this.getPopulation().get(n3).getScore();
        }
        return (NEATGenome)this.getPopulation().get(n2);
    }

    @Override
    public boolean isTrainingDone() {
        return false;
    }

    @Override
    public void iteration(int n) {
        for (int i = 0; i < n; ++i) {
            this.iteration();
        }
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    @Override
    public void setIteration(int n) {
        this.iteration = n;
    }
}

