/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.basic;

import java.io.Serializable;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicNeuralDataPair
implements NeuralDataPair,
Serializable {
    private static final long serialVersionUID = -9068229682273861359L;
    private final NeuralData ideal;
    private final NeuralData input;
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public BasicNeuralDataPair(NeuralData neuralData) {
        this.input = neuralData;
        this.ideal = null;
    }

    public BasicNeuralDataPair(NeuralData neuralData, NeuralData neuralData2) {
        this.input = neuralData;
        this.ideal = neuralData2;
    }

    public NeuralData getIdeal() {
        return this.ideal;
    }

    public NeuralData getInput() {
        return this.input;
    }

    public boolean isSupervised() {
        return this.ideal != null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[NeuralDataPair:");
        stringBuilder.append("Input:");
        stringBuilder.append(this.getInput());
        stringBuilder.append("Ideal:");
        stringBuilder.append(this.getIdeal());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static NeuralDataPair createPair(int n, int n2) {
        BasicNeuralDataPair basicNeuralDataPair = n2 > 0 ? new BasicNeuralDataPair(new BasicNeuralData(n), new BasicNeuralData(n2)) : new BasicNeuralDataPair(new BasicNeuralData(n));
        return basicNeuralDataPair;
    }

    public double[] getIdealArray() {
        return this.ideal.getData();
    }

    public double[] getInputArray() {
        return this.input.getData();
    }

    public void setIdealArray(double[] dArray) {
        this.ideal.setData(dArray);
    }

    public void setInputArray(double[] dArray) {
        this.input.setData(dArray);
    }
}

