/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil;

public final class EncogMath {
    private EncogMath() {
    }

    public static double deg2rad(double d) {
        return d * (Math.PI / 180);
    }

    public static double hypot(double d, double d2) {
        double d3;
        if (Math.abs(d) > Math.abs(d2)) {
            d3 = d2 / d;
            d3 = Math.abs(d) * Math.sqrt(1.0 + d3 * d3);
        } else if (d2 != 0.0) {
            d3 = d / d2;
            d3 = Math.abs(d2) * Math.sqrt(1.0 + d3 * d3);
        } else {
            d3 = 0.0;
        }
        return d3;
    }

    public static double rad2deg(double d) {
        return d * 57.29577951308232;
    }

    public static boolean doubleEquals(double d, double d2) {
        return Math.abs(d - d2) < 1.0E-7;
    }
}

