/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.util;

import org.encog.engine.util.ErrorCalculationMode;

public class ErrorCalculation {
    private static ErrorCalculationMode mode = ErrorCalculationMode.MSE;
    private double globalError;
    private int setSize;

    public static ErrorCalculationMode getMode() {
        return mode;
    }

    public static void setMode(ErrorCalculationMode errorCalculationMode) {
        mode = errorCalculationMode;
    }

    public double calculate() {
        if (this.setSize == 0) {
            return 0.0;
        }
        switch (ErrorCalculation.getMode()) {
            case RMS: {
                return this.calculateRMS();
            }
            case MSE: {
                return this.calculateMSE();
            }
            case ARCTAN: {
                return this.calculateARCTAN();
            }
        }
        return this.calculateMSE();
    }

    public double calculateARCTAN() {
        return this.calculateMSE();
    }

    public double calculateMSE() {
        if (this.setSize == 0) {
            return 0.0;
        }
        double d = this.globalError / (double)this.setSize;
        return d;
    }

    public double calculateRMS() {
        if (this.setSize == 0) {
            return 0.0;
        }
        double d = Math.sqrt(this.globalError / (double)this.setSize);
        return d;
    }

    public void reset() {
        this.globalError = 0.0;
        this.setSize = 0;
    }

    public void updateError(double d, double d2) {
        double d3 = d2 - d;
        if (mode == ErrorCalculationMode.ARCTAN) {
            d3 = Math.atan(d3);
        }
        this.globalError += d3 * d3;
        ++this.setSize;
    }

    public void updateError(double[] dArray, double[] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray2[i] - dArray[i];
            if (mode == ErrorCalculationMode.ARCTAN) {
                d = Math.atan(d);
            }
            this.globalError += d * d;
        }
        this.setSize += dArray2.length;
    }
}

