/*
 * Decompiled with CFR 0.152.
 */
package oms3.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Processes {
    ProcessBuilder pb = new ProcessBuilder(new String[0]);
    File executable;
    Object[] args = new Object[0];
    Logger log;
    Writer stderr = new OutputStreamWriter(System.err){

        @Override
        public void close() throws IOException {
        }
    };
    Writer stdout = new OutputStreamWriter(System.out){

        @Override
        public void close() throws IOException {
        }
    };
    Reader stdin = new InputStreamReader(System.in);

    public Processes(File executable) {
        this.executable = executable;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public void setArguments(Object ... args) {
        this.args = args;
    }

    public void setWorkingDirectory(File dir) {
        if (!dir.exists()) {
            throw new IllegalArgumentException(dir + " doesn't exist.");
        }
        this.pb.directory(dir);
    }

    public Map<String, String> environment() {
        return this.pb.environment();
    }

    public int exec() throws IOException {
        int exitValue = 0;
        ArrayList<String> argl = new ArrayList<String>();
        argl.add(this.executable.toString());
        for (Object a : this.args) {
            if (a == null) continue;
            if (a.getClass() == String.class) {
                argl.add(a.toString());
                continue;
            }
            if (a.getClass() != String[].class) continue;
            for (String s : (String[])a) {
                if (s == null || s.isEmpty()) continue;
                argl.add(s);
            }
        }
        this.pb.command(argl);
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info("Command : " + this.pb.command().toString());
        }
        Process process = this.pb.start();
        CountDownLatch latch = new CountDownLatch(2);
        Thread out_ = new Thread(new Handler(new BufferedReader(new InputStreamReader(process.getInputStream())), this.stdout, latch));
        Thread err_ = new Thread(new Handler(new BufferedReader(new InputStreamReader(process.getErrorStream())), this.stderr, latch));
        out_.start();
        err_.start();
        try {
            latch.await();
            exitValue = process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            process.getInputStream().close();
            process.getOutputStream().close();
            process.getErrorStream().close();
            process.destroy();
        }
        return exitValue;
    }

    public void redirectOutput(Writer w) {
        if (w == null) {
            throw new NullPointerException("w");
        }
        this.stdout = w;
    }

    public void redirectError(Writer w) {
        if (w == null) {
            throw new NullPointerException("w");
        }
        this.stderr = w;
    }

    public static void main(String[] args) throws Exception {
        Logger l = Logger.getLogger("me");
        l.setLevel(Level.ALL);
        Processes p = new Processes(new File("bash"));
        p.setLog(l);
        p.setArguments("-c", "ls -al /tmp");
        double start = System.currentTimeMillis();
        int exitValue = p.exec();
        double end = System.currentTimeMillis();
        System.out.println("Time " + (end - start));
    }

    private static class Handler
    implements Runnable {
        Reader r;
        CountDownLatch latch;
        Writer w;

        Handler(Reader r, Writer w, CountDownLatch latch) {
            this.r = r;
            this.w = w;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            char[] b = new char[4096];
            try {
                int n;
                while ((n = this.r.read(b)) != -1) {
                    this.w.write(b, 0, n);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
            finally {
                try {
                    this.w.flush();
                    this.w.close();
                    this.r.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
            this.latch.countDown();
        }
    }
}

