/*
 * Decompiled with CFR 0.152.
 */
package oms3;

import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import oms3.Access;
import oms3.ComponentException;
import oms3.Conversions;
import oms3.FieldContent;
import oms3.Notification;

class FieldAccess
implements Access {
    Notification ens;
    Field field;
    Object comp;
    FieldContent data;
    private static final Logger log = Logger.getLogger("oms3.sim");

    FieldAccess(Object target, Field field, Notification ens) {
        this.field = field;
        this.comp = target;
        this.ens = ens;
        field.setAccessible(true);
    }

    @Override
    public FieldContent getData() {
        if (this.data == null) {
            this.data = new FieldContent();
        }
        return this.data;
    }

    @Override
    public void setData(FieldContent data) {
        if (this.data != null) {
            throw new ComponentException("Attempt to set @In field twice: " + this.comp + "." + this.field.getName());
        }
        this.data = data;
    }

    @Override
    public boolean isValid() {
        return this.data != null && this.field.isAccessible();
    }

    @Override
    public void in() throws Exception {
        if (this.data == null) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("@In not connected : " + this.toString() + ", using default value.");
            }
            return;
        }
        Object val = this.data.getValue();
        if (this.ens.shouldFire()) {
            Notification.DataflowEvent e = new Notification.DataflowEvent(this.ens.getController(), this, val);
            this.ens.fireIn(e);
            val = e.getValue();
        }
        if (val != null && this.field.getType() != val.getClass() && !this.field.getType().isAssignableFrom(val.getClass())) {
            val = Conversions.convert(val, this.field.getType());
        }
        this.setFieldValue(val);
    }

    @Override
    public void out() throws Exception {
        Object val = this.getFieldValue();
        if (this.ens.shouldFire()) {
            Notification.DataflowEvent e = new Notification.DataflowEvent(this.ens.getController(), this, val);
            this.ens.fireOut(e);
            val = e.getValue();
        }
        if (this.data != null) {
            this.data.setValue(val);
        }
    }

    @Override
    public Object getComponent() {
        return this.comp;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public final Object getFieldValue() throws Exception {
        return this.field.get(this.comp);
    }

    @Override
    public final void setFieldValue(Object o) throws Exception {
        this.field.set(this.comp, o);
    }

    public String toString() {
        return this.comp + "%" + this.field.getName() + " - " + (this.data == null ? null : this.data.getValue());
    }
}

