/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.quadtree;

import com.bbn.openmap.util.DataOrganizer;
import com.bbn.openmap.util.quadtree.QuadTreeNode;
import java.io.Serializable;
import java.util.Vector;

public class QuadTree
implements DataOrganizer,
Serializable {
    static final long serialVersionUID = -7707825592455579873L;
    protected QuadTreeNode top;

    public QuadTree() {
        this(90.0f, -180.0f, -90.0f, 180.0f, 20, -1.0f);
    }

    public QuadTree(float north, float west, float south, float east, int maxItems) {
        this(north, west, south, east, maxItems, -1.0f);
    }

    public QuadTree(int up, int left, int down, int right, int maxItems) {
        this(up, left, down, right, maxItems, 5.0f);
    }

    public QuadTree(float north, float west, float south, float east, int maxItems, float minSize) {
        this.top = new QuadTreeNode(north, west, south, east, maxItems, minSize);
    }

    public boolean put(float lat, float lon, Object obj) {
        return this.top.put(lat, lon, obj);
    }

    public Object remove(float lat, float lon, Object obj) {
        return this.top.remove(lat, lon, obj);
    }

    public void clear() {
        this.top.clear();
    }

    public Object get(float lat, float lon) {
        return this.top.get(lat, lon);
    }

    public Object get(float lat, float lon, double withinDistance) {
        return this.top.get(lat, lon, withinDistance);
    }

    public Vector get(float north, float west, float south, float east) {
        return this.get(north, west, south, east, new Vector());
    }

    public Vector get(float north, float west, float south, float east, Vector vector) {
        if (vector == null) {
            vector = new Vector();
        }
        if (west > east || (double)Math.abs(west - east) < 0.001) {
            return this.top.get(north, west, south, 180.0f, this.top.get(north, -180.0f, south, east, vector));
        }
        return this.top.get(north, west, south, east, vector);
    }
}

