/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.propertyEditor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FilePropertyEditor
extends PropertyEditorSupport
implements ActionListener {
    protected JButton button;
    protected JTextField textField = new JTextField(15);

    public FilePropertyEditor() {
        this.button = new JButton(this.getButtonTitle());
        this.textField.setEditable(this.isTextFieldEditable());
    }

    public String getButtonTitle() {
        return "Set";
    }

    public boolean isTextFieldEditable() {
        return false;
    }

    public int getFileSelectionMode() {
        return 0;
    }

    public boolean isMultiSelectEnabled() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = this.getFileChooser();
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            String newFilename = chooser.getSelectedFile().getAbsolutePath();
            newFilename = this.cleanUpName(newFilename);
            this.textField.setText(newFilename);
            this.firePropertyChange();
        }
    }

    protected String cleanUpName(String name) {
        return name.replace('\\', '/').trim();
    }

    public Component getCustomEditor() {
        this.button.addActionListener(this);
        JPanel jp = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        jp.setLayout(gridbag);
        c.weightx = 1.0;
        c.fill = 2;
        gridbag.setConstraints(this.textField, c);
        jp.add(this.textField);
        c.weightx = 0.0;
        c.anchor = 13;
        c.fill = 0;
        gridbag.setConstraints(this.button, c);
        jp.add(this.button);
        return jp;
    }

    public JFileChooser getFileChooser() {
        JFileChooser chooser = new JFileChooser(this.getLastLocation());
        chooser.setFileSelectionMode(this.getFileSelectionMode());
        chooser.setMultiSelectionEnabled(this.isMultiSelectEnabled());
        return chooser;
    }

    public void setValue(Object someObj) {
        if (someObj instanceof String) {
            this.textField.setText((String)someObj);
        }
    }

    public String getAsText() {
        return this.textField.getText();
    }

    public String getLastLocation() {
        String substring;
        String currentLocation = this.getAsText();
        int sepChar = 47;
        int lastSepIndex = currentLocation.lastIndexOf(sepChar);
        currentLocation = currentLocation.equals("") || lastSepIndex == -1 ? null : (substring = currentLocation.substring(0, lastSepIndex));
        return currentLocation;
    }
}

