/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropertyStringFormatException;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;

public class PropUtils {
    public static final String DUMMY_MARKER_NAME = "DUMMY_MARKER_NAME";
    public static final String keyValueSeparators = "=: \t\r\n\f";
    public static final String strictKeyValueSeparators = "=:";
    public static final String whiteSpaceChars = " \t\r\n\f";
    public static final String propertySeparators = "&";

    public static Vector parseSpacedMarkers(String markerList) {
        return PropUtils.parseMarkers(markerList, " ");
    }

    public static Vector parseMarkers(String markerList, String delim) {
        Vector<String> vector = null;
        if (markerList == null) {
            Debug.message("propertiesdetail", "PropUtils: marker list null!");
            return new Vector(0);
        }
        if (Debug.debugging("propertiesdetail")) {
            Debug.output("PropertyHandler: parsing marker list |" + markerList + "|");
        }
        markerList = markerList.replace('\"', '\u0000');
        StringTokenizer tokens = new StringTokenizer(markerList, delim);
        vector = new Vector<String>(tokens.countTokens());
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken().trim();
            vector.addElement(name);
        }
        return vector;
    }

    public static Properties parsePropertyList(String list) throws PropertyStringFormatException {
        return PropUtils.parsePropertyList(list, propertySeparators, keyValueSeparators);
    }

    public static Properties parsePropertyList(String list, String propertySeparators, String keyValueSeparators) throws PropertyStringFormatException {
        Properties props = new Properties();
        Vector keyValuePairs = PropUtils.parseMarkers(list, propertySeparators);
        for (int i = 0; i < keyValuePairs.size(); ++i) {
            StringTokenizer tokens = new StringTokenizer((String)keyValuePairs.elementAt(i), keyValueSeparators);
            try {
                String key = tokens.nextToken().trim();
                String value = tokens.nextToken().trim();
                props.put(key, value);
                continue;
            }
            catch (NoSuchElementException nsee) {
                throw new PropertyStringFormatException(list);
            }
        }
        return props;
    }

    public static void copyProperties(Properties from, Properties to) {
        Enumeration<Object> keys = from.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            to.put(key, from.getProperty(key));
        }
    }

    public static boolean loadProperties(Properties props, String dir, String file) {
        File propsFile = new File(dir, file);
        try {
            FileInputStream propsStream = new FileInputStream(propsFile);
            props.load(propsStream);
            if (Debug.debugging("properties")) {
                Debug.output("PropUtils: Found " + propsFile);
            }
            return true;
        }
        catch (FileNotFoundException e) {
            if (Debug.debugging("properties")) {
                Debug.output("PropUtils: File not found -  \"" + propsFile + "\"");
            }
        }
        catch (IOException e) {
            Debug.error("PropUtils: Caught IO Exception reading \"" + propsFile + "\"");
            e.printStackTrace();
        }
        catch (AccessControlException ace) {
            // empty catch block
        }
        return false;
    }

    public static boolean loadProperties(Properties properties, InputStream propsIn) {
        try {
            properties.load(propsIn);
            return true;
        }
        catch (IOException e) {
            if (Debug.debugging("properties")) {
                Debug.error("PropUtils: Caught IOException loading properties from InputStream.");
            }
            return false;
        }
    }

    public static Properties promptUserForProperties() {
        JFileChooser fileChooser = new JFileChooser();
        int retvalue = fileChooser.showOpenDialog(null);
        Properties props = new Properties();
        if (retvalue != 0) {
            return props;
        }
        try {
            FileInputStream inputStream = new FileInputStream(fileChooser.getSelectedFile());
            props.load(inputStream);
            return props;
        }
        catch (Exception ioe) {
            System.err.println("PropUtils.promptUserForProperties: Exception reading properties file.");
            System.err.println(ioe.getMessage());
            ioe.printStackTrace();
            return props;
        }
    }

    public static String getScopedPropertyPrefix(PropertyConsumer pc) {
        return PropUtils.getScopedPropertyPrefix(pc.getPropertyPrefix());
    }

    public static String getScopedPropertyPrefix(String pre) {
        if (pre == null || pre.length() == 0) {
            return "";
        }
        if (pre.endsWith(".")) {
            return pre;
        }
        return pre + ".";
    }

    public static String getDummyMarkerForPropertyInfo(String realComponentPropertyPrefix, String anyDesiredScoper) {
        return DUMMY_MARKER_NAME + (anyDesiredScoper != null ? anyDesiredScoper : "") + "." + (realComponentPropertyPrefix != null ? realComponentPropertyPrefix : "");
    }

    public static String decodeDummyMarkerFromPropertyInfo(String possibleDummyMarker) {
        int lastDot;
        if (possibleDummyMarker != null && possibleDummyMarker.startsWith(DUMMY_MARKER_NAME) && (lastDot = possibleDummyMarker.lastIndexOf(".")) != -1) {
            possibleDummyMarker = possibleDummyMarker.substring(lastDot + 1);
        }
        return possibleDummyMarker;
    }

    public static String unnull(String prop) {
        if (prop == null) {
            return "";
        }
        return prop;
    }

    public static String[] initPathsFromProperties(Properties p, String propName) {
        return PropUtils.initPathsFromProperties(p, propName, null);
    }

    public static String[] initPathsFromProperties(Properties p, String propName, String[] defaultPaths) {
        String[] ret = PropUtils.stringArrayFromProperties(p, propName, ";");
        if (ret == null) {
            ret = defaultPaths;
        }
        return ret;
    }

    public static int intFromProperties(Properties p, String propName, int defaultValue) {
        int ret = defaultValue;
        String intString = p.getProperty(propName);
        if (intString != null) {
            try {
                ret = Integer.parseInt(intString.trim());
            }
            catch (NumberFormatException e) {
                ret = defaultValue;
            }
        }
        return ret;
    }

    public static float floatFromProperties(Properties p, String propName, float defaultValue) {
        float ret = defaultValue;
        String floatString = p.getProperty(propName);
        if (floatString != null) {
            try {
                ret = Float.parseFloat(floatString.trim());
            }
            catch (NumberFormatException e) {
                ret = defaultValue;
            }
        }
        return ret;
    }

    public static boolean booleanFromProperties(Properties p, String propName, boolean defaultValue) {
        boolean ret = defaultValue;
        String booleanString = p.getProperty(propName);
        if (booleanString != null) {
            ret = booleanString.trim().toLowerCase().equals("true");
        }
        return ret;
    }

    public static Object objectFromProperties(Properties p, String propName) {
        Object ret = null;
        String objectName = p.getProperty(propName);
        if (objectName != null) {
            ret = ComponentFactory.create(objectName);
        }
        return ret;
    }

    public static String[] stringArrayFromProperties(Properties p, String propName, String tok) {
        String[] ret = null;
        String raw = p.getProperty(propName);
        if (raw != null && raw.length() != 0) {
            try {
                StringTokenizer token = new StringTokenizer(raw, tok);
                int numPaths = token.countTokens();
                ret = new String[numPaths];
                for (int i = 0; i < numPaths; ++i) {
                    ret[i] = token.nextToken();
                }
                return ret;
            }
            catch (NoSuchElementException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static double doubleFromProperties(Properties p, String propName, double defaultValue) {
        double ret = defaultValue;
        String doubleString = p.getProperty(propName);
        if (doubleString != null) {
            try {
                ret = Double.parseDouble(doubleString.trim());
            }
            catch (NumberFormatException e) {
                ret = defaultValue;
            }
        }
        return ret;
    }

    public static long longFromProperties(Properties p, String propName, long defaultValue) {
        long ret = defaultValue;
        String longString = p.getProperty(propName);
        if (longString != null) {
            try {
                ret = Long.parseLong(longString.trim());
            }
            catch (NumberFormatException e) {
                ret = defaultValue;
            }
        }
        return ret;
    }

    public static Color parseColorFromProperties(Properties p, String propName, String dfault) throws NumberFormatException {
        return ColorFactory.parseColorFromProperties(p, propName, dfault, false);
    }

    public static Paint parseColorFromProperties(Properties p, String propName, Paint dfault) {
        return ColorFactory.parseColorFromProperties(p, propName, dfault);
    }

    public static Color parseColor(String colorString) throws NumberFormatException {
        return ColorFactory.parseColor(colorString, false);
    }

    public static String getProperty(Color color) {
        StringBuffer hexstring = new StringBuffer(Integer.toHexString(color.getRGB()));
        while (hexstring.length() < 8) {
            hexstring.insert(0, '0');
        }
        return hexstring.toString();
    }

    public static String[] getPropertiesAsStringArray(Properties props) {
        int size = props.size();
        String[] ret = new String[size * 2];
        int count = 0;
        Enumeration<?> things = props.propertyNames();
        while (things.hasMoreElements()) {
            ret[count] = (String)things.nextElement();
            ret[count + 1] = props.getProperty(ret[count]);
            count += 2;
        }
        return ret;
    }

    public static URL getResourceOrFileOrURL(String name) throws MalformedURLException {
        return PropUtils.getResourceOrFileOrURL(null, name);
    }

    public static URL getResourceOrFileOrURL(Object askingClass, String name) throws MalformedURLException {
        return PropUtils.getResourceOrFileOrURL(askingClass.getClass(), name);
    }

    public static URL getResourceOrFileOrURL(Class askingClass, String name) throws MalformedURLException {
        boolean DEBUG = Debug.debugging("proputils");
        if (name == null) {
            if (DEBUG) {
                Debug.output("PropUtils.getROFOU(): null file name");
            }
            return null;
        }
        URL retval = null;
        if (DEBUG) {
            Debug.output("PropUtils.getROFOU(): looking for " + name);
        }
        if (askingClass != null) {
            if (DEBUG) {
                Debug.output("PropUtils.getROFOU(): checking as resource");
            }
            retval = askingClass.getResource(name);
        }
        if (retval == null) {
            if (DEBUG) {
                Debug.output("PropUtils.getROFOU(): checking in general classpath");
            }
            retval = Thread.currentThread().getContextClassLoader().getResource(name);
        }
        if (retval == null && !Environment.isApplet()) {
            if (DEBUG) {
                Debug.output("PropUtils.getROFOU(): checking with ClassLoader");
            }
            retval = ClassLoader.getSystemResource("share/" + name);
        }
        if (retval == null && Environment.isApplet()) {
            if (DEBUG) {
                Debug.output("PropUtils.getROFOU(): checking with URLClassLoader");
            }
            URL[] cba = new URL[]{Environment.getApplet().getCodeBase()};
            URLClassLoader ucl = URLClassLoader.newInstance(cba);
            retval = ucl.getResource(name);
        }
        if (retval == null) {
            if (DEBUG) {
                Debug.output("PropUtils.getROFOU(): not found as resource");
            }
            try {
                File file = new File(name);
                if (file.exists()) {
                    retval = file.toURL();
                    if (DEBUG) {
                        Debug.output("PropUtils.getROFOU(): found as file :)");
                    }
                } else {
                    if (DEBUG) {
                        Debug.output("PropUtils.getROFOU(): Not a file, checking as URL");
                    }
                    retval = new URL(name);
                    InputStream is = retval.openStream();
                    is.close();
                    if (DEBUG) {
                        Debug.output("PropUtils.getROFOU(): OK as URL :)");
                    }
                }
            }
            catch (IOException ioe) {
                retval = null;
            }
            catch (AccessControlException ace) {
                Debug.error("PropUtils: AccessControlException trying to access " + name);
                retval = null;
            }
            catch (Exception e) {
                Debug.error("PropUtils: caught exception " + e.getMessage());
                retval = null;
            }
        }
        if (DEBUG) {
            if (retval != null) {
                Debug.output("Resource " + name + "=" + retval.toString());
            } else {
                Debug.output("Resource " + name + " can't be found...");
            }
        }
        return retval;
    }

    public static Properties setI18NPropertyInfo(I18n i18n, Properties info, Class classToSetFor, String propertyName, String label, String tooltip, String editor) {
        if (info == null) {
            info = new Properties();
        }
        if (i18n != null) {
            String internString;
            if (tooltip != null) {
                internString = i18n.get(classToSetFor, propertyName, 3, tooltip);
                info.put(propertyName, internString);
            }
            if (label != null) {
                internString = i18n.get(classToSetFor, propertyName, label);
                info.put(propertyName + ".label", internString);
            }
            if (editor != null) {
                info.put(propertyName + ".editor", editor);
            }
        }
        return info;
    }
}

