/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.beanbox;

import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.PropertyHandler;
import com.bbn.openmap.gui.OMToolComponent;
import com.bbn.openmap.tools.beanbox.DoOnBean;
import com.bbn.openmap.tools.beanbox.FileExtension;
import com.bbn.openmap.tools.beanbox.JarInfo;
import com.bbn.openmap.tools.beanbox.JarLoader;
import com.bbn.openmap.tools.dnd.DefaultTransferableObject;
import com.bbn.openmap.util.Debug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.Introspector;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class BeanPanel
extends OMToolComponent
implements Serializable {
    public static ImageIcon defaultBeanIcon;
    public static final String defaultKey = "beanpanel";
    private BeanHelper helper = new BeanHelper();
    private Vector beanLabels = new Vector();
    private Vector beanNames = new Vector();
    private Vector beanIcons = new Vector();
    private Vector beanJars = new Vector();
    private Vector beanInfos = new Vector();
    private Vector beanPaths;
    private HashMap toolbarTabInfo;
    private Vector toolbarTabOrder;
    private DragSource dragSource;
    private JTabbedPane tabbedPane;
    private Cursor customCursor;
    private JFrame beanFrame = null;
    static /* synthetic */ Class class$com$bbn$openmap$tools$beanbox$BeanPanel;

    public BeanPanel() {
        this.setKey(defaultKey);
        this.beanPaths = new Vector();
        this.toolbarTabInfo = new HashMap();
        this.toolbarTabOrder = new Vector();
        this.tabbedPane = new JTabbedPane();
        this.dragSource = new DragSource();
        ComponentDragSourceListener tdsl = new ComponentDragSourceListener();
        this.dragSource.createDefaultDragGestureRecognizer(this.tabbedPane, 2, new ComponentDragGestureListener(tdsl));
        if (Debug.debugging(defaultKey)) {
            Debug.output("Created Bean Panel");
        }
    }

    public BeanPanel(Properties props) {
        this();
        if (props == null) {
            throw new IllegalArgumentException("null props");
        }
        this.loadBeanPanelProperties(props);
        this.initGui();
    }

    public Container getFace() {
        if (Debug.debugging(defaultKey)) {
            Debug.output("Enter> BP::getFace");
        }
        JButton button = null;
        if (defaultBeanIcon == null) {
            if (Debug.debugging(defaultKey)) {
                Debug.output("Enter> null defaultBeanIcon!");
            }
            button = new JButton("Bean Box");
        } else {
            button = new JButton(defaultBeanIcon);
        }
        button.setBorderPainted(false);
        button.setToolTipText("Bean Box");
        button.setMargin(new Insets(0, 0, 0, 0));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeanPanel.this.showBeanPanel(true);
            }
        });
        if (Debug.debugging(defaultKey)) {
            Debug.output("Exit> BP::getFace");
        }
        button.setVisible(this.getUseAsTool());
        return button;
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof LayerHandler) {
            // empty if block
        }
    }

    public static synchronized BeanInfo findBeanInfo(String beanClassName) {
        String[] beanInfoPaths = Introspector.getBeanInfoSearchPath();
        String infoClassName = beanClassName + "BeanInfo";
        Class<?> infoClass = null;
        try {
            infoClass = Class.forName(infoClassName);
            return (BeanInfo)infoClass.newInstance();
        }
        catch (Exception ex) {
            for (int i = 0; i < beanInfoPaths.length; ++i) {
                int index = beanClassName.lastIndexOf(".");
                String classNameWithDot = beanClassName.substring(index);
                infoClassName = beanInfoPaths[i] + classNameWithDot + "BeanInfo";
                try {
                    infoClass = Class.forName(infoClassName);
                    break;
                }
                catch (ClassNotFoundException ex2) {
                    continue;
                }
            }
            Object retval = null;
            if (infoClass != null) {
                try {
                    retval = infoClass.newInstance();
                }
                catch (Exception ex3) {
                    // empty catch block
                }
            }
            return retval;
        }
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof LayerHandler) {
            // empty if block
        }
        if (someObj instanceof PropertyHandler) {
            Properties props = ((PropertyHandler)someObj).getProperties();
            this.loadBeanPanelProperties(props);
        }
    }

    private void loadBeans() {
        Vector jarNames = this.getJarNames();
        for (int i = 0; i < jarNames.size(); ++i) {
            String jarFileName = (String)jarNames.elementAt(i);
            try {
                JarLoader.loadJarDoOnBean(jarFileName, this.helper);
                continue;
            }
            catch (Throwable th) {
                System.out.println("BP::loadBeans: jar load failed: " + jarFileName);
                th.printStackTrace();
            }
        }
    }

    private Vector getJarNames() {
        Vector<String> result = new Vector<String>();
        if (this.beanPaths == null || this.beanPaths.size() == 0) {
            return result;
        }
        for (int i = 0; i < this.beanPaths.size(); ++i) {
            String path = (String)this.beanPaths.get(i);
            File dir = new File(path);
            if (!dir.isDirectory()) {
                System.out.println("BP::getJarNames: " + dir + " is not a directory!");
                continue;
            }
            String[] names = dir.list(new FileExtension(".jar"));
            for (int j = 0; j < names.length; ++j) {
                result.add(dir.getPath() + File.separatorChar + names[j]);
            }
        }
        return result;
    }

    private JList createTab(Vector beanClassNames) {
        JList list = new JList();
        if (beanClassNames == null || beanClassNames.size() == 0) {
            return list;
        }
        Vector<String> labels = new Vector<String>();
        for (int i = 0; i < beanClassNames.size(); ++i) {
            String beanClassName = (String)beanClassNames.get(i);
            int index = this.beanNames.indexOf(beanClassName);
            if (index < 0) {
                System.out.println("BP::createTab: could not locate beanClass=" + beanClassName);
                continue;
            }
            String label = (String)this.beanLabels.get(index);
            labels.add(label);
        }
        list.setListData(labels);
        list.setCellRenderer(new MyCellRenderer());
        MouseEventForwarder forwarder = new MouseEventForwarder();
        list.addMouseListener(forwarder);
        list.addMouseMotionListener(forwarder);
        return list;
    }

    private synchronized void showBeanPanel(boolean isVisible) {
        if (this.beanFrame != null) {
            this.beanFrame.setVisible(isVisible);
            if (isVisible) {
                this.beanFrame.toFront();
            }
            return;
        }
        if (!isVisible) {
            return;
        }
        this.initGui();
        this.beanFrame = new JFrame("Bean Box");
        this.beanFrame.getContentPane().setLayout(new BoxLayout(this.beanFrame.getContentPane(), 1));
        this.beanFrame.getContentPane().add(this);
        this.beanFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                BeanPanel.this.beanFrame.setVisible(false);
            }
        });
        this.beanFrame.pack();
        this.beanFrame.setVisible(true);
    }

    private synchronized void initGui() {
        this.loadBeans();
        this.setLayout(new BorderLayout());
        if (this.toolbarTabOrder != null && this.toolbarTabOrder.size() > 0) {
            MouseEventForwarder forwarder = new MouseEventForwarder();
            this.tabbedPane.addMouseListener(forwarder);
            this.tabbedPane.addMouseMotionListener(forwarder);
            for (int i = 0; i < this.toolbarTabOrder.size(); ++i) {
                String tabName = (String)this.toolbarTabOrder.get(i);
                Vector beanClassNames = (Vector)this.toolbarTabInfo.get(tabName);
                JList listTab = this.createTab(beanClassNames);
                this.tabbedPane.addTab(tabName, listTab);
            }
            JScrollPane sPane = new JScrollPane(this.tabbedPane);
            this.add((Component)sPane, "Center");
        }
        this.setPreferredSize(new Dimension(400, 250));
        this.setMinimumSize(new Dimension(400, 250));
    }

    private synchronized void loadBeanPanelProperties(Properties props) {
        this.loadBeanPaths(props);
        this.loadToolBarTabInfo(props);
    }

    private void loadBeanPaths(Properties props) {
        String beanPathsStr;
        if (Debug.debugging(defaultKey)) {
            Debug.output("Enter> BP::loadBeanPaths");
        }
        if ((beanPathsStr = props.getProperty("beanpanel.beans.path")) != null && (beanPathsStr = beanPathsStr.trim()).length() != 0) {
            StringTokenizer st = new StringTokenizer(beanPathsStr, " ");
            while (st.hasMoreTokens()) {
                this.beanPaths.add(st.nextToken());
            }
        }
        if (Debug.debugging(defaultKey)) {
            Debug.output("beanPaths=" + this.beanPaths);
        }
        if (Debug.debugging(defaultKey)) {
            Debug.output("Exit> BP::loadBeanPaths");
        }
    }

    private void loadToolBarTabInfo(Properties props) {
        String tabsStr;
        if (Debug.debugging(defaultKey)) {
            Debug.output("Enter> BP::loadToolBarTabInfo");
        }
        if ((tabsStr = props.getProperty("beanpanel.tabs")) != null && (tabsStr = tabsStr.trim()).length() != 0) {
            StringTokenizer st = new StringTokenizer(tabsStr, " ");
            while (st.hasMoreTokens()) {
                String tab = st.nextToken();
                String tabName = props.getProperty("beanpanel." + tab + ".name");
                String beanClassesStr = props.getProperty("beanpanel." + tab + ".beans");
                if (beanClassesStr == null || (beanClassesStr = beanClassesStr.trim()).length() <= 0) continue;
                StringTokenizer st2 = new StringTokenizer(beanClassesStr, " ");
                Vector<String> beanClassNames = new Vector<String>();
                while (st2.hasMoreTokens()) {
                    beanClassNames.add(st2.nextToken());
                }
                this.toolbarTabInfo.put(tabName, beanClassNames);
                this.toolbarTabOrder.add(tabName);
            }
        }
        if (Debug.debugging(defaultKey)) {
            Debug.output("toolbarTabInfo=" + this.toolbarTabInfo);
        }
        if (Debug.debugging(defaultKey)) {
            Debug.output("toolbarTabOrder=" + this.toolbarTabOrder);
        }
        if (Debug.debugging(defaultKey)) {
            Debug.output("Exit> BP::loadToolBarTabInfo");
        }
    }

    private void setDragCursor(int index) {
        ImageIcon icon = (ImageIcon)this.beanIcons.get(index);
        Point offset = new Point(0, 0);
        Image img = icon.getImage();
        this.customCursor = Toolkit.getDefaultToolkit().createCustomCursor(img, offset, "");
    }

    private static void setDefaultIcon() {
        URL url;
        if (defaultBeanIcon == null && (url = (class$com$bbn$openmap$tools$beanbox$BeanPanel == null ? (class$com$bbn$openmap$tools$beanbox$BeanPanel = BeanPanel.class$("com.bbn.openmap.tools.beanbox.BeanPanel")) : class$com$bbn$openmap$tools$beanbox$BeanPanel).getResource("bluebean.gif")) != null) {
            defaultBeanIcon = new ImageIcon(url);
        }
    }

    private static void augmentBeanInfoSearchPath() {
        if (Debug.debugging(defaultKey)) {
            Debug.output("Enter> augmentBeanInfoSearchPath");
        }
        String beanInfoPath = System.getProperty("bean.infos.path");
        if (Debug.debugging(defaultKey)) {
            Debug.output("beanInfoPath=" + beanInfoPath);
        }
        if (beanInfoPath == null || (beanInfoPath = beanInfoPath.trim()).length() == 0) {
            return;
        }
        String[] oldPath = Introspector.getBeanInfoSearchPath();
        Vector<String> newPath = new Vector<String>();
        if (oldPath != null && oldPath.length > 0) {
            newPath.addAll(Arrays.asList(oldPath));
        }
        if (Debug.debugging(defaultKey)) {
            Debug.output("oldPath=" + newPath);
        }
        StringTokenizer st = new StringTokenizer(beanInfoPath, ", ");
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            if (newPath.contains(path)) continue;
            newPath.add(path);
        }
        Introspector.setBeanInfoSearchPath(newPath.toArray(new String[0]));
        if (Debug.debugging(defaultKey)) {
            Debug.output("UPDATED> beanInfo search path to: " + newPath);
        }
        if (Debug.debugging(defaultKey)) {
            Debug.output("Exit> augmentBeanInfoSearchPath");
        }
    }

    public static void main(String[] args) {
        Properties props = new Properties();
        props.setProperty("beanpanel.beans.path", "");
        props.setProperty("beanpanel.tabs", "tab1 tab2 tab3");
        props.setProperty("beanpanel.tab1.name", "Generic");
        props.setProperty("beanpanel.tab1.beans", "com.bbn.openmap.examples.beanbox.SimpleBeanObject");
        props.setProperty("beanpanel.tab2.name", "Container");
        props.setProperty("beanpanel.tab2.beans", "com.bbn.openmap.examples.beanbox.SimpleBeanContainer");
        props.setProperty("beanpanel.tab3.name", "Military");
        props.setProperty("beanpanel.tab3.beans", "com.bbn.openmap.examples.beanbox.Fighter");
        BeanPanel bp = new BeanPanel(props);
        JFrame beanFrame = new JFrame("Bean Box");
        beanFrame.getContentPane().add(bp);
        beanFrame.pack();
        beanFrame.setVisible(true);
        try {
            Thread.sleep(2000L);
            beanFrame.setVisible(false);
            Thread.sleep(2000L);
            beanFrame.setVisible(true);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BeanPanel.augmentBeanInfoSearchPath();
        BeanPanel.setDefaultIcon();
    }

    private class MouseEventForwarder
    extends MouseInputAdapter {
        private MouseEventForwarder() {
        }

        public void mousePressed(MouseEvent e) {
            Component comp = (Component)e.getSource();
            Container parent = comp.getParent();
            if (parent != null) {
                Point newPoint = SwingUtilities.convertPoint(comp, e.getPoint(), parent);
                e.translatePoint(newPoint.x - e.getX(), newPoint.y - e.getY());
                MouseEvent me = new MouseEvent(parent, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
                parent.dispatchEvent(me);
            }
        }

        public void mouseReleased(MouseEvent e) {
            Component comp = (Component)e.getSource();
            Container parent = comp.getParent();
            if (parent != null) {
                Point newPoint = SwingUtilities.convertPoint(comp, e.getPoint(), parent);
                e.translatePoint(newPoint.x - e.getX(), newPoint.y - e.getY());
                MouseEvent me = new MouseEvent(parent, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
                parent.dispatchEvent(me);
            }
        }

        public void mouseDragged(MouseEvent e) {
            Component comp = (Component)e.getSource();
            Container parent = comp.getParent();
            if (parent != null) {
                Point newPoint = SwingUtilities.convertPoint(comp, e.getPoint(), parent);
                e.translatePoint(newPoint.x - e.getX(), newPoint.y - e.getY());
                MouseEvent me = new MouseEvent(parent, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
                parent.dispatchEvent(me);
            }
        }
    }

    private class ComponentDragGestureListener
    implements DragGestureListener {
        ComponentDragSourceListener tdsl;

        public ComponentDragGestureListener(ComponentDragSourceListener tdsl) {
            this.tdsl = tdsl;
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            if (Debug.debugging(BeanPanel.defaultKey)) {
                Debug.output("dragGestureRecognized");
            }
            JList list = (JList)BeanPanel.this.tabbedPane.getComponentAt(BeanPanel.this.tabbedPane.getSelectedIndex());
            String label = null;
            label = (String)list.getSelectedValue();
            if (label != null) {
                int index = BeanPanel.this.beanLabels.indexOf(label);
                if (index == -1) {
                    System.out.println("ERROR> BP::dragGestureRecognized: no beanlabel found for label=" + label);
                    return;
                }
                String beanName = (String)BeanPanel.this.beanNames.get(index);
                Object bean = null;
                try {
                    bean = Beans.instantiate(null, beanName);
                    if (Debug.debugging(BeanPanel.defaultKey)) {
                        Debug.output("Instantiated bean: " + bean);
                    }
                    BeanPanel.this.setDragCursor(index);
                }
                catch (Exception ex) {
                    System.out.println("ERROR> BP::dragGestureRecognized:  error instantiating bean");
                    ex.printStackTrace();
                    return;
                }
                BeanInfo bi = (BeanInfo)BeanPanel.this.beanInfos.get(index);
                Vector<Object> beanTransferData = new Vector<Object>();
                beanTransferData.add(bean);
                beanTransferData.add(bi);
                beanTransferData.add(new Boolean(false));
                BeanPanel.this.dragSource.startDrag(dge, BeanPanel.this.customCursor, new DefaultTransferableObject(beanTransferData), this.tdsl);
                BeanPanel.this.revalidate();
                BeanPanel.this.repaint();
            }
        }
    }

    private class ComponentDragSourceListener
    implements DragSourceListener {
        private ComponentDragSourceListener() {
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (Debug.debugging(BeanPanel.defaultKey)) {
                Debug.output("dragDropEnd (drag)");
            }
        }

        public void dragEnter(DragSourceDragEvent dsde) {
            int action;
            if (Debug.debugging(BeanPanel.defaultKey)) {
                Debug.output("dragEnter (drag)");
            }
            if ((action = dsde.getDropAction()) == 2) {
                dsde.getDragSourceContext().setCursor(BeanPanel.this.customCursor);
            } else {
                dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        public void dragOver(DragSourceDragEvent dsde) {
            int action;
            if (Debug.debugging(BeanPanel.defaultKey)) {
                Debug.output("dragOver (drag)");
            }
            if ((action = dsde.getDropAction()) == 2) {
                dsde.getDragSourceContext().setCursor(BeanPanel.this.customCursor);
            } else {
                dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
            int action;
            if (Debug.debugging(BeanPanel.defaultKey)) {
                Debug.output("dropActionChanged (drag)");
            }
            if ((action = dsde.getDropAction()) == 2) {
                dsde.getDragSourceContext().setCursor(BeanPanel.this.customCursor);
            } else {
                dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        public void dragExit(DragSourceEvent dse) {
            if (Debug.debugging(BeanPanel.defaultKey)) {
                Debug.output("dragExit (drag)");
            }
            dse.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    private class MyCellRenderer
    implements ListCellRenderer {
        private MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            JLabel label = new JLabel(s);
            label.setHorizontalAlignment(2);
            int i = BeanPanel.this.beanLabels.indexOf(s);
            ImageIcon icon = (ImageIcon)BeanPanel.this.beanIcons.get(i);
            label.setIcon(icon);
            if (isSelected) {
                label.setBackground(list.getSelectionBackground());
                label.setForeground(list.getSelectionForeground());
            } else {
                label.setBackground(list.getBackground());
                label.setForeground(list.getForeground());
            }
            label.setEnabled(list.isEnabled());
            label.setFont(list.getFont());
            label.setOpaque(true);
            return label;
        }
    }

    private class BeanHelper
    implements DoOnBean {
        private BeanHelper() {
        }

        public void action(JarInfo ji, BeanInfo bi, Class beanClass, String beanName) {
            String label;
            if (Debug.debugging(BeanPanel.defaultKey)) {
                Debug.output("Enter> ACTION: " + beanName);
            }
            if (Debug.debugging(BeanPanel.defaultKey)) {
                Debug.output("ACTION: " + beanName);
            }
            if (Debug.debugging(BeanPanel.defaultKey)) {
                Debug.output("bi: " + bi);
            }
            if (Debug.debugging(BeanPanel.defaultKey)) {
                Debug.output("bi.getClass(): " + bi.getClass());
            }
            ImageIcon icon = null;
            if (beanName.equals(beanClass.getName())) {
                int index;
                BeanDescriptor bd;
                if (Debug.debugging(BeanPanel.defaultKey)) {
                    Debug.output("beanName=" + beanName);
                }
                label = (bd = bi.getBeanDescriptor()) != null ? bd.getDisplayName() : ((index = beanName.lastIndexOf(".")) >= 0 && index < beanName.length() - 1 ? beanName.substring(index + 1, beanName.length()) : beanName);
                if (Debug.debugging(BeanPanel.defaultKey)) {
                    Debug.output("label=" + label);
                }
                Image img = bi.getIcon(2);
                if (Debug.debugging(BeanPanel.defaultKey)) {
                    Debug.output("img=" + img);
                }
                if (img == null) {
                    URL url = this.getClass().getResource("bluebean.gif");
                    icon = new ImageIcon(url);
                } else {
                    icon = new ImageIcon(img);
                }
            } else {
                label = beanName;
                int ix = beanName.lastIndexOf(46);
                if (ix >= 0) {
                    label = beanName.substring(ix + 1);
                }
            }
            BeanPanel.this.beanLabels.addElement(label);
            BeanPanel.this.beanNames.addElement(beanClass.getName());
            BeanPanel.this.beanIcons.addElement(icon);
            BeanPanel.this.beanJars.addElement(ji);
            BeanPanel.this.beanInfos.addElement(bi);
            if (Debug.debugging(BeanPanel.defaultKey)) {
                Debug.output("Exit> ACTION: " + beanName);
            }
        }

        public void error(String message, Exception e) {
            if (Debug.debugging(BeanPanel.defaultKey)) {
                Debug.output("BP::BeanHelper:error " + message);
            }
            e.printStackTrace();
        }

        public void error(String message) {
            if (Debug.debugging(BeanPanel.defaultKey)) {
                Debug.output("BP::BeanHelper:error " + message);
            }
        }
    }
}

