/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.Environment;
import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.DrawUtil;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.Planet;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.util.ArrayList;

public abstract class Proj
implements Projection,
Cloneable {
    public static final transient float NORTH_POLE = 1.5707964f;
    public static final transient float SOUTH_POLE = -1.5707964f;
    public static final transient float DATELINE = (float)Math.PI;
    public static final transient int MIN_WIDTH = 10;
    public static final transient int MIN_HEIGHT = 10;
    protected static transient int NUM_DEFAULT_CIRCLE_VERTS = 64;
    protected static transient int NUM_DEFAULT_GREAT_SEGS = 512;
    protected int pixelsPerMeter = Planet.defaultPixelsPerMeter;
    protected float planetRadius = 6378137.0f;
    protected float planetPixelRadius = this.planetRadius * (float)this.pixelsPerMeter;
    protected float planetPixelCircumference = (float)Math.PI * 2 * this.planetPixelRadius;
    protected int width = 640;
    protected int height = 480;
    protected float minscale = 1.0f;
    protected float maxscale;
    protected float scale = this.maxscale = this.planetPixelCircumference / (float)this.width;
    protected float scaled_radius = this.planetPixelRadius / this.scale;
    protected float ctrLat = 0.0f;
    protected float ctrLon = 0.0f;
    protected int type = 2;
    protected String projID = null;
    protected Mercator mercator = null;
    protected static transient int XTHRESHOLD = 16384;
    protected transient int XSCALE_THRESHOLD = 1000000;

    public Proj(LatLonPoint center, float s, int w, int h, int type) {
        if (Debug.debugging("proj")) {
            Debug.output("Proj()");
        }
        this.type = type;
        this.setParms(center, s, w, h);
        this.projID = null;
        if (!(this instanceof Mercator)) {
            this.mercator = new Mercator(center, this.scale, this.width, this.height);
        }
    }

    protected void init() {
        this.pixelsPerMeter = Planet.defaultPixelsPerMeter;
        this.planetRadius = 6378137.0f;
        this.planetPixelRadius = this.planetRadius * (float)this.pixelsPerMeter;
        this.planetPixelCircumference = (float)Math.PI * 2 * this.planetPixelRadius;
        this.minscale = 1.0f;
        this.maxscale = this.planetPixelCircumference / (float)this.width;
        this.scaled_radius = this.planetPixelRadius / this.scale;
    }

    public void setPPM(int ppm) {
        this.pixelsPerMeter = ppm;
        if (this.pixelsPerMeter < 1) {
            this.pixelsPerMeter = 1;
        }
        this.computeParameters();
    }

    public int getPPM() {
        return this.pixelsPerMeter;
    }

    public void setPlanetRadius(float radius) {
        this.planetRadius = radius;
        if (this.planetRadius < 1.0f) {
            this.planetRadius = 1.0f;
        }
        this.computeParameters();
    }

    public float getPlanetRadius() {
        return this.planetRadius;
    }

    public float getPlanetPixelRadius() {
        return this.planetPixelRadius;
    }

    public float getPlanetPixelCircumference() {
        return this.planetPixelCircumference;
    }

    public void setScale(float s) {
        this.scale = s;
        if (this.scale < this.minscale) {
            this.scale = this.minscale;
            this.computeParameters();
        } else if (this.scale > this.maxscale) {
            this.scale = this.maxscale;
            this.computeParameters();
        }
        this.computeParameters();
        this.projID = null;
    }

    public void setMinScale(float s) {
        if (s > this.maxscale) {
            return;
        }
        this.minscale = s;
        if (this.scale < this.minscale) {
            this.scale = this.minscale;
        }
        this.computeParameters();
        this.projID = null;
    }

    public void setMaxScale(float s) {
        if (s < this.minscale) {
            return;
        }
        this.maxscale = s;
        if (this.scale > this.maxscale) {
            this.scale = this.maxscale;
        }
        this.computeParameters();
        this.projID = null;
    }

    public float getScale() {
        return this.scale;
    }

    public float getMaxScale() {
        return this.maxscale;
    }

    public float getMinScale() {
        return this.minscale;
    }

    public void setCenter(float lat, float lon) {
        this.ctrLat = this.normalize_latitude(ProjMath.degToRad(lat));
        this.ctrLon = Proj.wrap_longitude(ProjMath.degToRad(lon));
        this.computeParameters();
        this.projID = null;
    }

    public void setCenter(LatLonPoint pt) {
        this.setCenter(pt.getLatitude(), pt.getLongitude());
    }

    public LatLonPoint getCenter() {
        return new LatLonPoint(this.ctrLat, this.ctrLon, true);
    }

    public void setWidth(int width) {
        this.width = width;
        if (this.width < 10) {
            Debug.message("proj", "Proj.setWidth: width too small!");
            this.width = 10;
        }
        this.computeParameters();
        this.projID = null;
    }

    public void setHeight(int height) {
        this.height = height;
        if (this.height < 10) {
            Debug.message("proj", "Proj.setHeight: height too small!");
            this.height = 10;
        }
        this.computeParameters();
        this.projID = null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected void setParms(LatLonPoint center, float scale, int width, int height) {
        this.ctrLat = this.normalize_latitude(center.radlat_);
        this.ctrLon = Proj.wrap_longitude(center.radlon_);
        this.width = width;
        if (this.width < 10) {
            Debug.message("proj", "Proj.setParms: width too small!");
            this.width = 10;
        }
        this.height = height;
        if (this.height < 10) {
            Debug.message("proj", "Proj.setParms: height too small!");
            this.height = 10;
        }
        this.init();
        this.scale = scale;
        if (this.scale < this.minscale) {
            this.scale = this.minscale;
        } else if (this.scale > this.maxscale) {
            this.scale = this.maxscale;
        }
        this.computeParameters();
    }

    public int getProjectionType() {
        return this.type;
    }

    protected void setProjectionID() {
        this.projID = (":" + this.type + ":" + this.scale + ":" + this.ctrLat + ":" + this.ctrLon + ":" + this.width + ":" + this.height + ":").intern();
    }

    public String getProjectionID() {
        if (this.projID == null) {
            this.setProjectionID();
        }
        return this.projID;
    }

    protected abstract void computeParameters();

    public abstract float normalize_latitude(float var1);

    public static final float wrap_longitude(float lon) {
        return ProjMath.wrap_longitude(lon);
    }

    public String toString() {
        return " radius=" + this.planetRadius + " ppm=" + this.pixelsPerMeter + " center(" + ProjMath.radToDeg(this.ctrLat) + "," + ProjMath.radToDeg(this.ctrLon) + ") scale=" + this.scale + " maxscale=" + this.maxscale + " minscale=" + this.minscale + " width=" + this.width + " height=" + this.height + "]";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Projection) {
            return this.getProjectionID() == ((Projection)o).getProjectionID();
        }
        return false;
    }

    public int hashCode() {
        return this.getProjectionID().hashCode();
    }

    public Projection makeClone() {
        return (Projection)this.clone();
    }

    public Object clone() {
        try {
            Proj proj = (Proj)super.clone();
            if (this.mercator != null) {
                proj.mercator = (Mercator)this.mercator.clone();
            }
            return proj;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean isPlotable(LatLonPoint llpoint) {
        return this.isPlotable(llpoint.getLatitude(), llpoint.getLongitude());
    }

    public final Point forward(LatLonPoint llp) {
        return this.forward(llp.radlat_, llp.radlon_, new Point(0, 0), true);
    }

    public final Point forward(float lat, float lon) {
        return this.forward(lat, lon, new Point(0, 0));
    }

    public final LatLonPoint inverse(Point point) {
        return this.inverse(point, new LatLonPoint());
    }

    public final LatLonPoint inverse(int x, int y) {
        return this.inverse(x, y, new LatLonPoint());
    }

    public ArrayList forwardLine(LatLonPoint ll1, LatLonPoint ll2, int ltype, int nsegs) {
        float[] rawllpts = new float[]{ll1.radlat_, ll1.radlon_, ll2.radlat_, ll2.radlon_};
        return this.forwardPoly(rawllpts, ltype, nsegs, false);
    }

    public ArrayList forwardLine(LatLonPoint ll1, LatLonPoint ll2, int ltype) {
        return this.forwardLine(ll1, ll2, ltype, -1);
    }

    public ArrayList forwardRect(LatLonPoint ll1, LatLonPoint ll2, int ltype, int nsegs, boolean isFilled) {
        float[] rawllpts = new float[]{ll1.radlat_, ll1.radlon_, ll1.radlat_, ll2.radlon_, ll2.radlat_, ll2.radlon_, ll2.radlat_, ll1.radlon_, ll1.radlat_, ll1.radlon_};
        return this.forwardPoly(rawllpts, ltype, nsegs, isFilled);
    }

    public ArrayList forwardRect(LatLonPoint ll1, LatLonPoint ll2, int ltype, int nsegs) {
        return this.forwardRect(ll1, ll2, ltype, nsegs, false);
    }

    public ArrayList forwardRect(LatLonPoint ll1, LatLonPoint ll2, int ltype) {
        return this.forwardRect(ll1, ll2, ltype, -1, false);
    }

    public ArrayList forwardArc(LatLonPoint c, boolean radians, float radius, float start, float extent) {
        return this.forwardArc(c, radians, radius, -1, start, extent, 0);
    }

    public ArrayList forwardArc(LatLonPoint c, boolean radians, float radius, int nverts, float start, float extent) {
        return this.forwardArc(c, radians, radius, nverts, start, extent, 0);
    }

    public ArrayList forwardArc(LatLonPoint c, boolean radians, float radius, int nverts, float start, float extent, int arcType) {
        float[] rawllpts;
        if (nverts < 3) {
            nverts = NUM_DEFAULT_CIRCLE_VERTS;
        }
        switch (arcType) {
            case 2: {
                rawllpts = new float[(nverts << 1) + 4];
                break;
            }
            case 1: {
                rawllpts = new float[(nverts << 1) + 2];
                break;
            }
            default: {
                rawllpts = new float[nverts << 1];
            }
        }
        GreatCircle.earth_circle(c.radlat_, c.radlon_, radians ? radius : ProjMath.degToRad(radius), radians ? start : ProjMath.degToRad(start), radians ? extent : ProjMath.degToRad(extent), nverts, rawllpts);
        int linetype = 1;
        boolean isFilled = false;
        switch (arcType) {
            case 2: {
                rawllpts[rawllpts.length - 4] = c.radlat_;
                rawllpts[rawllpts.length - 3] = c.radlon_;
            }
            case 1: {
                rawllpts[rawllpts.length - 2] = rawllpts[0];
                rawllpts[rawllpts.length - 1] = rawllpts[1];
                linetype = 3;
                isFilled = true;
                break;
            }
        }
        return this.forwardPoly(rawllpts, linetype, -1, isFilled);
    }

    public ArrayList forwardCircle(LatLonPoint c, boolean radians, float radius) {
        return this.forwardCircle(c, radians, radius, -1, false);
    }

    public ArrayList forwardCircle(LatLonPoint c, boolean radians, float radius, int nverts) {
        return this.forwardCircle(c, radians, radius, nverts, false);
    }

    public ArrayList forwardCircle(LatLonPoint c, boolean radians, float radius, int nverts, boolean isFilled) {
        if (nverts < 3) {
            nverts = NUM_DEFAULT_CIRCLE_VERTS;
        }
        float[] rawllpts = new float[(nverts << 1) + 2];
        GreatCircle.earth_circle(c.radlat_, c.radlon_, radians ? radius : ProjMath.degToRad(radius), nverts, rawllpts);
        rawllpts[rawllpts.length - 2] = rawllpts[0];
        rawllpts[rawllpts.length - 1] = rawllpts[1];
        return this.forwardPoly(rawllpts, 1, -1, isFilled);
    }

    public ArrayList forwardPoly(float[] rawllpts, int ltype, int nsegs) {
        return this.forwardPoly(rawllpts, ltype, nsegs, false);
    }

    public ArrayList forwardPoly(float[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        ArrayList stuff = this._forwardPoly(rawllpts, ltype, nsegs, isFilled);
        if (Environment.doingXWindowsWorkaround && this.scale <= (float)this.XSCALE_THRESHOLD) {
            int size = stuff.size();
            for (int i = 0; i < size; i += 2) {
                int[] xpts = (int[])stuff.get(i);
                int[] ypts = (int[])stuff.get(i + 1);
                for (int j = 0; j < xpts.length; ++j) {
                    if (xpts[j] <= -XTHRESHOLD) {
                        xpts[j] = -XTHRESHOLD;
                    } else if (xpts[j] >= XTHRESHOLD) {
                        xpts[j] = XTHRESHOLD;
                    }
                    if (ypts[j] <= -XTHRESHOLD) {
                        ypts[j] = -XTHRESHOLD;
                        continue;
                    }
                    if (ypts[j] < XTHRESHOLD) continue;
                    ypts[j] = XTHRESHOLD;
                }
                stuff.set(i, xpts);
                stuff.set(i + 1, ypts);
            }
        }
        return stuff;
    }

    protected abstract ArrayList _forwardPoly(float[] var1, int var2, int var3, boolean var4);

    protected ArrayList forwardRhumbPoly(float[] rawllpts, int nsegs, boolean isFilled) {
        if (this instanceof Mercator) {
            return this._forwardPoly(rawllpts, 1, nsegs, isFilled);
        }
        int flag = 0;
        int xadj = 0;
        int totalpts = 0;
        Point from = new Point(0, 0);
        Point to = new Point(0, 0);
        LatLonPoint llp = null;
        int len = rawllpts.length;
        float[][] augllpts = new float[len >>> 1][0];
        this.mercator.forward(rawllpts[0], rawllpts[1], from, true);
        int xp = from.x;
        int i = 0;
        for (int n = 2; n < len; n += 2) {
            this.mercator.forward(rawllpts[n], rawllpts[n + 1], to, true);
            if (Math.abs(xp - to.x) >= this.mercator.half_world) {
                xadj = (flag += xp < to.x ? -1 : 1) * this.mercator.world.x;
            }
            xp = to.x;
            if (flag != 0) {
                to.x += xadj;
            }
            augllpts[i] = this.mercator.rhumbProject(from, to, false, nsegs);
            totalpts += augllpts[i].length;
            from.x = to.x;
            from.y = to.y;
            ++i;
        }
        llp = this.mercator.inverse(from);
        augllpts[i] = new float[2];
        augllpts[i][0] = llp.radlat_;
        augllpts[i][1] = llp.radlon_;
        float[] newllpts = new float[totalpts += 2];
        int pos = 0;
        for (i = 0; i < augllpts.length; ++i) {
            System.arraycopy(augllpts[i], 0, newllpts, pos, augllpts[i].length);
            pos += augllpts[i].length;
        }
        augllpts = null;
        return this._forwardPoly(newllpts, 1, -1, isFilled);
    }

    protected ArrayList forwardGreatPoly(float[] rawllpts, int nsegs, boolean isFilled) {
        int totalpts = 0;
        Point from = new Point();
        Point to = new Point();
        int end = rawllpts.length >>> 1;
        float[][] augllpts = new float[end][0];
        --end;
        this.forward(rawllpts[0], rawllpts[1], from, true);
        int i = 0;
        int j = 0;
        int k = 2;
        while (i < end) {
            this.forward(rawllpts[k], rawllpts[k + 1], to, true);
            augllpts[i] = this.getGreatVertices(rawllpts[j], rawllpts[j + 1], rawllpts[k], rawllpts[k + 1], from, to, false, nsegs);
            from.x = to.x;
            from.y = to.y;
            totalpts += augllpts[i].length;
            ++i;
            j += 2;
            k += 2;
        }
        augllpts[i] = new float[2];
        augllpts[i][0] = rawllpts[j];
        augllpts[i][1] = rawllpts[j + 1];
        float[] newllpts = new float[totalpts += 2];
        int pos = 0;
        for (i = 0; i < augllpts.length; ++i) {
            System.arraycopy(augllpts[i], 0, newllpts, pos, augllpts[i].length);
            pos += augllpts[i].length;
        }
        augllpts = null;
        return this._forwardPoly(newllpts, 1, -1, isFilled);
    }

    private float[] getGreatVertices(float latp, float lonp, float latn, float lonn, Point from, Point to, boolean include_last, int nsegs) {
        if (nsegs < 1) {
            int dist = DrawUtil.pixel_distance(from.x, from.y, to.x, to.y);
            nsegs = dist >> 3;
            if (nsegs == 0) {
                nsegs = 1;
            } else if (nsegs > NUM_DEFAULT_GREAT_SEGS) {
                nsegs = NUM_DEFAULT_GREAT_SEGS;
            }
        }
        return GreatCircle.great_circle(latp, lonp, latn, lonn, nsegs, include_last);
    }

    public ArrayList forwardRaster(LatLonPoint llNW, LatLonPoint llSE, Image image) {
        Debug.error("Proj.forwardRaster(): unimplemented!");
        return null;
    }

    public boolean isComplicatedLineType(int ltype) {
        switch (ltype) {
            case 1: {
                return false;
            }
            case 2: {
                return this.getProjectionType() != 2;
            }
            case 3: {
                return true;
            }
        }
        Debug.error("Proj.isComplicatedLineType: invalid LineType!");
        return false;
    }

    protected ArrayList doPolyDispatch(float[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        switch (ltype) {
            case 2: {
                return this.forwardRhumbPoly(rawllpts, nsegs, isFilled);
            }
            case 3: {
                return this.forwardGreatPoly(rawllpts, nsegs, isFilled);
            }
            case 1: {
                Debug.error("Proj.doPolyDispatch: Bad Dispatch!\n");
                return new ArrayList(0);
            }
        }
        Debug.error("Proj.doPolyDispatch: Invalid LType!\n");
        return new ArrayList(0);
    }

    public void pan(float Az, float c) {
        this.setCenter(GreatCircle.spherical_between(this.ctrLat, this.ctrLon, ProjMath.degToRad(c), ProjMath.degToRad(Az)));
    }

    public void pan(float Az) {
        this.pan(Az, 45.0f);
    }

    public final void panNW() {
        this.pan(-45.0f);
    }

    public final void panNW(float c) {
        this.pan(-45.0f);
    }

    public final void panN() {
        this.pan(0.0f);
    }

    public final void panN(float c) {
        this.pan(0.0f);
    }

    public final void panNE() {
        this.pan(45.0f);
    }

    public final void panNE(float c) {
        this.pan(45.0f);
    }

    public final void panE() {
        this.pan(90.0f);
    }

    public final void panE(float c) {
        this.pan(90.0f);
    }

    public final void panSE() {
        this.pan(135.0f);
    }

    public final void panSE(float c) {
        this.pan(135.0f);
    }

    public final void panS() {
        this.pan(180.0f);
    }

    public final void panS(float c) {
        this.pan(180.0f);
    }

    public final void panSW() {
        this.pan(-135.0f);
    }

    public final void panSW(float c) {
        this.pan(-135.0f);
    }

    public final void panW() {
        this.pan(-90.0f);
    }

    public final void panW(float c) {
        this.pan(-90.0f);
    }

    public abstract void drawBackground(Graphics2D var1, Paint var2);

    public abstract void drawBackground(Graphics var1);

    public String getName() {
        return "Proj";
    }

    public float getScale(LatLonPoint ll1, LatLonPoint ll2, Point point1, Point point2) {
        try {
            float pixPerDegree;
            int deltaPix;
            float deltaDegrees;
            float dx = Math.abs(point2.x - point1.x);
            float dy = Math.abs(point2.y - point1.y);
            if (dx < dy) {
                float dlat;
                deltaDegrees = dlat = Math.abs(ll1.getLatitude() - ll2.getLatitude());
                deltaPix = this.getHeight();
                pixPerDegree = this.getPlanetPixelCircumference() / 360.0f;
            } else {
                float lon2;
                float lon1;
                if (point1.x > point2.x) {
                    float lat1 = ll1.getLatitude();
                    lon1 = ll1.getLongitude();
                    ll1.setLatLon(ll2);
                    ll2.setLatLon(lat1, lon1);
                }
                float dlon = (lon1 = ll1.getLongitude()) > (lon2 = ll2.getLongitude()) ? 180.0f - lon1 + (180.0f + lon2) : lon2 - lon1;
                deltaDegrees = dlon;
                deltaPix = this.getWidth();
                pixPerDegree = this.getPlanetPixelCircumference() / 360.0f;
            }
            return pixPerDegree / ((float)deltaPix / deltaDegrees);
        }
        catch (NullPointerException npe) {
            Debug.error("ProjMath.getScale(): caught null pointer exception.");
            return Float.MAX_VALUE;
        }
    }
}

