/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MoreMath;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class LambertConformal
extends Proj {
    public static final transient String LambertConformalName = "Lambert Conformal";
    public static final transient int LambertConformalType = 4200;
    private double lambert_sp_one;
    private double lambert_sp_two;
    private double centralMeridian;
    double angle_sp_one;
    double angle_sp_two;
    double distance_sp_one;
    double distance_sp_two;
    double lambert_lamn;
    double lambert_lamf;
    int locationCenterXPixel = 0;
    int locationCenterYPixel = 0;
    double locationCenterXLambert = 0.0;
    double locationCenterYLambert = 0.0;
    double locationPixelsPerLambert = 0.0;
    double locationOriginX = 0.0;
    double locationOriginY = 0.0;
    double referenceLatitude = 0.0;
    double falseEasting = 0.0;
    double falseNorthing = 0.0;
    protected Point plotablePoint = new Point();

    protected LambertConformal(LatLonPoint center, float scale, int width, int height) {
        super(center, scale, width, height, 4200);
    }

    protected LambertConformal(LatLonPoint center, float scale, int width, int height, float centralMeridian, float sp_one, float sp_two) {
        this(center, scale, width, height, centralMeridian, sp_one, sp_two, 0.0, 0.0, 0.0);
    }

    public LambertConformal(LatLonPoint center, float scale, int width, int height, double centralMeridian, double sp_one, double sp_two, double reference_latitude, double falseEasting, double falseNorthing) {
        super(center, scale, width, height, 4200);
        this.centralMeridian = centralMeridian;
        this.lambert_sp_one = sp_one;
        this.lambert_sp_two = sp_two;
        this.referenceLatitude = reference_latitude;
        this.falseEasting = falseEasting;
        this.falseNorthing = falseNorthing;
        this.computeParameters();
    }

    public void computeParameters() {
        this.angle_sp_one = ProjMath.degToRad(90.0 - this.lambert_sp_one);
        this.angle_sp_two = ProjMath.degToRad(90.0 - this.lambert_sp_two);
        this.distance_sp_one = Math.log(Math.sin(this.angle_sp_one)) - Math.log(Math.sin(this.angle_sp_two));
        this.distance_sp_two = Math.log(Math.tan(this.angle_sp_one / 2.0)) - Math.log(Math.tan(this.angle_sp_two / 2.0));
        this.lambert_lamn = this.distance_sp_one / this.distance_sp_two;
        this.lambert_lamf = Math.sin(this.angle_sp_one) / (this.lambert_lamn * Math.pow(Math.tan(this.angle_sp_one / 2.0), this.lambert_lamn));
        this.locationCenterXPixel = (int)((double)this.getWidth() / 2.0 + 0.5);
        this.locationCenterYPixel = (int)((double)this.getHeight() / 2.0 + 0.5);
        this.locationPixelsPerLambert = this.getMaxScale() / this.getScale() * 100.0f;
        Point2D.Double lp = new Point2D.Double();
        LatLonPoint origin = new LatLonPoint(this.referenceLatitude, this.centralMeridian);
        this.LLToWorld(origin.getLatitude(), origin.getLongitude(), lp);
        this.locationOriginX = ((Point2D)lp).getX();
        this.locationOriginY = ((Point2D)lp).getY();
        LatLonPoint center = this.getCenter();
        this.LLToWorld(center.getLatitude(), center.getLongitude(), lp);
        this.locationCenterXLambert = ((Point2D)lp).getX();
        this.locationCenterYLambert = ((Point2D)lp).getY();
        if (Debug.debugging("lcc")) {
            Debug.output("Creating LambertConformal: center x = " + this.locationCenterXLambert + ", center y = " + this.locationCenterYLambert);
            Debug.output("Creating LambertConformal: origin x = " + this.locationOriginX + ", origin y = " + this.locationOriginY);
        }
    }

    public float normalize_latitude(float lat) {
        if (lat > 1.5707964f) {
            return 1.5707964f;
        }
        if (lat < -1.5707964f) {
            return -1.5707964f;
        }
        return lat;
    }

    public void pan(float Az) {
        if (MoreMath.approximately_equal(Math.abs(Az), 180.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width / 2, this.height));
        } else if (MoreMath.approximately_equal(Az, -135.0f, 0.01f)) {
            this.setCenter(this.inverse(0, this.height));
        } else if (MoreMath.approximately_equal(Az, -90.0f, 0.01f)) {
            this.setCenter(this.inverse(0, this.height / 2));
        } else if (MoreMath.approximately_equal(Az, -45.0f, 0.01f)) {
            this.setCenter(this.inverse(0, 0));
        } else if (MoreMath.approximately_equal(Az, 0.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width / 2, 0));
        } else if (MoreMath.approximately_equal(Az, 45.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width, 0));
        } else if (MoreMath.approximately_equal(Az, 90.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width, this.height / 2));
        } else if (MoreMath.approximately_equal(Az, 135.0f, 0.01f)) {
            this.setCenter(this.inverse(this.width, this.height));
        } else {
            super.pan(Az);
        }
    }

    public Point2D LLToWorld(double lat, double lon, Point2D lp) {
        double formula_one = Math.abs(this.lambert_lamf) * Math.pow(Math.abs(Math.tan(ProjMath.degToRad(90.0 - lat) / 2.0)), Math.abs(this.lambert_lamn));
        lon -= this.centralMeridian;
        while (lon > 180.0) {
            lon -= 360.0;
        }
        while (lon <= -180.0) {
            lon += 360.0;
        }
        double formula_two = ProjMath.degToRad(Math.abs(this.lambert_lamn) * lon);
        lp.setLocation(formula_one * Math.sin(formula_two), formula_one * Math.cos(formula_two));
        return lp;
    }

    public Point LLToPixel(double lat, double lon, Point p) {
        Point2D.Double lp = new Point2D.Double();
        this.LLToWorld(lat, lon, lp);
        double xrel = ((Point2D)lp).getX() - this.locationCenterXLambert;
        double yrel = ((Point2D)lp).getY() - this.locationCenterYLambert;
        xrel = (double)this.locationCenterXPixel + xrel * this.locationPixelsPerLambert + 0.5;
        yrel = (double)this.locationCenterYPixel + yrel * this.locationPixelsPerLambert + 0.5;
        if (p == null) {
            p = new Point();
        }
        p.x = (int)xrel;
        p.y = (int)yrel;
        return p;
    }

    public LatLonPoint worldToLL(double x, double y, LatLonPoint llp) {
        double formula_two = Math.atan2(x, y);
        double formula_one = Math.sqrt(x * x + y * y);
        double lon = ProjMath.radToDeg(formula_two / Math.abs(this.lambert_lamn)) + this.centralMeridian;
        double lat = 90.0 - ProjMath.radToDeg(Math.atan2(Math.pow(formula_one / Math.abs(this.lambert_lamf), 1.0 / this.lambert_lamn), 1.0) * 2.0);
        if (this.lambert_lamn < 0.0) {
            lat *= -1.0;
        }
        llp.setLatLon((float)lat, (float)lon);
        return llp;
    }

    public LatLonPoint pixelToLL(int xabs, int yabs, LatLonPoint llp) {
        double x = this.locationCenterXLambert + (double)(xabs - this.locationCenterXPixel) / this.locationPixelsPerLambert;
        double y = this.locationCenterYLambert + (double)(yabs - this.locationCenterYPixel) / this.locationPixelsPerLambert;
        this.worldToLL(x, y, llp);
        return llp;
    }

    public boolean isPlotable(float lat, float lon) {
        if (lat < -55.0f) {
            return false;
        }
        this.forward(lat, lon, this.plotablePoint);
        return this.plotablePoint.x >= 0 && this.plotablePoint.x < this.width && this.plotablePoint.y >= 0 && this.plotablePoint.y < this.height;
    }

    public boolean isPlotable(LatLonPoint llpoint) {
        return this.isPlotable(llpoint.getLatitude(), llpoint.getLongitude());
    }

    public Point forward(LatLonPoint pt, Point p) {
        return this.forward(pt.radlat_, pt.radlon_, p, true);
    }

    public Point forward(float lat, float lon, Point p) {
        return this.forward(lat, lon, p, false);
    }

    public Point forward(float lat, float lon, Point p, boolean isRadian) {
        if (isRadian) {
            this.LLToPixel(ProjMath.radToDeg(lat), ProjMath.radToDeg(lon), p);
        } else {
            this.LLToPixel(lat, lon, p);
        }
        return p;
    }

    public LatLonPoint inverse(int x, int y, LatLonPoint llp) {
        if (llp == null) {
            llp = new LatLonPoint();
        }
        this.pixelToLL(x, y, llp);
        return llp;
    }

    public LatLonPoint inverse(Point pt, LatLonPoint llp) {
        return this.inverse(pt.x, pt.y, llp);
    }

    public LatLonPoint getUpperLeft() {
        return new LatLonPoint(90.0, -180.0);
    }

    public LatLonPoint getLowerRight() {
        return new LatLonPoint(-90.0, 180.0);
    }

    public String getName() {
        return LambertConformalName;
    }

    public boolean forwardRaw(float[] rawllpts, int rawoff, int[] xcoords, int[] ycoords, boolean[] visible, int copyoff, int copylen) {
        boolean visibleTotal = false;
        Point temp = new Point();
        int end = copylen + copyoff;
        int i = copyoff;
        int j = rawoff;
        while (i < end) {
            this.forward(rawllpts[j], rawllpts[j + 1], temp, true);
            xcoords[i] = temp.x;
            ycoords[i] = temp.y;
            boolean bl = visible[i] = 0 <= temp.x && temp.x <= this.width && 0 <= temp.y && temp.y <= this.height;
            if (visible[i] && !visibleTotal) {
                visibleTotal = true;
            }
            ++i;
            j += 2;
        }
        return visibleTotal;
    }

    protected ArrayList _forwardPoly(float[] rawllpts, int ltype, int nsegs, boolean isFilled) {
        int len = rawllpts.length >> 1;
        if (len < 2) {
            return new ArrayList(0);
        }
        float minlat = ProjMath.degToRad(-60.0f);
        boolean allBelowMinLat = true;
        int i = 0;
        int j = 0;
        while (i < len) {
            float l = rawllpts[j + 1];
            while (l < 0.0f) {
                l = (float)((double)l + Math.PI * 2);
            }
            if (rawllpts[j] > minlat) {
                allBelowMinLat = false;
            }
            ++i;
            j += 2;
        }
        if (allBelowMinLat) {
            return new ArrayList(0);
        }
        if (this.isComplicatedLineType(ltype)) {
            return this.doPolyDispatch(rawllpts, ltype, nsegs, isFilled);
        }
        Point temp = new Point();
        int[] xs = new int[len];
        int[] ys = new int[len];
        i = 0;
        j = 0;
        while (i < len) {
            temp = this.forward(rawllpts[j], rawllpts[j + 1], temp, true);
            xs[i] = temp.x;
            ys[i] = temp.y;
            ++i;
            j += 2;
        }
        ArrayList<int[]> ret_val = new ArrayList<int[]>(2);
        ret_val.add(xs);
        ret_val.add(ys);
        return ret_val;
    }

    public void drawBackground(Graphics2D g, Paint paint) {
        g.setPaint(paint);
        this.drawBackground(g);
    }

    public void drawBackground(Graphics g) {
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public static void main(String[] argv) {
        Debug.init();
        Debug.put("Lambert");
        LambertConformal proj = null;
        Debug.message("Lambert", "proj = new LambertConformal(new LatLonPoint(0.0f, 0.0f), 100000.0f, 620, 480);");
        proj = new LambertConformal(new LatLonPoint(0.0f, 0.0f), 100000.0f, 620, 480);
        proj.centralMeridian = 15.0;
        proj.lambert_sp_one = 21.67f;
        proj.lambert_sp_two = 48.33f;
        Debug.message("Lambert", "" + proj.inverse(0, 0));
    }
}

