/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.event;

import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.event.SelectionEvent;
import com.bbn.openmap.omGraphics.event.SelectionListener;
import com.bbn.openmap.tools.drawing.DrawingToolRequestor;
import java.util.Vector;

public class SelectionSupport {
    private transient Vector listeners;
    private Object source;

    public SelectionSupport(Object src) {
        this.source = src;
    }

    public synchronized void addSelectionListener(SelectionListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    public synchronized void removeSelectionListener(SelectionListener listener) {
        if (this.listeners != null) {
            this.listeners.removeElement(listener);
        }
    }

    public synchronized void clearSelectionListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSelection(OMGraphic omg, DrawingToolRequestor dtr, boolean isSelected) {
        Vector targets;
        SelectionSupport selectionSupport = this;
        synchronized (selectionSupport) {
            if (this.listeners == null) {
                return;
            }
            targets = (Vector)this.listeners.clone();
        }
        SelectionEvent evt = new SelectionEvent(this.source, omg, dtr, isSelected);
        for (int i = 0; i < targets.size(); ++i) {
            SelectionListener target = (SelectionListener)targets.elementAt(i);
            target.selectionNotification(evt);
        }
    }
}

