/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMSpline;
import com.bbn.openmap.omGraphics.awt.Revertable;
import com.bbn.openmap.omGraphics.awt.ShapeDecorator;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Paint;

public class OMDecoratedSpline
extends OMSpline
implements Revertable {
    private ShapeDecorator decorator = new ShapeDecorator();

    public OMDecoratedSpline() {
        this.initDecorations();
    }

    public OMDecoratedSpline(float[] llPoints, int units, int lType) {
        super(llPoints, units, lType);
        this.initDecorations();
    }

    public OMDecoratedSpline(float[] llPoints, int units, int lType, int nsegs) {
        super(llPoints, units, lType, nsegs);
        this.initDecorations();
    }

    public OMDecoratedSpline(int[] xypoints) {
        super(xypoints);
        this.initDecorations();
    }

    public OMDecoratedSpline(int[] xPoints, int[] yPoints) {
        super(xPoints, yPoints);
        this.initDecorations();
    }

    public OMDecoratedSpline(float latPoint, float lonPoint, int[] xypoints, int cMode) {
        super(latPoint, lonPoint, xypoints, cMode);
        this.initDecorations();
    }

    public OMDecoratedSpline(float latPoint, float lonPoint, int[] xPoints, int[] yPoints, int cMode) {
        super(latPoint, lonPoint, xPoints, yPoints, cMode);
        this.initDecorations();
    }

    public void render(Graphics g) {
        if (this.decorator == null) {
            super.render(g);
            return;
        }
        if (this.shape != null) {
            this.decorator.draw(g, this.shape);
            return;
        }
        if (this.getNeedToRegenerate() || !this.isVisible()) {
            return;
        }
        int[][] xpts = this.xpoints;
        int[][] ypts = this.ypoints;
        int len = xpts.length;
        Paint displayPaint = this.getDisplayPaint();
        Paint fillPaint = this.getFillPaint();
        boolean isFillClear = OMDecoratedSpline.isClear(fillPaint);
        boolean isLineClear = OMDecoratedSpline.isClear(displayPaint);
        try {
            for (int i = 0; i < len; ++i) {
                int[] _x = xpts[i];
                int[] _y = ypts[i];
                if (this.isPolygon) {
                    if (!isFillClear) {
                        this.setGraphicsForFill(g);
                        g.fillPolygon(_x, _y, _x.length);
                    }
                    if (isLineClear && this.edgeMatchesFill) continue;
                    this.setGraphicsForEdge(g);
                    this.decorator.draw(g, _x, _y);
                    continue;
                }
                this.setGraphicsForEdge(g);
                this.decorator.draw(g, _x, _y);
            }
        }
        catch (Exception e) {
            Debug.output("OMDecoratedSpline: caught Java rendering exception\n" + e.getMessage());
        }
    }

    public ShapeDecorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(ShapeDecorator decorator) {
        this.decorator = decorator;
    }

    protected void initDecorations() {
    }

    public void revert() {
        this.decorator.revert();
    }
}

