/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMAbstractLine;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.proj.DrawUtil;
import com.bbn.openmap.util.Debug;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import java.util.Vector;

public class OMArrowHead {
    public static final int ARROWHEAD_DIRECTION_FORWARD = 0;
    public static final int ARROWHEAD_DIRECTION_BACKWARD = 1;
    public static final int ARROWHEAD_DIRECTION_BOTH = 2;
    protected static int DEFAULT_WINGTIP = 5;
    protected static int DEFAULT_WINGLENGTH = 20;
    protected Shape shape = null;
    protected int arrowDirectionType = 0;
    protected int location = 100;
    protected int wingTip = 5;
    protected int wingLength = 20;

    public OMArrowHead(int arrowDirectionType, int location) {
        this(arrowDirectionType, location, DEFAULT_WINGTIP, DEFAULT_WINGLENGTH);
    }

    public OMArrowHead(int arrowDirectionType, int location, int wingtip, int winglength) {
        this.arrowDirectionType = arrowDirectionType;
        this.setLocation(location);
        this.wingTip = wingtip;
        this.wingLength = winglength;
    }

    public void generate(OMAbstractLine omal) {
        this.shape = this.wingTip > 0 && this.wingLength > 0 && omal != null ? OMArrowHead.createArrowHeads(this.arrowDirectionType, this.location, omal, this.wingTip, this.wingLength) : null;
    }

    public void render(Graphics g) {
        if (this.shape != null) {
            ((Graphics2D)g).fill(this.shape);
        }
    }

    public static GeneralPath createArrowHeads(int arrowDirectionType, int location, OMAbstractLine line) {
        return OMArrowHead.createArrowHeads(arrowDirectionType, location, line, DEFAULT_WINGTIP, DEFAULT_WINGLENGTH);
    }

    public static GeneralPath createArrowHeads(int arrowDirectionType, int location, OMAbstractLine line, int wingTip, int wingLength) {
        Point[] locPoints = OMArrowHead.locateArrowHeads(arrowDirectionType, location, line);
        if (locPoints == null) {
            return null;
        }
        Stroke stroke = line.getStroke();
        float lineWidth = 1.0f;
        if (stroke instanceof BasicStroke) {
            lineWidth = ((BasicStroke)stroke).getLineWidth();
            wingTip = (int)((float)wingTip + lineWidth);
            wingLength = (int)((float)wingLength + lineWidth * 2.0f);
        }
        GeneralPath shape = OMArrowHead.createArrowHead(locPoints[0], locPoints[1], wingTip, wingLength);
        int numLocPoints = locPoints.length;
        for (int i = 2; i < numLocPoints - 1; i += 2) {
            shape.append(OMArrowHead.createArrowHead(locPoints[i], locPoints[i + 1], wingTip, wingLength), false);
        }
        return shape;
    }

    public static void addArrowHeads(int arrowDirectionType, int location, OMAbstractLine line) {
        GeneralPath arrowHeads = OMArrowHead.createArrowHeads(arrowDirectionType, location, line);
        if (arrowHeads != null) {
            line.getShape().append(arrowHeads, false);
        }
    }

    protected static GeneralPath createArrowHead(Point from, Point to, int wingTip, int wingLength) {
        int dx = to.x - from.x;
        int dy = to.y - from.y;
        int dd = (int)DrawUtil.distance(to.x, to.y, from.x, from.y);
        if (dd < 6) {
            dd = 6;
        }
        int[] xpts = new int[3];
        int[] ypts = new int[3];
        xpts[0] = to.x + (dy * wingTip - dx * wingLength) / dd;
        ypts[0] = to.y + (dx * -wingTip - dy * wingLength) / dd;
        xpts[1] = to.x;
        ypts[1] = to.y;
        xpts[2] = to.x + (dy * -wingTip - dx * wingLength) / dd;
        ypts[2] = to.y + (dx * wingTip - dy * wingLength) / dd;
        return OMGraphic.createShape(xpts, ypts, true);
    }

    protected static Point[] locateArrowHeads(int arrowDirection, int arrowLocation, OMAbstractLine line) {
        if (line.xpoints == null || line.xpoints.length == 0 || line.xpoints[0].length == 0) {
            return null;
        }
        int pointIndex = line.xpoints[0].length - 1;
        if (Debug.debugging("arrowheads")) {
            Debug.output("createArrowHeads(): Number of points = " + pointIndex);
        }
        int drawingLinetype = 0;
        if (pointIndex > 1) {
            drawingLinetype = 1;
        }
        int[] end = new int[2];
        int[] start = new int[2];
        end[0] = pointIndex;
        start[0] = 0;
        end[1] = 0;
        start[1] = pointIndex;
        int origEnd = pointIndex;
        int origStart = 0;
        int numArrows = 1;
        if (arrowDirection == 2) {
            numArrows = 2;
        }
        Point sPoint1 = new Point();
        Point ePoint1 = new Point();
        Point sPoint2 = new Point();
        Point ePoint2 = new Point();
        if (line instanceof OMLine) {
            OMLine omLine = (OMLine)line;
            if (omLine.arc != null && omLine.arc.getReversed()) {
                if (arrowDirection == 0) {
                    arrowDirection = 1;
                } else if (arrowDirection == 1) {
                    arrowDirection = 0;
                }
            }
        }
        Vector<Object> pointVec = new Vector<Object>();
        for (int lineNum = 0; lineNum < line.xpoints.length; ++lineNum) {
            int[] xpoints = line.xpoints[lineNum];
            int[] ypoints = line.ypoints[lineNum];
            switch (drawingLinetype) {
                case 0: {
                    float dd;
                    int offset;
                    int dy;
                    int dx;
                    int newEndY;
                    int newEndX;
                    Debug.message("arrowheads", "createArrowHeads(): Inside x-y space");
                    if (OMArrowHead.needBackwardArrow(arrowDirection)) {
                        newEndX = xpoints[origStart];
                        newEndY = ypoints[origStart];
                        if (arrowLocation != 100) {
                            dx = xpoints[origStart] - xpoints[origEnd];
                            dy = ypoints[origStart] - ypoints[origEnd];
                            offset = 0;
                            if (dx == 0) {
                                newEndX = xpoints[origEnd];
                                offset = (int)((float)dy * ((float)arrowLocation / 100.0f));
                                newEndY = ypoints[origEnd] + offset;
                            } else {
                                dd = Math.abs((float)dy / (float)dx);
                                if (Math.abs(dx) > Math.abs(dy)) {
                                    newEndX = xpoints[origEnd] + (int)((double)dx * ((double)arrowLocation / 100.0));
                                    newEndY = ypoints[origEnd];
                                    offset = (int)((float)Math.abs(xpoints[origEnd] - newEndX) * dd);
                                    newEndY = dy < 0 ? (newEndY -= offset) : (newEndY += offset);
                                } else {
                                    newEndY = ypoints[origEnd] + (int)((double)dy * ((double)arrowLocation / 100.0));
                                    newEndX = xpoints[origEnd];
                                    offset = (int)((float)Math.abs(ypoints[origEnd] - newEndY) / dd);
                                    newEndX = dx < 0 ? (newEndX -= offset) : (newEndX += offset);
                                }
                            }
                        }
                        if (start[1] < 0) {
                            start[1] = 0;
                        }
                        if (numArrows == 2) {
                            sPoint2.x = xpoints[origEnd];
                            sPoint2.y = ypoints[origEnd];
                            ePoint2.x = newEndX;
                            ePoint2.y = newEndY;
                        } else {
                            sPoint1.x = xpoints[origEnd];
                            sPoint1.y = ypoints[origEnd];
                            ePoint1.x = newEndX;
                            ePoint1.y = newEndY;
                        }
                    }
                    if (!OMArrowHead.needForwardArrow(arrowDirection)) break;
                    newEndX = xpoints[origEnd];
                    newEndY = ypoints[origEnd];
                    if (arrowLocation != 100) {
                        dx = xpoints[origEnd] - xpoints[origStart];
                        dy = ypoints[origEnd] - ypoints[origStart];
                        offset = 0;
                        if (dx == 0) {
                            newEndX = xpoints[origStart];
                            offset = (int)((float)dy * ((float)arrowLocation / 100.0f));
                            newEndY = ypoints[origStart] + offset;
                        } else {
                            dd = Math.abs((float)dy / (float)dx);
                            if (Math.abs(dx) > Math.abs(dy)) {
                                newEndX = xpoints[origStart] + (int)((float)dx * ((float)arrowLocation / 100.0f));
                                newEndY = ypoints[origStart];
                                offset = (int)((float)Math.abs(xpoints[origStart] - newEndX) * dd);
                                newEndY = dy < 0 ? (newEndY -= offset) : (newEndY += offset);
                            } else {
                                newEndY = ypoints[origStart] + (int)((double)dy * ((double)arrowLocation / 100.0));
                                newEndX = xpoints[origStart];
                                offset = (int)((float)Math.abs(ypoints[origStart] - newEndY) / dd);
                                newEndX = dx < 0 ? (newEndX -= offset) : (newEndX += offset);
                            }
                        }
                    }
                    sPoint1.x = xpoints[origStart];
                    sPoint1.y = ypoints[origStart];
                    ePoint1.x = newEndX;
                    ePoint1.y = newEndY;
                    break;
                }
                case 1: {
                    Debug.message("arrowheads", "createArrowHeads(): Curved line arrowhead");
                    if (OMArrowHead.needBackwardArrow(arrowDirection)) {
                        Debug.message("arrowheads", "createArrowHeads(): direction backward and");
                        int bindex = pointIndex - (int)((float)pointIndex * (float)((double)arrowLocation / 100.0));
                        if (bindex == 0) {
                            bindex = 1;
                        }
                        if (numArrows == 2) {
                            sPoint2.x = xpoints[bindex];
                            sPoint2.y = ypoints[bindex];
                            ePoint2.x = xpoints[bindex - 1];
                            ePoint2.y = ypoints[bindex - 1];
                        } else {
                            sPoint1.x = xpoints[bindex];
                            sPoint1.y = ypoints[bindex];
                            ePoint1.x = xpoints[bindex - 1];
                            ePoint1.y = ypoints[bindex - 1];
                        }
                    }
                    if (!OMArrowHead.needForwardArrow(arrowDirection)) break;
                    int findex = (int)((float)pointIndex * (float)((double)arrowLocation / 100.0));
                    if (findex == pointIndex) {
                        --findex;
                    }
                    sPoint1.x = xpoints[findex];
                    sPoint1.y = ypoints[findex];
                    ePoint1.x = xpoints[findex + 1];
                    ePoint1.y = ypoints[findex + 1];
                }
            }
            pointVec.add(sPoint1.clone());
            pointVec.add(ePoint1.clone());
            if (numArrows <= 1) continue;
            pointVec.add(sPoint2.clone());
            pointVec.add(ePoint2.clone());
        }
        Point[] ret = new Point[pointVec.size()];
        int i = 0;
        Iterator it = pointVec.iterator();
        while (it.hasNext()) {
            ret[i] = (Point)it.next();
            ++i;
        }
        return ret;
    }

    private static boolean needBackwardArrow(int arrowDir) {
        return arrowDir == 1 || arrowDir == 2;
    }

    private static boolean needForwardArrow(int arrowDir) {
        return arrowDir == 0 || arrowDir == 2;
    }

    public int getArrowDirectionType() {
        return this.arrowDirectionType;
    }

    public void setArrowDirectionType(int arrowDirectionType) {
        this.arrowDirectionType = arrowDirectionType;
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int location) {
        this.location = location < 1 ? 1 : (location > 100 ? 100 : location);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public int getWingLength() {
        return this.wingLength;
    }

    public void setWingLength(int wingLength) {
        this.wingLength = wingLength;
    }

    public int getWingTip() {
        return this.wingTip;
    }

    public void setWingTip(int wingTip) {
        this.wingTip = wingTip;
    }
}

