/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.layer.util.stateMachine.State;
import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.GrabPoint;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.omGraphics.OffsetGrabPoint;
import com.bbn.openmap.omGraphics.editable.GraphicEditState;
import com.bbn.openmap.omGraphics.editable.GraphicSelectedState;
import com.bbn.openmap.omGraphics.editable.GraphicSetOffsetState;
import com.bbn.openmap.omGraphics.editable.GraphicUndefinedState;
import com.bbn.openmap.omGraphics.editable.TextStateMachine;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class EditableOMText
extends EditableOMGraphic
implements ActionListener {
    protected GrabPoint gpc;
    protected OffsetGrabPoint gpo;
    protected OMText text;
    public static final int CENTER_POINT_INDEX = 0;
    public static final int OFFSET_POINT_INDEX = 1;
    protected I18n i18n = Environment.getI18n();
    protected int lastRenderType = -1;
    JComboBox sizesFont;
    JToggleButton boldFont;
    JToggleButton italicFont;
    public static final String TextFieldCommand = "TextField";
    public static final String TextFontCommand = "TextFont";
    public static final String TextRotationCommand = "TextRotation";
    static /* synthetic */ Class class$com$bbn$openmap$omGraphics$EditableOMText;

    public EditableOMText() {
        this.createGraphic(null);
    }

    public EditableOMText(GraphicAttributes ga) {
        this.createGraphic(ga);
    }

    public EditableOMText(OMText omc) {
        this.setGraphic(omc);
    }

    public void init() {
        this.setCanGrabGraphic(false);
        this.setStateMachine(new TextStateMachine(this));
        this.gPoints = new GrabPoint[2];
    }

    public void setGraphic(OMGraphic graphic) {
        this.init();
        if (graphic instanceof OMText) {
            this.text = (OMText)graphic;
            this.stateMachine.setSelected();
            this.setGrabPoints(this.text);
        } else {
            this.createGraphic(null);
        }
    }

    public void createGraphic(GraphicAttributes ga) {
        this.init();
        this.stateMachine.setUndefined();
        int renderType = 0;
        if (ga != null) {
            renderType = ga.getRenderType();
        }
        switch (renderType) {
            case 1: {
                this.text = new OMText(90.0f, -180.0f, "Text", 0);
                break;
            }
            case 3: {
                this.text = new OMText(90.0f, -180.0f, 0, 0, "Text", 0);
                break;
            }
            default: {
                this.text = new OMText(0, 0, "Text", 0);
            }
        }
        if (ga != null) {
            ga.setTo(this.text, true);
            this.text.setLinePaint(ga.getLinePaint());
        }
        this.assertGrabPoints();
    }

    public OMGraphic getGraphic() {
        return this.text;
    }

    public void attachToMovingGrabPoint(OffsetGrabPoint gp) {
        gp.addGrabPoint(this.gpo);
    }

    public void detachFromMovingGrabPoint(OffsetGrabPoint gp) {
        gp.removeGrabPoint(this.gpo);
    }

    public void setMovingPoint(GrabPoint gp) {
        super.setMovingPoint(gp);
    }

    public GrabPoint getMovingPoint(MouseEvent e) {
        this.movingPoint = null;
        GrabPoint[] gb = this.getGrabPoints();
        int x = e.getX();
        int y = e.getY();
        for (int i = gb.length - 1; i >= 0; --i) {
            if (gb[i] == null || gb[i].distance(x, y) != 0.0f) continue;
            this.setMovingPoint(gb[i]);
            break;
        }
        return this.movingPoint;
    }

    public void assertGrabPoints() {
        int rt = this.getGraphic().getRenderType();
        if (rt != this.lastRenderType) {
            this.clearGrabPoints();
            this.lastRenderType = rt;
        }
        if (this.gpc == null) {
            this.gPoints[0] = this.gpc = new GrabPoint(-1, -1);
        }
        if (this.gpo == null) {
            this.gpo = new OffsetGrabPoint(-1, -1);
            this.gPoints[1] = this.gpo;
            this.gpo.addGrabPoint(this.gpc);
        }
    }

    protected void clearGrabPoints() {
        this.gpc = null;
        this.gpo = null;
        this.gPoints[0] = this.gpc;
        this.gPoints[1] = this.gpo;
    }

    public void setGrabPoints(OMGraphic graphic) {
        if (!(graphic instanceof OMText)) {
            return;
        }
        this.assertGrabPoints();
        OMText text = (OMText)graphic;
        boolean ntr = text.getNeedToRegenerate();
        int renderType = text.getRenderType();
        int latoffset = 0;
        int lonoffset = 0;
        boolean doStraight = true;
        if (!ntr) {
            if ((renderType == 1 || renderType == 3) && this.projection != null) {
                float lon = text.getLon();
                float lat = text.getLat();
                LatLonPoint llp = new LatLonPoint(lat, lon);
                Point p = this.projection.forward(llp);
                if (renderType == 1) {
                    doStraight = false;
                    this.gpc.set((int)p.getX(), (int)p.getY());
                } else {
                    latoffset = (int)p.getY();
                    lonoffset = (int)p.getX();
                    this.gpo.set(lonoffset, latoffset);
                }
            }
            if (doStraight) {
                this.gpc.set(lonoffset + text.getX(), latoffset + text.getY());
            }
            if (renderType == 3) {
                this.gpo.updateOffsets();
            }
        } else {
            System.out.println("EditableOMText.setGrabPoint: graphic needs to be regenerated");
        }
    }

    public void setGrabPoints() {
        boolean settingOffset;
        LatLonPoint llp1;
        int renderType = this.text.getRenderType();
        Debug.message("eomt", "EditableOMText.setGrabPoints()");
        if (renderType == 1 && this.projection != null) {
            llp1 = this.projection.inverse(this.gpc.getX(), this.gpc.getY());
            this.text.setLat(llp1.getLatitude());
            this.text.setLon(llp1.getLongitude());
        }
        boolean bl = settingOffset = this.getStateMachine().getState() instanceof GraphicSetOffsetState && this.movingPoint == this.gpo;
        if (renderType == 3) {
            llp1 = this.projection.inverse(this.gpo.getX(), this.gpo.getY());
            this.text.setLat(llp1.getLatitude());
            this.text.setLon(llp1.getLongitude());
            if (settingOffset || this.movingPoint == this.gpc) {
                this.text.setX(this.gpc.getX() - this.gpo.getX());
                this.text.setY(this.gpc.getY() - this.gpo.getY());
            }
            if (!settingOffset) {
                this.text.setX(this.gpc.getX() - this.gpo.getX());
                this.text.setY(this.gpc.getY() - this.gpo.getY());
            }
            this.text.setRenderType(3);
        }
        if (renderType == 2 && this.movingPoint == this.gpc) {
            this.text.setX(this.gpc.getX());
            this.text.setY(this.gpc.getY());
        }
        if (this.projection != null) {
            this.regenerate(this.projection);
        }
    }

    public boolean getCanGrabGraphic() {
        return false;
    }

    public void move(MouseEvent e) {
    }

    public boolean generate(Projection proj) {
        if (this.text != null) {
            this.text.regenerate(proj);
        }
        for (int i = 0; i < this.gPoints.length; ++i) {
            GrabPoint gp = this.gPoints[i];
            if (gp == null) continue;
            gp.generate(proj);
        }
        return true;
    }

    public void regenerate(Projection proj) {
        if (this.text != null) {
            this.text.regenerate(proj);
        }
        this.setGrabPoints(this.text);
        this.generate(proj);
    }

    public void render(Graphics graphics) {
        State state = this.getStateMachine().getState();
        if (!(state instanceof GraphicUndefinedState)) {
            if (this.text != null) {
                this.text.setVisible(true);
                this.text.render(graphics);
                this.text.setVisible(false);
            } else {
                Debug.message("eomg", "EditableOMText.render: null point.");
            }
            int renderType = this.text.getRenderType();
            if (state instanceof GraphicSelectedState || state instanceof GraphicEditState) {
                for (int i = 0; i < this.gPoints.length; ++i) {
                    GrabPoint gp = this.gPoints[i];
                    if (gp == null || (i != 1 || renderType != 3 || this.movingPoint != this.gpo) && (!(state instanceof GraphicSelectedState) || (i == 1 || renderType == 3) && renderType != 3)) continue;
                    gp.setVisible(true);
                    gp.render(graphics);
                    gp.setVisible(false);
                }
            }
        }
    }

    public Component getGUI(GraphicAttributes graphicAttributes) {
        Debug.message("eomg", "EditableOMPoly.getGUI");
        if (graphicAttributes != null) {
            Component gaGUI = graphicAttributes.getGUI();
            ((JComponent)gaGUI).add(this.getTextGUI());
            return gaGUI;
        }
        return this.getTextGUI();
    }

    protected Component getTextGUI() {
        Box attributeBox = Box.createHorizontalBox();
        attributeBox.setAlignmentX(0.5f);
        attributeBox.setAlignmentY(0.5f);
        String textString = "Text";
        if (this.text != null) {
            textString = this.text.getData();
        }
        JTextField textField = new JTextField(textString, 25);
        textField.setActionCommand(TextFieldCommand);
        textField.addActionListener(this);
        textField.setMargin(new Insets(0, 1, 0, 1));
        textField.setMinimumSize(new Dimension(100, 20));
        textField.setPreferredSize(new Dimension(100, 20));
        attributeBox.add(textField);
        Box palette = Box.createHorizontalBox();
        textField = new JTextField(Integer.toString((int)(this.text.getRotationAngle() * 180.0 / Math.PI)), 5);
        textField.setActionCommand(TextRotationCommand);
        textField.setToolTipText(this.i18n.get(class$com$bbn$openmap$omGraphics$EditableOMText == null ? (class$com$bbn$openmap$omGraphics$EditableOMText = EditableOMText.class$("com.bbn.openmap.omGraphics.EditableOMText")) : class$com$bbn$openmap$omGraphics$EditableOMText, "textField", 3, "Text rotation in degrees"));
        textField.setMargin(new Insets(0, 1, 0, 1));
        textField.addActionListener(this);
        textField.setMinimumSize(new Dimension(30, 20));
        textField.setPreferredSize(new Dimension(30, 20));
        palette.add(textField);
        palette.add(new JLabel("\u00b0 "));
        attributeBox.add(palette);
        String[] sizesStrings = new String[]{"3", "5", "8", "10", "12", "14", "18", "20", "24", "36", "48"};
        this.sizesFont = new JComboBox<String>(sizesStrings);
        this.sizesFont.setToolTipText(this.i18n.get(class$com$bbn$openmap$omGraphics$EditableOMText == null ? (class$com$bbn$openmap$omGraphics$EditableOMText = EditableOMText.class$("com.bbn.openmap.omGraphics.EditableOMText")) : class$com$bbn$openmap$omGraphics$EditableOMText, "sizesFont", 3, "Font Size"));
        this.sizesFont.setSelectedItem("" + this.text.getFont().getSize());
        this.sizesFont.setActionCommand(TextFontCommand);
        this.sizesFont.addActionListener(this);
        int textButtonWidth = 10;
        int textButtonHeight = 15;
        this.boldFont = new JToggleButton();
        this.boldFont.setIcon(this.getTextAccentToggleButtonImage(textButtonWidth, textButtonHeight, new Font(this.boldFont.getFont().getName(), 1, this.boldFont.getFont().getSize()), "B"));
        Insets insets = this.boldFont.getInsets();
        insets.left /= 2;
        insets.right /= 2;
        this.boldFont.setMargin(insets);
        this.boldFont.setSelected(this.text.getFont().isBold());
        this.boldFont.setToolTipText(this.i18n.get(class$com$bbn$openmap$omGraphics$EditableOMText == null ? (class$com$bbn$openmap$omGraphics$EditableOMText = EditableOMText.class$("com.bbn.openmap.omGraphics.EditableOMText")) : class$com$bbn$openmap$omGraphics$EditableOMText, "boldFont", 3, "Bold Font"));
        this.boldFont.setActionCommand(TextFontCommand);
        this.boldFont.addActionListener(this);
        this.italicFont = new JToggleButton();
        this.italicFont.setIcon(this.getTextAccentToggleButtonImage(textButtonWidth, textButtonHeight, new Font(this.italicFont.getFont().getName(), 2, this.italicFont.getFont().getSize()), "I"));
        this.italicFont.setMargin(insets);
        this.italicFont.setSelected(this.text.getFont().isItalic());
        this.italicFont.setToolTipText(this.i18n.get(class$com$bbn$openmap$omGraphics$EditableOMText == null ? (class$com$bbn$openmap$omGraphics$EditableOMText = EditableOMText.class$("com.bbn.openmap.omGraphics.EditableOMText")) : class$com$bbn$openmap$omGraphics$EditableOMText, "italicFont", 3, "Italic Font"));
        this.italicFont.setActionCommand(TextFontCommand);
        this.italicFont.addActionListener(this);
        attributeBox.add(this.sizesFont);
        attributeBox.add(this.boldFont);
        attributeBox.add(this.italicFont);
        return attributeBox;
    }

    private ImageIcon getTextAccentToggleButtonImage(int width, int height, Font f, String s) {
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics g = bi.getGraphics();
        g.setFont(f);
        g.setColor(Color.black);
        FontMetrics fm = g.getFontMetrics();
        int stringWidth = fm.stringWidth(s);
        int stringHeight = f.getSize() - 2;
        g.drawString(s, (width - stringWidth) / 2, height - (height - stringHeight) / 2);
        return new ImageIcon(bi);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String command = e.getActionCommand();
        if (command == TextFontCommand) {
            String FontString = OMText.fontToXFont(this.text.getFont());
            FontString = FontString.substring(0, FontString.indexOf("-", 3));
            StringBuffer ret = new StringBuffer(FontString);
            if (this.boldFont.isSelected()) {
                ret.append("-bold");
            } else {
                ret.append("-normal");
            }
            if (this.italicFont.isSelected()) {
                ret.append("-i");
            } else {
                ret.append("-o");
            }
            ret.append("-normal");
            ret.append("--" + this.sizesFont.getSelectedItem());
            ret.append("-*-*-*-*-*-*");
            ret.toString();
            this.text.setFont(OMText.rebuildFont(ret.toString()));
            this.repaint();
        } else if (command == TextFieldCommand) {
            this.text.setData(((JTextField)source).getText());
            this.text.regenerate(this.projection);
            this.repaint();
        } else if (command == TextRotationCommand) {
            Integer rotation = new Integer(((JTextField)source).getText());
            this.text.setRotationAngle(Math.PI / 180 * (double)(rotation % 360));
            this.text.regenerate(this.projection);
            this.repaint();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

