/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.PrimitiveTable;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.VPFFeatureWarehouse;
import com.bbn.openmap.layer.vpf.VPFGraphicWarehouse;
import java.util.ArrayList;
import java.util.List;

public class TextTable
extends PrimitiveTable {
    private final int coordColumn = this.whatColumn("shape_line");
    private final int textColumn;

    public TextTable(CoverageTable cov, TileDirectory tile) throws FormatException {
        super(cov, tile, "txt");
        if (this.coordColumn == -1) {
            throw new FormatException("texttable couldn't get shape_line column");
        }
        this.textColumn = this.whatColumn("string");
        if (this.textColumn == -1) {
            throw new FormatException("texttable couldn't get string column");
        }
    }

    public CoordFloatString getCoordinates(List textprim) {
        return (CoordFloatString)textprim.get(this.coordColumn);
    }

    public void drawTile(VPFGraphicWarehouse warehouse, float dpplat, float dpplon, LatLonPoint ll1, LatLonPoint ll2) {
        float ll1lat = ll1.getLatitude();
        float ll1lon = ll1.getLongitude();
        float ll2lat = ll2.getLatitude();
        float ll2lon = ll2.getLongitude();
        try {
            ArrayList text = new ArrayList();
            while (this.parseRow(text)) {
                String textval = (String)text.get(this.textColumn);
                CoordFloatString coords = (CoordFloatString)text.get(this.coordColumn);
                float lat = coords.getYasFloat(0);
                float lon = coords.getXasFloat(0);
                if (!(lat > ll2lat) || !(lat < ll1lat) || !(lon > ll1lon) || !(lon < ll2lon)) continue;
                warehouse.createText(this.covtable, this, text, lat, lon, textval);
            }
        }
        catch (FormatException f) {
            System.out.println("Exception: " + f.getClass() + " " + f.getMessage());
        }
    }

    public void drawFeature(VPFFeatureWarehouse warehouse, float dpplat, float dpplon, LatLonPoint ll1, LatLonPoint ll2, List text, String featureType) {
        if (warehouse == null) {
            return;
        }
        float ll1lat = ll1.getLatitude();
        float ll1lon = ll1.getLongitude();
        float ll2lat = ll2.getLatitude();
        float ll2lon = ll2.getLongitude();
        String textval = (String)text.get(this.textColumn);
        CoordFloatString coords = (CoordFloatString)text.get(this.coordColumn);
        float lat = coords.getYasFloat(0);
        float lon = coords.getXasFloat(0);
        if (lat > ll2lat && lat < ll1lat && lon > ll1lon && lon < ll2lon) {
            warehouse.createText(this.covtable, this, text, lat, lon, textval, featureType);
        }
    }
}

