/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.LibrarySelectionTable;
import com.bbn.openmap.layer.vpf.VPFCachedFeatureGraphicWarehouse;
import com.bbn.openmap.layer.vpf.VPFFeatureCache;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.io.Serializable;
import java.util.Properties;

public class LibraryBean
implements PropertyConsumer,
Serializable {
    public static final String nameProperty = "name";
    public static final String pathProperty = "vpfPath";
    public static final String cacheSizeProperty = "cacheSize";
    private transient LibrarySelectionTable lst = null;
    String beanName;
    private String propertyPrefix = null;
    private String[] paths;
    protected VPFFeatureCache featureCache = new VPFFeatureCache();

    public void setProperties(Properties setList) {
        this.setProperties(this.getPropertyPrefix(), setList);
    }

    public void setProperties(String prefix, Properties setList) {
        this.setPropertyPrefix(prefix);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.paths = PropUtils.initPathsFromProperties(setList, realPrefix + pathProperty, this.paths);
        String beanName = setList.getProperty(realPrefix + nameProperty);
        String string = this.beanName = beanName == null ? prefix : beanName;
        if (Debug.debugging("vpf")) {
            Debug.output("LibraryBean.setProperties(): " + prefix + " " + this.beanName + " initialized");
        }
        try {
            if (this.paths == null) {
                Debug.output("VPF LibraryBean: path not set - expected " + realPrefix + pathProperty + " property");
            } else {
                this.lst = new LibrarySelectionTable(this.paths);
            }
        }
        catch (FormatException f) {
            Debug.output(f.getMessage());
        }
        catch (NullPointerException npe) {
            Debug.output("LibraryBean.setProperties:" + prefix + ": path name not valid");
        }
        int cacheSize = PropUtils.intFromProperties(setList, realPrefix + cacheSizeProperty, this.featureCache.getCacheSize());
        this.featureCache.resetCache(cacheSize);
    }

    public String getName() {
        return this.beanName;
    }

    public Properties getProperties(Properties getList) {
        if (getList == null) {
            getList = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        getList.put(prefix + nameProperty, this.beanName);
        getList.put(prefix + cacheSizeProperty, Integer.toString(this.featureCache.getCacheSize()));
        return getList;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        list.put(nameProperty, "Name of Library Bean.");
        list.put(pathProperty, "List of VPF directories.");
        list.put("vpfPath.editor", "com.bbn.openmap.util.propertyEditor.MultiDirectoryPropertyEditor");
        list.put(cacheSizeProperty, "Maximun number of tiles to cache (25 is default).");
        return list;
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public LibrarySelectionTable getLibrarySelectionTable() {
        return this.lst;
    }

    public VPFCachedFeatureGraphicWarehouse getWarehouse() {
        if (Debug.debugging("vpf")) {
            Debug.output("LibraryBean.getWarehouse(): creating warehouse.");
        }
        return new VPFCachedFeatureGraphicWarehouse(this.featureCache);
    }
}

