/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.Constants;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.DcwRecordFile;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.util.Debug;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CoverageAttributeTable {
    protected final String libraryname;
    protected final String dirpath;
    private boolean isTiled = false;
    private final Map coverages = new HashMap();
    private TileDirectory[] containedTiles;
    private static final String[] CATColumns = new String[]{"coverage_name", "description", "level"};
    private static final char[] CATschematype = new char[]{'T', 'T', 'i'};
    private static final int[] CATschemalength = new int[]{-1, -1, 1};
    private static final String[] fbrColumns = new String[]{"xmin", "ymin", "xmax", "ymax"};
    private static final String[] fcsColumns = new String[]{"feature_class", "table1", "table1_key", "table2", "table2_key"};
    private static final String[] fcsColumnsDCW = new String[]{"feature_class", "table1", "foreign_key", "table2", "primary_key"};

    public CoverageAttributeTable(String dcwpath, String libname) throws FormatException {
        this.libraryname = libname;
        this.dirpath = dcwpath + "/" + this.libraryname;
        String cat = this.dirpath + "/cat";
        if (!BinaryFile.exists(cat)) {
            cat = cat + ".";
        }
        DcwRecordFile rf = new DcwRecordFile(cat);
        int[] catcols = rf.lookupSchema(CATColumns, true, CATschematype, CATschemalength, false);
        ArrayList l = new ArrayList(rf.getColumnCount());
        while (rf.parseRow(l)) {
            int topL = ((Number)l.get(catcols[2])).intValue();
            String desc = (String)l.get(catcols[1]);
            String covtype = ((String)l.get(catcols[0])).toLowerCase().intern();
            this.coverages.put(covtype, new CoverageEntry(topL, desc));
        }
        rf.close();
        rf = null;
        this.doTileRefStuff(this.dirpath + "/tileref");
    }

    public final boolean isTiledCoverage() {
        return this.isTiled;
    }

    public String getLibraryName() {
        return this.libraryname;
    }

    private void doTileRefStuff(String pathname) {
        this.doTileRefStuff(pathname, false);
    }

    private void doTileRefStuff(String pathname, boolean DCW) {
        String faceIDColumnName = null;
        boolean addSlash = true;
        if (pathname.endsWith("/") || pathname.endsWith(File.separator)) {
            addSlash = false;
        }
        try {
            String fcsFile = pathname + (addSlash ? "/" : "") + "fcs";
            if (!BinaryFile.exists(fcsFile)) {
                fcsFile = fcsFile + ".";
            }
            DcwRecordFile fcs = new DcwRecordFile(fcsFile);
            ArrayList fcsv = new ArrayList(fcs.getColumnCount());
            int[] fcscols = !DCW ? fcs.lookupSchema(fcsColumns, true) : fcs.lookupSchema(fcsColumnsDCW, true);
            while (fcs.parseRow(fcsv)) {
                String fclass = (String)fcsv.get(fcscols[0]);
                String table1 = (String)fcsv.get(fcscols[1]);
                String table1_key = (String)fcsv.get(fcscols[2]);
                if (!"tileref".equalsIgnoreCase(fclass) || !"tileref.aft".equalsIgnoreCase(table1)) continue;
                faceIDColumnName = table1_key.toLowerCase();
                break;
            }
            fcs.close();
        }
        catch (FormatException f) {
            if (!DCW) {
                this.doTileRefStuff(pathname, true);
            }
            return;
        }
        catch (NullPointerException npe) {
            return;
        }
        if (faceIDColumnName == null) {
            return;
        }
        this.isTiled = true;
        try {
            DcwRecordFile aft = new DcwRecordFile(pathname + (addSlash ? "/" : "") + "tileref.aft");
            int faceIDColumn = aft.whatColumn(faceIDColumnName.toLowerCase());
            int tileNameColumn = aft.whatColumn("tile_name");
            if (faceIDColumn == -1 || tileNameColumn == -1) {
                aft.close();
                return;
            }
            String fbrFile = pathname + (addSlash ? "/" : "") + "fbr";
            if (!BinaryFile.exists(fbrFile)) {
                fbrFile = fbrFile + ".";
            }
            DcwRecordFile fbr = new DcwRecordFile(fbrFile);
            int fbrIDColumn = fbr.whatColumn("id");
            ArrayList aftv = new ArrayList(aft.getColumnCount());
            ArrayList fbrv = new ArrayList(fbr.getColumnCount());
            int[] fbrcols = fbr.lookupSchema(fbrColumns, true);
            ArrayList<Object> tileArrayList = new ArrayList<Object>(500);
            Object nullTile = new Object();
            while (aft.parseRow(aftv)) {
                int fac_num = ((Number)aftv.get(faceIDColumn)).intValue();
                fbr.getRow(fbrv, fac_num);
                int tileid = ((Number)aftv.get(fbrIDColumn)).intValue();
                String tilename = (String)aftv.get(tileNameColumn);
                char[] chs = tilename.toCharArray();
                boolean goodTile = false;
                for (int i = 0; i < chs.length; ++i) {
                    if (chs[i] != '\\' && chs[i] != ' ') {
                        goodTile = true;
                    }
                    if (chs[i] != '\\') continue;
                    chs[i] = 47;
                }
                tilename = new String(chs);
                while (tileid > tileArrayList.size() - 1) {
                    tileArrayList.add(nullTile);
                }
                if (!goodTile) continue;
                float westlon = ((Number)fbrv.get(fbrcols[0])).floatValue();
                float southlat = ((Number)fbrv.get(fbrcols[1])).floatValue();
                float eastlon = ((Number)fbrv.get(fbrcols[2])).floatValue();
                float northlat = ((Number)fbrv.get(fbrcols[3])).floatValue();
                tileArrayList.set(tileid, new TileDirectory(tilename, tileid, northlat, southlat, eastlon, westlon));
            }
            aft.close();
            fbr.close();
            this.containedTiles = new TileDirectory[tileArrayList.size()];
            Iterator it = tileArrayList.iterator();
            int cnt = 0;
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj == nullTile) {
                    this.containedTiles[cnt++] = null;
                    continue;
                }
                this.containedTiles[cnt++] = (TileDirectory)obj;
            }
        }
        catch (FormatException f) {
            this.containedTiles = null;
        }
    }

    public String getCoverageDescription(String covname) {
        CoverageEntry ce = (CoverageEntry)this.coverages.get(covname);
        return ce == null ? null : ce.getDescription();
    }

    public int getCoverageTopologyLevel(String covname) {
        CoverageEntry ce = (CoverageEntry)this.coverages.get(covname);
        return ce == null ? -1 : ce.getTopologyLevel();
    }

    public CoverageTable getCoverageTable(String covname) {
        CoverageEntry ce = (CoverageEntry)this.coverages.get(covname);
        if (ce != null) {
            if (ce.getCoverageTable() == null) {
                ce.setCoverageTable(new CoverageTable(this.dirpath, covname.intern(), this));
                if (Debug.debugging("vpf")) {
                    Debug.output("Created new CoverageTable for " + covname + ": " + ce.description);
                }
            } else if (Debug.debugging("vpf")) {
                Debug.output("Using cached CoverageTable for " + covname + ": " + ce.description);
            }
            return ce.getCoverageTable();
        }
        return null;
    }

    public CoverageTable getCoverageTableForFeature(String featureName) {
        Iterator it = this.coverages.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            CoverageEntry ce = (CoverageEntry)this.coverages.get(key);
            Debug.output("CoverageTable: got " + ce + " for " + key);
            CoverageTable ct = ce.getCoverageTable();
            if (ct != null) {
                if (ct.getFeatureClassInfo(featureName) == null) continue;
                return ct;
            }
            Debug.output("no coverage table for " + ce);
        }
        return null;
    }

    public List tilesInRegion(float n, float s, float e, float w) {
        if (this.containedTiles == null) {
            return null;
        }
        ArrayList<TileDirectory> retval = new ArrayList<TileDirectory>();
        int numTiles = this.containedTiles.length;
        for (int i = 0; i < numTiles; ++i) {
            TileDirectory tile = this.containedTiles[i];
            if (tile == null || !tile.inRegion(n, s, e, w)) continue;
            retval.add(tile);
        }
        return retval;
    }

    public TileDirectory getTileWithID(int id) {
        try {
            return this.containedTiles[id];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return null;
        }
    }

    public TileDirectory getTileWithID(String id) {
        try {
            return this.getTileWithID(Integer.parseInt(id));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public boolean isTiledData() {
        return this.containedTiles != null;
    }

    public String[] getCoverageNames() {
        return this.coverages.keySet().toArray(Constants.EMPTY_STRING_ARRAY);
    }

    public static class CoverageEntry {
        private final int tLevel;
        private final String description;
        private CoverageTable covtable;

        public CoverageEntry(int topologyLevel, String desc) {
            this(topologyLevel, desc, null);
        }

        public CoverageEntry(int topologyLevel, String desc, CoverageTable covtable) {
            this.tLevel = topologyLevel;
            this.description = desc;
            this.covtable = covtable;
        }

        public int getTopologyLevel() {
            return this.tLevel;
        }

        public String getDescription() {
            return this.description;
        }

        public CoverageTable getCoverageTable() {
            return this.covtable;
        }

        void setCoverageTable(CoverageTable covtable) {
            this.covtable = covtable;
        }
    }
}

