/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.test;

import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.Intersection;
import com.bbn.openmap.layer.editor.EditorLayer;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.util.Debug;
import java.awt.BasicStroke;
import java.awt.Color;
import java.util.Iterator;

public class GeoCrossDemoLayer
extends EditorLayer {
    protected OMGraphicList lines = new OMGraphicList();

    public OMGraphicList prepare() {
        OMGraphicList list = this.getList();
        if (list == null) {
            list = new OMGraphicList();
        } else {
            list.clear();
        }
        OMLine oldLine = null;
        Geo ogc = null;
        Iterator it = this.lines.iterator();
        while (it.hasNext()) {
            OMLine line = (OMLine)it.next();
            float[] ll = line.getLL();
            Geo g1 = new Geo(ll[0], ll[1]);
            Geo g2 = new Geo(ll[2], ll[3]);
            Geo gc = g1.crossNormalize(g2);
            OMPoint p = new OMPoint((float)gc.getLatitude(), (float)gc.getLongitude(), 3);
            p.setLinePaint(line.getLinePaint());
            p.setFillPaint(line.getFillPaint());
            p.setStroke(line.getStroke());
            line.addArrowHead(true);
            list.add(line);
            list.add(p);
            if (oldLine != null) {
                float[] ll2 = oldLine.getLL();
                Geo g3 = new Geo(ll2[0], ll2[1]);
                Geo g4 = new Geo(ll2[2], ll2[3]);
                OMLine line2 = new OMLine((float)ogc.getLatitude(), (float)ogc.getLongitude(), (float)gc.getLatitude(), (float)gc.getLongitude(), 3);
                line2.setLinePaint(line.getLinePaint());
                line2.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{10.0f, 10.0f}, 0.0f));
                line2.addArrowHead(true);
                list.add(line2);
                Geo i = gc.crossNormalize(ogc);
                if (!Intersection.isOnSegment(g1, g2, i) && !Intersection.isOnSegment(g3, g4, i)) {
                    i = i.antipode();
                }
                p = new OMPoint((float)i.getLatitude(), (float)i.getLongitude(), 3);
                p.setOval(true);
                p.setLinePaint(line.getLinePaint());
                p.setFillPaint(Color.white);
                p.setStroke(line.getStroke());
                list.add(p);
            }
            oldLine = line;
            ogc = gc;
        }
        list.generate(this.getProjection());
        return list;
    }

    public void drawingComplete(OMGraphic omg, OMAction action) {
        this.releaseProxyMouseMode();
        if (omg instanceof OMLine && this.lines != null) {
            this.lines.doAction(omg, action);
            this.deselect(this.lines);
            this.doPrepare();
        } else {
            Debug.error("Layer " + this.getName() + " received " + omg + " and " + action + " with no list ready");
        }
        if (this.editorTool != null) {
            this.editorTool.drawingComplete(omg, action);
        }
    }
}

