/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.dataAccess.shape.DbfHandler;
import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.layer.shape.ESRIBoundingBox;
import com.bbn.openmap.layer.shape.SpatialIndex;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.DataBounds;
import com.bbn.openmap.util.DataBoundsProvider;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ShapeLayer
extends OMGraphicHandlerLayer
implements ActionListener,
DataBoundsProvider {
    public static final String shapeFileProperty = "shapeFile";
    public static final String spatialIndexProperty = "spatialIndex";
    public static final String pointImageURLProperty = "pointImageURL";
    public static final String shadowXProperty = "shadowX";
    public static final String shadowYProperty = "shadowY";
    public static final String TransformProperty = "transform";
    protected int shadowX = 0;
    protected int shadowY = 0;
    protected SpatialIndex spatialIndex;
    protected DrawingAttributes drawingAttributes;
    protected GeoCoordTransformation coordTransform;
    String shapeFileName = null;
    String spatialIndexFileName = null;
    String imageURLString = null;
    protected transient JPanel box;
    static /* synthetic */ Class class$com$bbn$openmap$layer$shape$ShapeLayer;

    public ShapeLayer() {
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
    }

    public ShapeLayer(String shapeFileName) {
        this();
        this.spatialIndex = SpatialIndex.locateAndSetShapeData(shapeFileName);
    }

    public void setSpatialIndex(SpatialIndex si) {
        this.spatialIndex = si;
    }

    public SpatialIndex getSpatialIndex() {
        return this.spatialIndex;
    }

    public GeoCoordTransformation getCoordTransform() {
        return this.coordTransform;
    }

    public void setCoordTransform(GeoCoordTransformation coordTranslator) {
        this.coordTransform = coordTranslator;
    }

    protected void setFileProperties(String realPrefix, Properties props) {
        this.shapeFileName = props.getProperty(realPrefix + shapeFileProperty);
        this.spatialIndexFileName = props.getProperty(realPrefix + spatialIndexProperty);
        if (this.shapeFileName != null && !this.shapeFileName.equals("")) {
            SpatialIndex spatialIndex;
            block11: {
                spatialIndex = this.spatialIndexFileName != null && !this.spatialIndexFileName.equals("") ? SpatialIndex.locateAndSetShapeData(this.shapeFileName, this.spatialIndexFileName) : SpatialIndex.locateAndSetShapeData(this.shapeFileName);
                String dbfFileName = this.shapeFileName.substring(0, this.shapeFileName.indexOf(".shp")) + ".dbf";
                try {
                    if (BinaryFile.exists(dbfFileName)) {
                        BinaryBufferedFile bbf = new BinaryBufferedFile(dbfFileName);
                        DbfHandler dbfh = new DbfHandler(bbf);
                        dbfh.setProperties(realPrefix, props);
                        spatialIndex.setDbf(dbfh);
                    }
                }
                catch (FormatException fe) {
                    if (Debug.debugging("shape")) {
                        Debug.error("ShapeLayer: Couldn't create DBF handler for " + dbfFileName + ", FormatException: " + fe.getMessage());
                    }
                }
                catch (IOException ioe) {
                    if (!Debug.debugging("shape")) break block11;
                    Debug.error("ShapeLayer: Couldn't create DBF handler for " + dbfFileName + ", IOException: " + ioe.getMessage());
                }
            }
            this.imageURLString = props.getProperty(realPrefix + pointImageURLProperty);
            try {
                if (this.imageURLString != null && !this.imageURLString.equals("")) {
                    URL imageURL = PropUtils.getResourceOrFileOrURL(this, this.imageURLString);
                    ImageIcon imageIcon = new ImageIcon(imageURL);
                    spatialIndex.setPointIcon(imageIcon);
                }
            }
            catch (MalformedURLException murle) {
                Debug.error("ShapeLayer.setFileProperties: point image URL not so good: \n\t" + this.imageURLString);
            }
            catch (NullPointerException npe) {
                this.fireRequestMessage("Can't access icon image: \n    " + this.imageURLString);
            }
            this.setSpatialIndex(spatialIndex);
        } else {
            Debug.error("One of the following properties was null or empty:");
            Debug.error("\t" + realPrefix + shapeFileProperty);
            Debug.error("\t" + realPrefix + spatialIndexProperty);
        }
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(this);
        this.setFileProperties(realPrefix, props);
        this.drawingAttributes = new DrawingAttributes(prefix, props);
        this.shadowX = PropUtils.intFromProperties(props, realPrefix + shadowXProperty, 0);
        this.shadowY = PropUtils.intFromProperties(props, realPrefix + shadowYProperty, 0);
        String transClassName = props.getProperty(realPrefix + TransformProperty);
        if (transClassName != null) {
            try {
                this.coordTransform = (GeoCoordTransformation)ComponentFactory.create(transClassName, realPrefix + TransformProperty, props);
            }
            catch (ClassCastException cce) {
                // empty catch block
            }
        }
    }

    public Properties getProperties(Properties props) {
        DbfHandler dbfh;
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + shapeFileProperty, this.shapeFileName == null ? "" : this.shapeFileName);
        props.put(prefix + spatialIndexProperty, this.spatialIndexFileName == null ? "" : this.spatialIndexFileName);
        props.put(prefix + pointImageURLProperty, this.imageURLString == null ? "" : this.imageURLString);
        props.put(prefix + shadowXProperty, Integer.toString(this.shadowX));
        props.put(prefix + shadowYProperty, Integer.toString(this.shadowY));
        if (this.drawingAttributes != null) {
            this.drawingAttributes.setPropertyPrefix(this.getPropertyPrefix());
            this.drawingAttributes.getProperties(props);
        } else {
            DrawingAttributes da = (DrawingAttributes)DrawingAttributes.DEFAULT.clone();
            da.setPropertyPrefix(this.getPropertyPrefix());
            da.getProperties(props);
        }
        if (this.coordTransform != null && this.coordTransform instanceof PropertyConsumer) {
            ((PropertyConsumer)((Object)this.coordTransform)).getProperties(props);
        }
        if (this.spatialIndex != null && (dbfh = this.spatialIndex.getDbf()) != null) {
            dbfh.getProperties(props);
        }
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        String dummyMarker = PropUtils.getDummyMarkerForPropertyInfo(this.getPropertyPrefix(), null);
        PropUtils.setI18NPropertyInfo(this.i18n, list, class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = ShapeLayer.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, dummyMarker, "Rendering Attributes", "Attributes that determine how the shapes will be drawn.", "com.bbn.openmap.omGraphics.DrawingAttributesPropertyEditor");
        list.put("initProperties", "shapeFile spatialIndex pointImageURL shadowX shadowY " + dummyMarker + " " + "addToBeanContext" + " " + "minScale" + " " + "maxScale");
        PropUtils.setI18NPropertyInfo(this.i18n, list, class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = ShapeLayer.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, shapeFileProperty, shapeFileProperty, "Location of Shape file - .shp (File, CURL or relative file path).", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, list, class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = ShapeLayer.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, spatialIndexProperty, spatialIndexProperty, "Location of Spatial Index file - .ssx (File, URL or relative file path).", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, list, class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = ShapeLayer.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, pointImageURLProperty, pointImageURLProperty, "Image file to use for map location of point data (optional).", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, list, class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = ShapeLayer.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, shadowXProperty, shadowXProperty, "Horizontal pixel offset for shadow image for shapes.", null);
        PropUtils.setI18NPropertyInfo(this.i18n, list, class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = ShapeLayer.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, shadowYProperty, shadowYProperty, "Vertical pixel offset for shadow image for shapes.", null);
        return list;
    }

    public void setDrawingAttributes(DrawingAttributes da) {
        this.drawingAttributes = da;
    }

    public DrawingAttributes getDrawingAttributes() {
        return this.drawingAttributes;
    }

    public String getInfoText(OMGraphic omg) {
        return (String)omg.getAttribute("Information Line");
    }

    public String getToolTipTextFor(OMGraphic omg) {
        return (String)omg.getAttribute("Tooltip");
    }

    protected OMGraphicList computeGraphics() {
        return this.prepare();
    }

    public synchronized OMGraphicList prepare() {
        OMGraphicList list = this.getList();
        Projection projection = this.getProjection();
        if (projection == null) {
            Debug.message("basic", "ShapeLayer|" + this.getName() + ": prepare called with null projection");
            return new OMGraphicList();
        }
        if (this.spatialIndex == null) {
            Debug.message("shape", "ShapeLayer: spatialIndex is null!");
            if (list != null) {
                list.generate(projection, true);
                return list;
            }
            return new OMGraphicList();
        }
        LatLonPoint ul = projection.getUpperLeft();
        LatLonPoint lr = projection.getLowerRight();
        float ulLat = ul.getLatitude();
        float ulLon = ul.getLongitude();
        float lrLat = lr.getLatitude();
        float lrLon = lr.getLongitude();
        if (list != null) {
            list.clear();
        }
        if (ProjMath.isCrossingDateline(ulLon, lrLon, projection.getScale())) {
            if (Debug.debugging("shape")) {
                Debug.output("ShapeLayer.computeGraphics(): Dateline is on screen");
            }
            double ymin = Math.min(ulLat, lrLat);
            double ymax = Math.max(ulLat, lrLat);
            try {
                list = this.spatialIndex.getOMGraphics(ulLon, ymin, 180.0, ymax, list, this.drawingAttributes, projection, this.coordTransform);
                list = this.spatialIndex.getOMGraphics(-180.0, ymin, lrLon, ymax, list, this.drawingAttributes, projection, this.coordTransform);
            }
            catch (InterruptedIOException iioe) {
                list = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (FormatException fe) {
                fe.printStackTrace();
            }
        } else {
            double xmin = Math.min(ulLon, lrLon);
            double xmax = Math.max(ulLon, lrLon);
            double ymin = Math.min(ulLat, lrLat);
            double ymax = Math.max(ulLat, lrLat);
            try {
                list = this.spatialIndex.getOMGraphics(xmin, ymin, xmax, ymax, list, this.drawingAttributes, projection, this.coordTransform);
            }
            catch (InterruptedIOException iioe) {
                list = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (FormatException fe) {
                fe.printStackTrace();
            }
        }
        return list;
    }

    public void paint(Graphics g) {
        if (this.shadowX == 0 && this.shadowY == 0) {
            super.paint(g);
        } else {
            OMGraphicList omg = this.getList();
            if (omg != null) {
                if (Debug.debugging("shape")) {
                    Debug.output("ShapeLayer.paint(): " + omg.size() + " omg" + " shadow=" + this.shadowX + "," + this.shadowY);
                }
                if (this.shadowX != 0 || this.shadowY != 0) {
                    Graphics shadowG = g.create();
                    shadowG.translate(this.shadowX, this.shadowY);
                    omg.render(shadowG);
                } else {
                    omg.render(g);
                }
                if (Debug.debugging("shape")) {
                    Debug.output("ShapeLayer.paint(): done");
                }
            }
        }
    }

    public Component getGUI() {
        if (this.box == null) {
            this.box = new JPanel();
            this.box.setLayout(new BoxLayout(this.box, 1));
            this.box.setAlignmentX(0.0f);
            JPanel stuff = new JPanel();
            DrawingAttributes da = this.getDrawingAttributes();
            if (da != null) {
                stuff.add(da.getGUI());
            }
            this.box.add(stuff);
            JPanel pal2 = new JPanel();
            JButton redraw = new JButton(this.i18n.get(class$com$bbn$openmap$layer$shape$ShapeLayer == null ? (class$com$bbn$openmap$layer$shape$ShapeLayer = ShapeLayer.class$("com.bbn.openmap.layer.shape.ShapeLayer")) : class$com$bbn$openmap$layer$shape$ShapeLayer, "redrawLayerButton", "Redraw Layer"));
            redraw.setActionCommand("redrawCmd");
            redraw.addActionListener(this);
            pal2.add(redraw);
            this.box.add(pal2);
        }
        return this.box;
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String cmd = e.getActionCommand();
        if (cmd == "redrawCmd" && this.isVisible()) {
            this.doPrepare();
        }
    }

    public DataBounds getDataBounds() {
        ESRIBoundingBox bounds;
        DataBounds box = null;
        if (this.spatialIndex != null && (bounds = this.spatialIndex.getBounds()) != null) {
            box = new DataBounds(bounds.min.x, bounds.min.y, bounds.max.x, bounds.max.y);
        }
        return box;
    }

    public void removed(Container cont) {
        OMGraphicList list = this.getList();
        if (list != null) {
            list.clear();
            list = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

