/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.policy.StandardPCPolicy;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.layer.shape.SpatialIndex;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Iterator;

public class BufferedShapeLayer
extends ShapeLayer {
    protected OMGraphicList bufferedList = null;

    public BufferedShapeLayer() {
        this.setProjectionChangePolicy(new StandardPCPolicy(this));
    }

    protected OMGraphicList getWholePlanet() throws IOException, FormatException {
        return this.spatialIndex.getOMGraphics(-180.0, -90.0, 180.0, 90.0, null, this.drawingAttributes, null, this.coordTransform);
    }

    public synchronized OMGraphicList prepare() {
        OMGraphicList list = this.getList();
        if (list != null) {
            list.clear();
        } else {
            list = new OMGraphicList();
        }
        if (this.spatialIndex == null) {
            return list;
        }
        try {
            if (this.bufferedList == null) {
                this.bufferedList = this.getWholePlanet();
            }
        }
        catch (FormatException fe) {
            Debug.error(fe.getMessage());
            return list;
        }
        catch (IOException ioe) {
            Debug.error(ioe.getMessage());
            return list;
        }
        Projection proj = this.getProjection();
        LatLonPoint ul = proj.getUpperLeft();
        LatLonPoint lr = proj.getLowerRight();
        float ulLat = ul.getLatitude();
        float ulLon = ul.getLongitude();
        float lrLat = lr.getLatitude();
        float lrLon = lr.getLongitude();
        if (ProjMath.isCrossingDateline(ulLon, lrLon, proj.getScale())) {
            if (Debug.debugging("shape")) {
                Debug.output("ShapeLayer.computeGraphics(): Dateline is on screen");
            }
            double ymin = Math.min(ulLat, lrLat);
            double ymax = Math.max(ulLat, lrLat);
            this.checkSpatialIndexEntries(ulLon, ymin, 180.0, ymax, list, proj);
            this.checkSpatialIndexEntries(-180.0, ymin, lrLon, ymax, list, proj);
        } else {
            double xmin = Math.min(ulLon, lrLon);
            double xmax = Math.max(ulLon, lrLon);
            double ymin = Math.min(ulLat, lrLat);
            double ymax = Math.max(ulLat, lrLat);
            this.checkSpatialIndexEntries(xmin, ymin, xmax, ymax, list, proj);
        }
        return list;
    }

    protected void checkSpatialIndexEntries(double xmin, double ymin, double xmax, double ymax, OMGraphicList retList, Projection proj) {
        Iterator entryIt = this.spatialIndex.entries.iterator();
        Iterator omgIt = this.bufferedList.iterator();
        while (entryIt.hasNext() && omgIt.hasNext()) {
            SpatialIndex.Entry entry = (SpatialIndex.Entry)entryIt.next();
            OMGraphic omg = (OMGraphic)omgIt.next();
            if (!entry.intersects(xmin, ymin, xmax, ymax)) continue;
            this.drawingAttributes.setTo(omg);
            omg.generate(proj);
            retList.add(omg);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == "redrawCmd") {
            this.setList(null);
        }
        super.actionPerformed(e);
    }
}

