/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.layer.rpf.RpfColortable;
import com.bbn.openmap.layer.rpf.RpfCoverageBox;
import com.bbn.openmap.layer.rpf.RpfFrame;
import com.bbn.openmap.layer.rpf.RpfFrameEntry;
import com.bbn.openmap.layer.rpf.RpfFrameProvider;
import com.bbn.openmap.layer.rpf.RpfIndexedImageData;
import com.bbn.openmap.layer.rpf.RpfTocEntry;
import com.bbn.openmap.layer.rpf.RpfTocHandler;
import com.bbn.openmap.layer.rpf.RpfViewAttributes;
import com.bbn.openmap.layer.util.cacheHandler.CacheHandler;
import com.bbn.openmap.layer.util.cacheHandler.CacheObject;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.util.Debug;
import java.util.List;
import java.util.Vector;

public class RpfFrameCacheHandler
extends CacheHandler
implements RpfFrameProvider {
    public static final int FRAME_CACHE_SIZE = 5;
    protected RpfColortable colortable;
    protected boolean Dchum = true;
    protected boolean outlineChum = false;
    protected RpfTocHandler[] tocs;
    protected RpfViewAttributes viewAttributes = new RpfViewAttributes();

    public RpfFrameCacheHandler(String[] RpfPaths) {
        this(RpfPaths, 5);
    }

    public RpfFrameCacheHandler(String[] RpfPaths, int max_size) {
        super(max_size);
        this.tocs = RpfFrameCacheHandler.createTocHandlers(RpfPaths);
        this.colortable = new RpfColortable();
    }

    public RpfFrameCacheHandler(RpfTocHandler[] tocHandlers) {
        this.tocs = tocHandlers;
        this.colortable = new RpfColortable();
    }

    public boolean needViewAttributeUpdates() {
        return false;
    }

    public void setViewAttributes(RpfViewAttributes va) {
        this.viewAttributes = va;
        if (va != null && this.colortable != null) {
            this.colortable.setOpaqueness(va.opaqueness);
            this.colortable.setNumColors(va.numberOfColors);
        }
    }

    public Vector getCatalogCoverage(float ullat, float ullon, float lrlat, float lrlon, CADRG proj, String chartSeries) {
        Vector coverages = new Vector();
        for (int i = 0; i < this.tocs.length; ++i) {
            if (this.tocs[i].hasChanged()) {
                this.tocs[i].reload();
            }
            if (!this.tocs[i].isValid()) continue;
            this.tocs[i].getCatalogCoverage(ullat, ullon, lrlat, lrlon, proj, chartSeries, coverages);
        }
        return coverages;
    }

    public float getCalculatedCoverage(float ullat, float ullon, float lrlat, float lrlon, CADRG p, String chartSeries) {
        int x;
        int y;
        RpfCoverageBox rcb;
        int i;
        if (chartSeries.equalsIgnoreCase("ANY")) {
            return 0.0f;
        }
        Vector results = this.getCatalogCoverage(ullat, ullon, lrlat, lrlon, p, chartSeries);
        int size = results.size();
        if (size == 0) {
            return 0.0f;
        }
        double frameLatInterval = Double.MAX_VALUE;
        double frameLonInterval = Double.MAX_VALUE;
        for (i = 0; i < size; ++i) {
            rcb = (RpfCoverageBox)results.elementAt(i);
            if (rcb.subframeLatInterval < frameLatInterval) {
                frameLatInterval = rcb.subframeLatInterval;
            }
            if (!(rcb.subframeLonInterval < frameLonInterval)) continue;
            frameLonInterval = rcb.subframeLonInterval;
        }
        if (frameLatInterval == Double.MAX_VALUE || frameLonInterval == Double.MAX_VALUE) {
            return 0.0f;
        }
        int numHFrames = (int)Math.ceil((double)(lrlon - ullon) / frameLonInterval);
        int numVFrames = (int)Math.ceil((double)(ullat - lrlat) / frameLatInterval);
        boolean[][] coverage = new boolean[numHFrames][numVFrames];
        for (i = 0; i < size; ++i) {
            rcb = (RpfCoverageBox)results.elementAt(i);
            if (rcb.percentCoverage == 100.0f) {
                return 1.0f;
            }
            for (y = 0; y < numVFrames; ++y) {
                for (x = 0; x < numHFrames; ++x) {
                    float yFrameLoc = (float)((double)lrlat + (double)y * frameLatInterval);
                    float xFrameLoc = (float)((double)ullon + (double)x * frameLonInterval);
                    if (coverage[x][y] || !rcb.within(yFrameLoc, xFrameLoc)) continue;
                    coverage[x][y] = true;
                }
            }
        }
        float count = 0.0f;
        for (y = 0; y < numVFrames; ++y) {
            for (x = 0; x < numHFrames; ++x) {
                if (!coverage[x][y]) continue;
                count += 1.0f;
            }
        }
        return count / (float)(numHFrames * numVFrames);
    }

    public Vector getCoverage(float ullat, float ullon, float lrlat, float lrlon, CADRG proj) {
        Debug.message("rpf", "RpfFrameCacheHandler: getCoverage()");
        Vector<RpfCoverageBox> coverageBoxes = new Vector<RpfCoverageBox>();
        for (int i = 0; i < this.tocs.length; ++i) {
            if (this.tocs[i].hasChanged()) {
                this.tocs[i].reload();
            }
            if (!this.tocs[i].isValid()) continue;
            List coverageEntries = this.tocs[i].getBestCoverageEntry(ullat, ullon, lrlat, lrlon, proj, this.viewAttributes);
            for (int k = 0; k < coverageEntries.size(); ++k) {
                RpfTocEntry currentEntry = (RpfTocEntry)coverageEntries.get(k);
                if (currentEntry != null) {
                    if (Debug.debugging("rpftoc")) {
                        System.out.println("RFCH: Toc " + i + " returned an entry");
                    }
                    RpfCoverageBox currentCoverage = currentEntry.coverage;
                    Object[] coverageArray = new Object[coverageBoxes.size()];
                    coverageBoxes.copyInto(coverageArray);
                    coverageBoxes.removeAllElements();
                    int size = coverageArray.length;
                    if (size == 0) {
                        coverageBoxes.addElement(currentCoverage);
                        continue;
                    }
                    boolean addedCurrent = false;
                    boolean okToAddCurrent = true;
                    for (int j = 0; j < size; ++j) {
                        RpfCoverageBox rcb = (RpfCoverageBox)coverageArray[j];
                        if (!addedCurrent) {
                            if (j == 0) {
                                if (RpfFrameCacheHandler.scaleDifference(proj, currentCoverage) <= RpfFrameCacheHandler.scaleDifference(proj, rcb) && currentCoverage.percentCoverage >= rcb.percentCoverage) {
                                    coverageBoxes.addElement(currentCoverage);
                                    addedCurrent = true;
                                    if (currentCoverage.scale != rcb.scale) break;
                                    coverageBoxes.addElement(rcb);
                                    continue;
                                }
                                coverageBoxes.addElement(rcb);
                                continue;
                            }
                            if (currentCoverage.percentCoverage >= rcb.percentCoverage) {
                                if (((RpfCoverageBox)coverageBoxes.get((int)0)).scale == currentCoverage.scale) {
                                    coverageBoxes.add(currentCoverage);
                                    addedCurrent = true;
                                } else {
                                    okToAddCurrent = false;
                                }
                                coverageBoxes.add(rcb);
                                continue;
                            }
                            coverageBoxes.add(rcb);
                            continue;
                        }
                        if (((RpfCoverageBox)coverageBoxes.get((int)0)).scale != rcb.scale) continue;
                        coverageBoxes.add(rcb);
                    }
                    if (addedCurrent || !okToAddCurrent || ((RpfCoverageBox)coverageBoxes.get((int)0)).scale != currentCoverage.scale) continue;
                    coverageBoxes.add(currentCoverage);
                    continue;
                }
                if (!Debug.debugging("rpftoc")) continue;
                System.out.println("RFCH: Toc " + i + " did NOT return an entry");
            }
        }
        return coverageBoxes;
    }

    public String getSubframeAttributes(int tocNumber, int entryNumber, int x, int y) {
        RpfFrameEntry frameEntry;
        RpfFrame frame;
        if (!this.tocs[tocNumber].isValid()) {
            return null;
        }
        RpfTocEntry entry = this.tocs[tocNumber].entries[entryNumber];
        if (y < 0 || x < 0 || entry == null || y >= entry.vertFrames * 6 || x >= entry.horizFrames * 6) {
            return null;
        }
        if (!entry.isFramesLoaded()) {
            this.tocs[tocNumber].loadFrameInformation(entry);
        }
        if ((frame = (RpfFrame)this.get(frameEntry = entry.getFrame(y / 6, x / 6))) == null) {
            return null;
        }
        return frame.getReport(x, y, frameEntry, entry.Cib);
    }

    public int[] getSubframeData(int tocNumber, int entryNumber, int x, int y) {
        RpfFrameEntry frameEntry;
        RpfFrame frame;
        if (!this.tocs[tocNumber].isValid()) {
            return null;
        }
        RpfTocEntry entry = this.tocs[tocNumber].entries[entryNumber];
        if (y < 0 || x < 0 || entry == null || y >= entry.vertFrames * 6 || x >= entry.horizFrames * 6) {
            return null;
        }
        if (!entry.isFramesLoaded()) {
            this.tocs[tocNumber].loadFrameInformation(entry);
        }
        if ((frame = (RpfFrame)this.get(frameEntry = entry.getFrame(y / 6, x / 6))) == null) {
            return null;
        }
        this.checkColortable(frame, frameEntry, entry, tocNumber, entryNumber);
        return frame.decompressSubframe(x, y, this.colortable);
    }

    public RpfIndexedImageData getRawSubframeData(int tocNumber, int entryNumber, int x, int y) {
        RpfFrameEntry frameEntry;
        RpfFrame frame;
        if (!this.tocs[tocNumber].isValid()) {
            return null;
        }
        RpfTocEntry entry = this.tocs[tocNumber].entries[entryNumber];
        if (y < 0 || x < 0 || entry == null || y >= entry.vertFrames * 6 || x >= entry.horizFrames * 6) {
            return null;
        }
        if (!entry.isFramesLoaded()) {
            this.tocs[tocNumber].loadFrameInformation(entry);
        }
        if ((frame = (RpfFrame)this.get(frameEntry = entry.getFrame(y / 6, x / 6))) == null) {
            return null;
        }
        this.checkColortable(frame, frameEntry, entry, tocNumber, entryNumber);
        RpfIndexedImageData riid = new RpfIndexedImageData();
        riid.imageData = frame.decompressSubframe(x, y);
        riid.colortable = this.colortable.colors;
        return riid;
    }

    protected void checkColortable(RpfFrame frame, RpfFrameEntry frameEntry, RpfTocEntry entry, int tocNumber, int entryNumber) {
        if (Debug.debugging("rpf")) {
            Debug.output("RpfFrameCacheHandler: getting new colors");
            Debug.output("RpfFrameCacheHandler: getting CIB colors = " + entry.Cib);
        }
        this.colortable.setFrom(frame.getColortable());
        this.colortable.setCib(entry.Cib);
        this.colortable.setATOCIndexes(tocNumber, entryNumber);
        this.colortable.zone = entry.zone;
        this.colortable.seriesCode = entry.info.seriesCode;
        if (this.viewAttributes != null) {
            this.colortable.setOpaqueness(this.viewAttributes.opaqueness);
        }
    }

    public static RpfTocHandler[] createTocHandlers(String[] RpfPaths) {
        RpfTocHandler[] tocs = new RpfTocHandler[RpfPaths != null ? RpfPaths.length : 0];
        for (int i = 0; i < tocs.length; ++i) {
            tocs[i] = new RpfTocHandler(RpfPaths[i], i);
        }
        return tocs;
    }

    public CacheObject load(String RpfFramePath) {
        RpfFrame frame = new RpfFrame(RpfFramePath);
        if (frame.isValid()) {
            CacheObject obj = new CacheObject(RpfFramePath, frame);
            return obj;
        }
        return null;
    }

    public Object get(RpfFrameEntry rfe) {
        CacheObject ret = this.searchCache(rfe.framePath);
        if (ret != null) {
            return ret.obj;
        }
        ret = this.load(rfe);
        if (ret == null) {
            return null;
        }
        if (Debug.debugging("rpfdetail")) {
            System.out.println(rfe);
        }
        this.replaceLeastUsed(ret);
        return ret.obj;
    }

    public CacheObject load(RpfFrameEntry rfe) {
        RpfFrame frame;
        if (!rfe.exists) {
            if (Debug.debugging("rpf")) {
                System.out.println("RpfFrameCacheHandler: Frame doesn't exist!: " + rfe.framePath);
            }
            return null;
        }
        if (Debug.debugging("rpf")) {
            Debug.output("RpfFrameCacheHandler: Loading Frame " + rfe.framePath);
        }
        if ((frame = new RpfFrame(rfe)).isValid()) {
            CacheObject obj = new CacheObject(rfe.framePath, frame);
            return obj;
        }
        if (Debug.debugging("rpf")) {
            Debug.error("RpfFrameCacheHandler:  Couldn't find frame /" + rfe.framePath + "/ (" + rfe.framePath.length() + " chars)");
        }
        rfe.exists = false;
        return null;
    }

    public void resizeCache(int max_size) {
        this.resetCache(max_size);
    }

    public void resetCache() {
        super.resetCache();
        Debug.message("rpf", "RpfFrameCacheHandler: reset frame cache.");
    }

    public static float scaleDifference(CADRG proj, RpfCoverageBox box) {
        return Math.abs(proj.getScale() - box.scale);
    }

    public RpfColortable getColortable() {
        return this.colortable;
    }

    public void setColortable(RpfColortable colortable) {
        this.colortable = colortable;
    }
}

