/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.layer.rpf.RpfCacheHandler;
import com.bbn.openmap.layer.rpf.RpfFrameProvider;
import com.bbn.openmap.layer.rpf.RpfSubframe;
import com.bbn.openmap.layer.rpf.RpfViewAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.Vector;

public class RpfCacheManager
implements Serializable {
    public static final int SMALL_CACHE_SIZE = 10;
    public static final int MAX_NUM_BOXES = 4;
    protected RpfCacheHandler[] caches = new RpfCacheHandler[4];
    protected RpfFrameProvider frameProvider;
    protected RpfViewAttributes viewAttributes;
    protected RpfMaps graphics;
    protected int auxCacheSize;

    public RpfCacheManager() {
    }

    public RpfCacheManager(RpfFrameProvider fp) {
        this(fp, new RpfViewAttributes());
    }

    public RpfCacheManager(RpfFrameProvider rfp, RpfViewAttributes rva) {
        this(rfp, rva, 20, 10);
    }

    public RpfCacheManager(RpfFrameProvider rfp, RpfViewAttributes rva, int mainCacheSize, int auxSubframeCacheSize) {
        this.frameProvider = rfp;
        this.viewAttributes = rva;
        this.caches[0] = new RpfCacheHandler(rfp, rva, mainCacheSize);
        this.graphics = new RpfMaps(rva);
        this.auxCacheSize = auxSubframeCacheSize;
    }

    public void clearCaches() {
        for (int i = 0; i < this.caches.length; ++i) {
            if (this.caches[i] == null) continue;
            this.caches[i].clearCache();
        }
    }

    public void setViewAttributes(RpfViewAttributes rva) {
        this.viewAttributes = rva;
        for (int i = 0; i < this.caches.length; ++i) {
            if (this.caches[i] == null) continue;
            this.caches[i].setViewAttributes(this.viewAttributes);
        }
    }

    public RpfViewAttributes getViewAttributes() {
        return this.viewAttributes;
    }

    public void setFrameProvider(RpfFrameProvider fp) {
        this.frameProvider = fp;
        for (int i = 0; i < this.caches.length; ++i) {
            if (this.caches[i] == null) continue;
            this.caches[i].setFrameProvider(fp);
        }
    }

    public RpfFrameProvider getFrameProvider() {
        return this.frameProvider;
    }

    public Vector getCoverageBoxes() {
        return this.caches[0].getCoverageBoxes();
    }

    public OMGraphicList getRectangle(Projection proj) {
        float[] lat = new float[3];
        float[] lon = new float[3];
        if (!(proj instanceof CADRG)) {
            if (this.viewAttributes.requireProjection) {
                return new OMGraphicList();
            }
            this.viewAttributes.proj = new CADRG(proj.getCenter(), proj.getScale(), proj.getWidth(), proj.getHeight());
        } else {
            this.viewAttributes.proj = (CADRG)proj;
        }
        if (this.frameProvider != null && this.frameProvider.needViewAttributeUpdates()) {
            this.frameProvider.setViewAttributes(this.viewAttributes);
        }
        int xa = 2;
        int ya = 2;
        int lat_minus = 2;
        int lon_minus = 2;
        LatLonPoint ll1 = proj.getUpperLeft();
        LatLonPoint ll2 = proj.getLowerRight();
        lat[0] = ll1.getLatitude();
        lon[0] = ll1.getLongitude();
        lat[1] = ll2.getLatitude();
        lon[1] = ll2.getLongitude();
        lat[2] = ll2.getLatitude();
        lon[2] = ll2.getLongitude();
        if (lon[0] > 0.0f && lon[2] < 0.0f) {
            lon[1] = -179.999f;
            lon_minus = 1;
        }
        if (lat[0] > 0.0f && lat[2] < 0.0f) {
            lat[1] = -1.0E-4f;
            lat_minus = 1;
        }
        if (Debug.debugging("rpf")) {
            Debug.output("RpfCacheManager - for:");
            Debug.output("\tlat[0] " + lat[0]);
            Debug.output("\tlon[0] " + lon[0]);
            Debug.output("\tlat[1] " + lat[1]);
            Debug.output("\tlon[1] " + lon[1]);
            Debug.output("\tlat[2] " + lat[2]);
            Debug.output("\tlon[2] " + lon[2]);
            Debug.output("\tlat_minus = " + lat_minus);
            Debug.output("\tlon_minus = " + lon_minus);
        }
        this.caches[0].setCache(lat[ya - lat_minus], lon[xa - lon_minus], lat[ya], lon[xa], this.viewAttributes.proj);
        if (Debug.debugging("rpf")) {
            Debug.output("RpfCacheManager: main (1) cache used.");
        }
        if (lon_minus == 1) {
            if (this.caches[1] == null) {
                this.caches[1] = new RpfCacheHandler(this.frameProvider, this.viewAttributes, this.auxCacheSize);
            }
            this.caches[1].setCache(lat[ya - lat_minus], lon[0], lat[ya], -1.0f * lon[1], this.viewAttributes.proj);
            if (Debug.debugging("rpf")) {
                Debug.output("-- second cache used");
            }
        } else {
            this.caches[1] = null;
        }
        if (lat_minus == 1) {
            if (this.caches[2] == null) {
                this.caches[2] = new RpfCacheHandler(this.frameProvider, this.viewAttributes, this.auxCacheSize);
            }
            this.caches[2].setCache(lat[0], lon[xa - lon_minus], -1.0f * lat[1], lon[xa], this.viewAttributes.proj);
            if (Debug.debugging("rpf")) {
                Debug.output("-- third cache used");
            }
        } else {
            this.caches[2] = null;
        }
        if (lon_minus == 1 && lat_minus == 1) {
            if (this.caches[3] == null) {
                this.caches[3] = new RpfCacheHandler(this.frameProvider, this.viewAttributes, this.auxCacheSize);
            }
            this.caches[3].setCache(lat[0], lon[0], -1.0f * lat[1], -1.0f * lon[1], this.viewAttributes.proj);
            if (Debug.debugging("rpf")) {
                Debug.output("-- fourth cache used");
            }
        } else {
            this.caches[3] = null;
        }
        OMGraphicList gl = new OMGraphicList();
        gl.add(this.getSubframes());
        return gl;
    }

    protected OMGraphic getSubframes() {
        this.graphics.clear();
        if (Debug.debugging("rpf")) {
            Debug.output("RpfCacheManager: show maps: " + this.viewAttributes.showMaps + ", showInfo: " + this.viewAttributes.showInfo);
        }
        if (!this.viewAttributes.showMaps && !this.viewAttributes.showInfo) {
            return this.graphics;
        }
        for (int nbox = 0; nbox < 4; ++nbox) {
            if (this.caches[nbox] == null || !this.caches[nbox].getGoodData()) continue;
            int subframeRunningCount = 0;
            for (int subx = this.caches[nbox].start.x; subx <= this.caches[nbox].end.x; ++subx) {
                for (int suby = this.caches[nbox].start.y; suby <= this.caches[nbox].end.y; ++suby) {
                    RpfSubframe subframe = this.caches[nbox].getCached(subx, suby, subframeRunningCount);
                    if (subframe == null) {
                        if (Debug.debugging("rpf")) {
                            Debug.output("RpfCacheManager: checking other TOCs for subframe.");
                        }
                        subframe = this.caches[nbox].getSubframeFromOtherTOC(subx, suby, subframeRunningCount);
                    }
                    if (subframe != null) {
                        this.graphics.addInfo(subframe.information);
                        this.graphics.addInfo(subframe.rectangle);
                        this.graphics.addMap(subframe.image);
                        if (Debug.debugging("rpf")) {
                            Debug.output("RpfCacheManager: Adding subframe " + subx + ", " + suby);
                        }
                    } else if (Debug.debugging("rpf")) {
                        Debug.output("RpfCacheManager: subframe " + subx + ", " + suby + " empty");
                    }
                    ++subframeRunningCount;
                }
            }
        }
        if (Debug.debugging("rpf")) {
            Debug.output("RpfCacheManager: done.");
        }
        return this.graphics;
    }

    public class RpfMaps
    extends OMGraphic {
        public RpfViewAttributes atts;
        public OMGraphicList maps = new OMGraphicList();
        public OMGraphicList infos = new OMGraphicList();

        public RpfMaps(RpfViewAttributes rva) {
            this.atts = rva;
        }

        public void clear() {
            this.maps.clear();
            this.infos.clear();
        }

        public void addMap(OMGraphic graphic) {
            this.maps.add(graphic);
        }

        public void addInfo(OMGraphic graphic) {
            this.infos.add(graphic);
        }

        public boolean generate(Projection proj) {
            this.maps.generate(proj);
            this.infos.generate(proj);
            return true;
        }

        public void render(Graphics g) {
            if (this.atts.showMaps) {
                this.maps.render(g);
            }
            if (this.atts.showInfo) {
                this.infos.render(g);
            }
        }

        public float distance(int x, int y) {
            return Float.MAX_VALUE;
        }
    }
}

