/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkGraphicConstants;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LinkRectangle
implements LinkGraphicConstants,
LinkPropertiesConstants {
    public static void write(float lt1, float ln1, float lt2, float ln2, int lType, LinkProperties properties, DataOutputStream dos) throws IOException {
        LinkRectangle.write(lt1, ln1, lt2, ln2, lType, -1, properties, dos);
    }

    public static void write(float lt1, float ln1, float lt2, float ln2, int lType, int nsegs, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<RE>".getBytes());
        dos.writeByte(5);
        dos.writeByte(1);
        dos.writeByte(lType);
        dos.writeFloat(lt1);
        dos.writeFloat(ln1);
        dos.writeFloat(lt2);
        dos.writeFloat(ln2);
        dos.writeInt(nsegs);
        properties.write(dos);
    }

    public static void write(int px1, int py1, int px2, int py2, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<RE>".getBytes());
        dos.writeByte(5);
        dos.writeByte(2);
        dos.writeInt(px1);
        dos.writeInt(py1);
        dos.writeInt(px2);
        dos.writeInt(py2);
        properties.write(dos);
    }

    public static void write(float lt1, float ln1, int px1, int py1, int px2, int py2, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<RE>".getBytes());
        dos.writeByte(5);
        dos.writeByte(3);
        dos.writeFloat(lt1);
        dos.writeFloat(ln1);
        dos.writeInt(px1);
        dos.writeInt(py1);
        dos.writeInt(px2);
        dos.writeInt(py2);
        properties.write(dos);
    }

    public static void write(OMRect rect, Link link, LinkProperties props) throws IOException {
        switch (rect.getRenderType()) {
            case 1: {
                LinkRectangle.write(rect.getNorthLat(), rect.getWestLon(), rect.getSouthLat(), rect.getEastLon(), rect.getLineType(), props, link.dos);
                break;
            }
            case 2: {
                LinkRectangle.write(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom(), props, link.dos);
                break;
            }
            case 3: {
                LinkRectangle.write(rect.getNorthLat(), rect.getWestLon(), rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom(), props, (DataOutputStream)link.dos);
                break;
            }
            default: {
                Debug.error("LinkRectangle.write: rect rendertype unknown.");
            }
        }
    }

    public static OMRect read(DataInputStream dis) throws IOException {
        return LinkRectangle.read(dis, null);
    }

    public static OMRect read(DataInputStream dis, LinkProperties propertiesBuffer) throws IOException {
        OMRect rect = null;
        byte renderType = dis.readByte();
        switch (renderType) {
            case 1: {
                byte lineType = dis.readByte();
                float lt1 = dis.readFloat();
                float ln1 = dis.readFloat();
                float lt2 = dis.readFloat();
                float ln2 = dis.readFloat();
                int nsegs = dis.readInt();
                rect = new OMRect(lt1, ln1, lt2, ln2, (int)lineType, nsegs);
                break;
            }
            case 2: {
                int x1 = dis.readInt();
                int y1 = dis.readInt();
                int x2 = dis.readInt();
                int y2 = dis.readInt();
                rect = new OMRect(x1, y1, x2, y2);
                break;
            }
            case 3: {
                float lt1 = dis.readFloat();
                float ln1 = dis.readFloat();
                int x1 = dis.readInt();
                int y1 = dis.readInt();
                int x2 = dis.readInt();
                int y2 = dis.readInt();
                rect = new OMRect(lt1, ln1, x1, y1, x2, y2);
                break;
            }
        }
        if (rect != null) {
            LinkProperties.loadPropertiesIntoOMGraphic(dis, rect, propertiesBuffer);
        }
        return rect;
    }
}

