/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkGraphicConstants;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LinkPoly
implements LinkGraphicConstants,
LinkPropertiesConstants {
    public static void write(float[] llPoints, int units, int lType, LinkProperties properties, DataOutputStream dos) throws IOException {
        LinkPoly.write(llPoints, units, lType, -1, properties, dos);
    }

    public static void write(float[] llpoints, int units, int lType, int nsegs, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<PY>".getBytes());
        dos.writeByte(3);
        dos.writeByte(1);
        dos.writeByte(lType);
        dos.writeInt(llpoints.length);
        for (int i = 0; i < llpoints.length; ++i) {
            dos.writeFloat(llpoints[i]);
        }
        dos.writeByte(units);
        dos.writeInt(nsegs);
        properties.write(dos);
    }

    public static void write(float[] latpoints, float[] lonpoints, int units, int lType, int nsegs, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<PY>".getBytes());
        dos.writeByte(3);
        dos.writeByte(1);
        dos.writeByte(lType);
        int length = latpoints.length;
        if (lonpoints.length < latpoints.length) {
            length = lonpoints.length;
        }
        dos.writeInt(length);
        for (int i = 0; i < length; ++i) {
            dos.writeFloat(latpoints[i]);
            dos.writeFloat(lonpoints[i]);
        }
        dos.writeByte(units);
        dos.writeInt(nsegs);
        properties.write(dos);
    }

    public static void write(int[] xypoints, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<PY>".getBytes());
        dos.writeByte(3);
        dos.writeByte(2);
        dos.writeInt(xypoints.length);
        for (int i = 0; i < xypoints.length; ++i) {
            dos.writeInt(xypoints[i]);
        }
        properties.write(dos);
    }

    public static void write(int[] xpoints, int[] ypoints, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<PY>".getBytes());
        dos.writeByte(3);
        dos.writeByte(2);
        int numPoints = xpoints.length + ypoints.length;
        dos.writeInt(numPoints);
        for (int i = 0; i < numPoints / 2; ++i) {
            dos.writeInt(xpoints[i]);
            dos.writeInt(ypoints[i]);
        }
        properties.write(dos);
    }

    public static void write(float latPoint, float lonPoint, int[] xypoints, int cMode, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<PY>".getBytes());
        dos.writeByte(3);
        dos.writeByte(3);
        dos.writeFloat(latPoint);
        dos.writeFloat(lonPoint);
        dos.writeInt(xypoints.length);
        for (int i = 0; i < xypoints.length; ++i) {
            dos.writeInt(xypoints[i]);
        }
        dos.writeByte(cMode);
        properties.write(dos);
    }

    public static void write(float latPoint, float lonPoint, int[] xpoints, int[] ypoints, int cMode, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<PY>".getBytes());
        dos.writeByte(3);
        dos.writeByte(3);
        dos.writeFloat(latPoint);
        dos.writeFloat(lonPoint);
        int numPoints = xpoints.length + ypoints.length;
        dos.writeInt(numPoints);
        for (int i = 0; i < numPoints / 2; ++i) {
            dos.writeInt(xpoints[i]);
            dos.writeInt(ypoints[i]);
        }
        dos.writeByte(cMode);
        properties.write(dos);
    }

    public static void write(OMPoly poly, Link link, LinkProperties props) throws IOException {
        switch (poly.getRenderType()) {
            case 1: {
                LinkPoly.write(poly.getLatLonArray(), 1, poly.getLineType(), poly.getNumSegs(), props, (DataOutputStream)link.dos);
                break;
            }
            case 2: {
                LinkPoly.write(poly.getXs(), poly.getYs(), props, link.dos);
                break;
            }
            case 3: {
                LinkPoly.write(poly.getLat(), poly.getLon(), poly.getXs(), poly.getYs(), poly.getCoordMode(), props, (DataOutputStream)link.dos);
                break;
            }
            default: {
                Debug.error("LinkPoly.write: poly rendertype unknown.");
            }
        }
    }

    public static OMPoly read(DataInputStream dis) throws IOException {
        return LinkPoly.read(dis, null);
    }

    public static OMPoly read(DataInputStream dis, LinkProperties propertiesBuffer) throws IOException {
        OMPoly poly = null;
        byte renderType = dis.readByte();
        switch (renderType) {
            case 1: {
                byte lineType = dis.readByte();
                int numPoints = dis.readInt();
                float[] llpoints = new float[numPoints];
                for (int i = 0; i < numPoints; ++i) {
                    llpoints[i] = dis.readFloat();
                }
                byte units = dis.readByte();
                int nsegs = dis.readInt();
                if (Debug.debugging("linkdetail")) {
                    System.out.println("  Lat/Lon LinkPoly:");
                    System.out.println("  linetype = " + lineType);
                    System.out.println("  number of points = " + numPoints / 2);
                    System.out.println("  units = " + units);
                    System.out.println("  nsegs = " + nsegs);
                }
                poly = new OMPoly(llpoints, units, lineType, nsegs);
                break;
            }
            case 2: {
                int numPoints = dis.readInt();
                int[] xpoints = new int[numPoints / 2];
                int[] ypoints = new int[numPoints / 2];
                for (int i = 0; i < numPoints / 2; ++i) {
                    xpoints[i] = dis.readInt();
                    ypoints[i] = dis.readInt();
                }
                if (Debug.debugging("linkdetail")) {
                    System.out.println("  X/Y LinkPoly:");
                    System.out.println("  number of points = " + numPoints / 2);
                }
                poly = new OMPoly(xpoints, ypoints);
                break;
            }
            case 3: {
                float lat_1 = dis.readFloat();
                float lon_1 = dis.readFloat();
                int numPoints = dis.readInt();
                int[] xpoints = new int[numPoints / 2];
                int[] ypoints = new int[numPoints / 2];
                for (int i = 0; i < numPoints / 2; ++i) {
                    xpoints[i] = dis.readInt();
                    ypoints[i] = dis.readInt();
                }
                byte cMode = dis.readByte();
                if (Debug.debugging("linkdetail")) {
                    System.out.println("  Offset LinkPoly:");
                    System.out.println("  lat = " + lat_1);
                    System.out.println("  lon = " + lon_1);
                    System.out.println("  number of points = " + numPoints / 2);
                    System.out.println("  cMode = " + cMode);
                }
                poly = new OMPoly(lat_1, lon_1, xpoints, ypoints, cMode);
                break;
            }
        }
        if (poly != null) {
            LinkProperties.loadPropertiesIntoOMGraphic(dis, poly, propertiesBuffer);
        }
        return poly;
    }
}

