/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkGraphicConstants;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LinkLine
implements LinkGraphicConstants,
LinkPropertiesConstants {
    public static void write(float lat_1, float lon_1, float lat_2, float lon_2, int lineType, LinkProperties properties, DataOutputStream dos) throws IOException {
        LinkLine.write(lat_1, lon_1, lat_2, lon_2, lineType, -1, properties, dos);
    }

    public static void write(float lat_1, float lon_1, float lat_2, float lon_2, int lineType, int nsegs, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<L>".getBytes());
        dos.writeByte(4);
        dos.writeByte(1);
        dos.writeByte(lineType);
        dos.writeFloat(lat_1);
        dos.writeFloat(lon_1);
        dos.writeFloat(lat_2);
        dos.writeFloat(lon_2);
        dos.writeInt(nsegs);
        properties.write(dos);
    }

    public static void write(int x1, int y1, int x2, int y2, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<L>".getBytes());
        dos.writeByte(4);
        dos.writeByte(2);
        dos.writeInt(x1);
        dos.writeInt(y1);
        dos.writeInt(x2);
        dos.writeInt(y2);
        properties.write(dos);
    }

    public static void write(float lat_1, float lon_1, int x1, int y1, int x2, int y2, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<L>".getBytes());
        dos.writeByte(4);
        dos.writeByte(3);
        dos.writeFloat(lat_1);
        dos.writeFloat(lon_1);
        dos.writeInt(x1);
        dos.writeInt(y1);
        dos.writeInt(x2);
        dos.writeInt(y2);
        properties.write(dos);
    }

    public static void write(OMLine line, Link link, LinkProperties props) throws IOException {
        switch (line.getRenderType()) {
            case 1: {
                float[] ll = line.getLL();
                LinkLine.write(ll[0], ll[1], ll[2], ll[3], line.getLineType(), line.getNumSegs(), props, (DataOutputStream)link.dos);
                break;
            }
            case 2: {
                int[] pts = line.getPts();
                LinkLine.write(pts[0], pts[1], pts[2], pts[3], props, link.dos);
                break;
            }
            case 3: {
                float[] ll = line.getLL();
                int[] pts = line.getPts();
                LinkLine.write(ll[0], ll[1], pts[0], pts[1], pts[2], pts[3], props, (DataOutputStream)link.dos);
                break;
            }
            default: {
                Debug.error("LinkLine.write: line rendertype unknown.");
            }
        }
    }

    public static OMLine read(DataInputStream dis) throws IOException {
        return LinkLine.read(dis, null);
    }

    public static OMLine read(DataInputStream dis, LinkProperties propertiesBuffer) throws IOException {
        OMLine line = null;
        float lat_1 = 0.0f;
        float lon_1 = 0.0f;
        float lat_2 = 0.0f;
        float lon_2 = 0.0f;
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        int nsegs = -1;
        byte renderType = dis.readByte();
        switch (renderType) {
            case 1: {
                byte lineType = dis.readByte();
                lat_1 = dis.readFloat();
                lon_1 = dis.readFloat();
                lat_2 = dis.readFloat();
                lon_2 = dis.readFloat();
                nsegs = dis.readInt();
                line = new OMLine(lat_1, lon_1, lat_2, lon_2, (int)lineType, nsegs);
                break;
            }
            case 2: {
                x1 = dis.readInt();
                y1 = dis.readInt();
                x2 = dis.readInt();
                y2 = dis.readInt();
                line = new OMLine(x1, y1, x2, y2);
                break;
            }
            case 3: {
                lat_1 = dis.readFloat();
                lon_1 = dis.readFloat();
                x1 = dis.readInt();
                y1 = dis.readInt();
                x2 = dis.readInt();
                y2 = dis.readInt();
                line = new OMLine(lat_1, lon_1, x1, y1, x2, y2);
                break;
            }
        }
        if (line != null) {
            LinkProperties.loadPropertiesIntoOMGraphic(dis, line, propertiesBuffer);
        }
        return line;
    }
}

