/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.learn;

import com.bbn.openmap.event.MapMouseEvent;
import com.bbn.openmap.layer.learn.BasicLayer;
import com.bbn.openmap.layer.policy.StandardPCPolicy;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMTextLabeler;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;

public class InteractionLayer
extends BasicLayer {
    public InteractionLayer() {
        this.setName("Interaction Layer");
        this.setProjectionChangePolicy(new StandardPCPolicy(this, true));
        this.setMouseModeIDsForEvents(new String[]{"Gestures"});
    }

    public OMGraphicList init() {
        OMGraphicList omList = new OMGraphicList();
        OMLine line = new OMLine(40.0f, -75.0f, 42.0f, -70.0f, 3);
        line.setStroke(new BasicStroke(2.0f));
        line.putAttribute("Label", new OMTextLabeler("Line Label"));
        line.setLinePaint(Color.red);
        line.setSelectPaint(Color.blue);
        line.putAttribute("Tooltip", "This is an OMLine.");
        omList.add(line);
        OMGraphicList pointList = new OMGraphicList();
        for (int i = 0; i < 100; ++i) {
            OMPoint point = new OMPoint((float)(Math.random() * 89.0), (float)(Math.random() * -179.0), 3);
            point.putAttribute("Tooltip", "This is OMPoint #" + i);
            point.setLinePaint(Color.green);
            point.setSelectPaint(Color.yellow);
            pointList.add(point);
        }
        omList.add(pointList);
        return omList;
    }

    public boolean isHighlightable(OMGraphic omg) {
        return true;
    }

    public boolean isSelectable(OMGraphic omg) {
        return true;
    }

    public void select(OMGraphicList list) {
        super.select(list);
        if (this.selectedList != null) {
            System.out.println("Current selection list: " + this.selectedList.getDescription());
        }
    }

    public void deselect(OMGraphicList list) {
        super.deselect(list);
        if (this.selectedList != null) {
            System.out.println("Current selection list: " + this.selectedList.getDescription());
        }
    }

    public String getInfoText(OMGraphic omg) {
        String classname = omg.getClass().getName();
        return "Interaction Layer OMGraphic - " + classname.substring(classname.lastIndexOf(46) + 1);
    }

    public String getToolTipTextFor(OMGraphic omg) {
        Object tt = omg.getAttribute("Tooltip");
        if (tt instanceof String) {
            return (String)tt;
        }
        return null;
    }

    public List getItemsForMapMenu(MapMouseEvent me) {
        ArrayList<JMenuItem> l = new ArrayList<JMenuItem>();
        JMenuItem when = new JMenuItem("When");
        when.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InteractionLayer.this.fireRequestMessage("When was chosen.");
            }
        });
        JMenuItem where = new JMenuItem("Where");
        where.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InteractionLayer.this.fireRequestMessage("Where was chosen.");
            }
        });
        JMenuItem how = new JMenuItem("How");
        how.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InteractionLayer.this.fireRequestMessage("How was chosen.");
            }
        });
        l.add(when);
        l.add(where);
        l.add(how);
        return l;
    }

    public List getItemsForOMGraphicMenu(OMGraphic omg) {
        final OMGraphic chosen = omg;
        ArrayList<JMenuItem> l = new ArrayList<JMenuItem>();
        JMenuItem which = new JMenuItem("Which");
        which.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String classname = chosen.getClass().getName();
                InteractionLayer.this.fireRequestMessage("Which was chosen over " + classname.substring(classname.lastIndexOf(46) + 1));
            }
        });
        JMenuItem why = new JMenuItem("Why");
        why.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String classname = chosen.getClass().getName();
                InteractionLayer.this.fireRequestMessage("Why was chosen over " + classname.substring(classname.lastIndexOf(46) + 1));
            }
        });
        l.add(which);
        l.add(why);
        return l;
    }
}

