/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.Environment;
import com.bbn.openmap.event.CenterListener;
import com.bbn.openmap.event.CenterSupport;
import com.bbn.openmap.event.PanListener;
import com.bbn.openmap.event.PanSupport;
import com.bbn.openmap.gui.OMToolComponent;
import com.bbn.openmap.util.Debug;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class NavigatePanel
extends OMToolComponent
implements Serializable,
ActionListener {
    public static final String panNWCmd = "panNW";
    public static final String panNCmd = "panN";
    public static final String panNECmd = "panNE";
    public static final String panECmd = "panE";
    public static final String panSECmd = "panSE";
    public static final String panSCmd = "panS";
    public static final String panSWCmd = "panSW";
    public static final String panWCmd = "panW";
    public static final String centerCmd = "center";
    protected transient JButton nwButton = null;
    protected transient JButton nButton = null;
    protected transient JButton neButton = null;
    protected transient JButton eButton = null;
    protected transient JButton seButton = null;
    protected transient JButton sButton = null;
    protected transient JButton swButton = null;
    protected transient JButton wButton = null;
    protected transient JButton cButton = null;
    protected static String nwName = "nw.gif";
    protected static String nName = "n.gif";
    protected static String neName = "ne.gif";
    protected static String eName = "e.gif";
    protected static String seName = "se.gif";
    protected static String sName = "s.gif";
    protected static String swName = "sw.gif";
    protected static String wName = "w.gif";
    protected static String cName = "center.gif";
    protected PanSupport panDelegate;
    protected CenterSupport centerDelegate;
    protected boolean useTips = false;
    protected float panFactor = 1.0f;
    protected boolean useDefaultCenter = false;
    protected float defaultCenterLat = 0.0f;
    protected float defaultCenterLon = 0.0f;
    public static final String defaultKey = "navigatepanel";
    static /* synthetic */ Class class$com$bbn$openmap$gui$NavigatePanel;

    public NavigatePanel() {
        this.setKey(defaultKey);
        this.panDelegate = new PanSupport(this);
        this.centerDelegate = new CenterSupport(this);
        JPanel panel = new JPanel();
        GridBagLayout internalGridbag = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        panel.setLayout(internalGridbag);
        String info = this.i18n.get(class$com$bbn$openmap$gui$NavigatePanel == null ? (class$com$bbn$openmap$gui$NavigatePanel = NavigatePanel.class$("com.bbn.openmap.gui.NavigatePanel")) : class$com$bbn$openmap$gui$NavigatePanel, "panNW.tooltip", "Pan Northwest");
        this.nwButton = this.getButton(nwName, info, panNWCmd);
        c2.gridx = 0;
        c2.gridy = 0;
        internalGridbag.setConstraints(this.nwButton, c2);
        panel.add(this.nwButton);
        info = this.i18n.get(class$com$bbn$openmap$gui$NavigatePanel == null ? (class$com$bbn$openmap$gui$NavigatePanel = NavigatePanel.class$("com.bbn.openmap.gui.NavigatePanel")) : class$com$bbn$openmap$gui$NavigatePanel, "panN.tooltip", "Pan North");
        this.nButton = this.getButton(nName, info, panNCmd);
        c2.gridx = 1;
        c2.gridy = 0;
        internalGridbag.setConstraints(this.nButton, c2);
        panel.add(this.nButton);
        info = this.i18n.get(class$com$bbn$openmap$gui$NavigatePanel == null ? (class$com$bbn$openmap$gui$NavigatePanel = NavigatePanel.class$("com.bbn.openmap.gui.NavigatePanel")) : class$com$bbn$openmap$gui$NavigatePanel, "panNE.tooltip", "Pan Northeast");
        this.neButton = this.getButton(neName, info, panNECmd);
        c2.gridx = 2;
        c2.gridy = 0;
        internalGridbag.setConstraints(this.neButton, c2);
        panel.add(this.neButton);
        info = this.i18n.get(class$com$bbn$openmap$gui$NavigatePanel == null ? (class$com$bbn$openmap$gui$NavigatePanel = NavigatePanel.class$("com.bbn.openmap.gui.NavigatePanel")) : class$com$bbn$openmap$gui$NavigatePanel, "panW.tooltip", "Pan West");
        this.wButton = this.getButton(wName, info, panWCmd);
        c2.gridx = 0;
        c2.gridy = 1;
        internalGridbag.setConstraints(this.wButton, c2);
        panel.add(this.wButton);
        info = this.i18n.get(class$com$bbn$openmap$gui$NavigatePanel == null ? (class$com$bbn$openmap$gui$NavigatePanel = NavigatePanel.class$("com.bbn.openmap.gui.NavigatePanel")) : class$com$bbn$openmap$gui$NavigatePanel, "center.tooltip", "Center Map at Starting Coords");
        this.cButton = this.getButton(cName, info, centerCmd);
        c2.gridx = 1;
        c2.gridy = 1;
        internalGridbag.setConstraints(this.cButton, c2);
        panel.add(this.cButton);
        info = this.i18n.get(class$com$bbn$openmap$gui$NavigatePanel == null ? (class$com$bbn$openmap$gui$NavigatePanel = NavigatePanel.class$("com.bbn.openmap.gui.NavigatePanel")) : class$com$bbn$openmap$gui$NavigatePanel, "panE.tooltip", "Pan East");
        this.eButton = this.getButton(eName, info, panECmd);
        c2.gridx = 2;
        c2.gridy = 1;
        internalGridbag.setConstraints(this.eButton, c2);
        panel.add(this.eButton);
        info = this.i18n.get(class$com$bbn$openmap$gui$NavigatePanel == null ? (class$com$bbn$openmap$gui$NavigatePanel = NavigatePanel.class$("com.bbn.openmap.gui.NavigatePanel")) : class$com$bbn$openmap$gui$NavigatePanel, "panSW.tooltip", "Pan Southwest");
        this.swButton = this.getButton(swName, info, panSWCmd);
        c2.gridx = 0;
        c2.gridy = 2;
        internalGridbag.setConstraints(this.swButton, c2);
        panel.add(this.swButton);
        info = this.i18n.get(class$com$bbn$openmap$gui$NavigatePanel == null ? (class$com$bbn$openmap$gui$NavigatePanel = NavigatePanel.class$("com.bbn.openmap.gui.NavigatePanel")) : class$com$bbn$openmap$gui$NavigatePanel, "panS.tooltip", "Pan South");
        this.sButton = this.getButton(sName, info, panSCmd);
        c2.gridx = 1;
        c2.gridy = 2;
        internalGridbag.setConstraints(this.sButton, c2);
        panel.add(this.sButton);
        info = this.i18n.get(class$com$bbn$openmap$gui$NavigatePanel == null ? (class$com$bbn$openmap$gui$NavigatePanel = NavigatePanel.class$("com.bbn.openmap.gui.NavigatePanel")) : class$com$bbn$openmap$gui$NavigatePanel, "panSE.tooltip", "Pan Southeast");
        this.seButton = this.getButton(seName, info, panSECmd);
        c2.gridx = 2;
        c2.gridy = 2;
        internalGridbag.setConstraints(this.seButton, c2);
        panel.add(this.seButton);
        this.add(panel);
    }

    protected JButton getButton(String name, String info, String command) {
        URL url = (class$com$bbn$openmap$gui$NavigatePanel == null ? (class$com$bbn$openmap$gui$NavigatePanel = NavigatePanel.class$("com.bbn.openmap.gui.NavigatePanel")) : class$com$bbn$openmap$gui$NavigatePanel).getResource(name);
        ImageIcon icon = new ImageIcon(url, info);
        JButton b = new JButton(icon);
        b.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        b.setToolTipText(info);
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setActionCommand(command);
        b.addActionListener(this);
        b.setBorderPainted(Debug.debugging("layout"));
        b.setOpaque(false);
        return b;
    }

    public synchronized void addCenterListener(CenterListener listener) {
        this.centerDelegate.addCenterListener(listener);
    }

    public synchronized void removeCenterListener(CenterListener listener) {
        this.centerDelegate.removeCenterListener(listener);
    }

    public synchronized void addPanListener(PanListener listener) {
        this.panDelegate.addPanListener(listener);
    }

    public synchronized void removePanListener(PanListener listener) {
        this.panDelegate.removePanListener(listener);
    }

    protected synchronized void fireCenterEvent(float lat, float lon) {
        this.centerDelegate.fireCenter(lat, lon);
    }

    protected synchronized void firePanEvent(float az) {
        this.panDelegate.firePan(az);
    }

    public float getPanFactor() {
        return this.panFactor;
    }

    public void setPanFactor(float panFactor) {
        if (panFactor < 0.0f || panFactor > 1.0f) {
            throw new IllegalArgumentException("should be: (0.0 <= panFactor <= 1.0)");
        }
        this.panFactor = panFactor;
    }

    public void setDefaultCenter(float passedLat, float passedLon) {
        this.useDefaultCenter = true;
        this.defaultCenterLat = passedLat;
        this.defaultCenterLon = passedLon;
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Debug.message("navpanel", "NavigatePanel.actionPerformed(): " + command);
        if (command.equals(panNWCmd)) {
            this.firePanEvent(-45.0f);
        } else if (command.equals(panNCmd)) {
            this.firePanEvent(0.0f);
        } else if (command.equals(panNECmd)) {
            this.firePanEvent(45.0f);
        } else if (command.equals(panECmd)) {
            this.firePanEvent(90.0f);
        } else if (command.equals(panSECmd)) {
            this.firePanEvent(135.0f);
        } else if (command.equals(panSCmd)) {
            this.firePanEvent(180.0f);
        } else if (command.equals(panSWCmd)) {
            this.firePanEvent(-135.0f);
        } else if (command.equals(panWCmd)) {
            this.firePanEvent(-90.0f);
        } else if (command.equals(centerCmd)) {
            float lon;
            float lat;
            if (this.useDefaultCenter) {
                lat = this.defaultCenterLat;
                lon = this.defaultCenterLon;
            } else {
                lat = Environment.getFloat("openmap.Latitude", 0.0f);
                lon = Environment.getFloat("openmap.Longitude", 0.0f);
            }
            this.fireCenterEvent(lat, lon);
        }
    }

    public void findAndInit(Object obj) {
        if (obj instanceof PanListener) {
            this.addPanListener((PanListener)obj);
        }
        if (obj instanceof CenterListener) {
            this.addCenterListener((CenterListener)obj);
        }
    }

    public void findAndUndo(Object obj) {
        if (obj instanceof PanListener) {
            this.removePanListener((PanListener)obj);
        }
        if (obj instanceof CenterListener) {
            this.removeCenterListener((CenterListener)obj);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

