/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.GeoRegion;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Stack;
import java.util.TreeSet;

public class ConvexHull {
    private ConvexHull() {
    }

    public static final GeoRegion getRegion(Geo[] geos) {
        Geo[] regionGeos = ConvexHull.hull(geos);
        return new GeoRegion.Impl(regionGeos);
    }

    public static final Geo[] hull(Geo[] geos) {
        Geo pivot = ConvexHull.findHighest(geos);
        TreeSet<Geo> sortedGeos = new TreeSet<Geo>(new PivotAngleComparator(pivot));
        for (int i = 0; i < geos.length; ++i) {
            Geo g = geos[i];
            if (g == pivot) continue;
            sortedGeos.add(g);
        }
        Stack<Geo> hullStack = new Stack<Geo>();
        hullStack.push(pivot);
        Geo midCross = null;
        Geo geo = null;
        Geo endGeo = null;
        Geo midGeo = null;
        Iterator sortedGeoIt = sortedGeos.iterator();
        if (sortedGeoIt.hasNext()) {
            midGeo = (Geo)sortedGeoIt.next();
            while (midGeo.distance(pivot) == 0.0 && sortedGeoIt.hasNext()) {
                midGeo = (Geo)sortedGeoIt.next();
            }
        }
        Geo lastGeoRead = midGeo;
        while (sortedGeoIt.hasNext() && midGeo != null) {
            geo = (Geo)sortedGeoIt.next();
            if (geo.distance(lastGeoRead) == 0.0) continue;
            endGeo = (Geo)hullStack.peek();
            midCross = endGeo.crossNormalize(midGeo);
            Geo gCross = midGeo.crossNormalize(geo);
            Geo i = gCross.crossNormalize(midCross).antipode();
            if (midGeo.distance(i) < 1.5707963267948966) {
                hullStack.push(midGeo);
                endGeo = midGeo;
                midGeo = geo;
            } else {
                while (hullStack.size() > 1) {
                    midGeo = (Geo)hullStack.pop();
                    endGeo = (Geo)hullStack.peek();
                    midCross = endGeo.crossNormalize(midGeo);
                    gCross = midGeo.crossNormalize(geo);
                    i = gCross.crossNormalize(midCross).antipode();
                    if (!(midGeo.distance(i) < 1.5707963267948966)) continue;
                    hullStack.push(midGeo);
                    midGeo = geo;
                    break;
                }
            }
            lastGeoRead = geo;
        }
        if (midGeo != null) {
            hullStack.push(midGeo);
        }
        hullStack.push(pivot);
        Geo[] regionGeos = new Geo[hullStack.size()];
        int i = 0;
        while (!hullStack.isEmpty()) {
            regionGeos[i++] = (Geo)hullStack.pop();
        }
        return regionGeos;
    }

    protected static Geo findHighest(Geo[] geos) {
        Geo ret = null;
        double highest = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < geos.length; ++i) {
            double lat = geos[i].getLatitude();
            if (!(lat > highest)) continue;
            highest = lat;
            ret = geos[i];
        }
        return ret;
    }

    protected static final class PivotAngleComparator
    implements Comparator,
    Serializable {
        private Geo pivot;

        public PivotAngleComparator(Geo pivot) {
            this.pivot = pivot;
        }

        public int compare(Object obj1, Object obj2) {
            double ang1 = Double.MAX_VALUE;
            double ang2 = Double.MAX_VALUE;
            int ret = 0;
            if (obj1 instanceof Geo) {
                ang1 = Math.toDegrees(this.pivot.azimuth((Geo)obj1));
            }
            if (obj2 instanceof Geo) {
                ang2 = Math.toDegrees(this.pivot.azimuth((Geo)obj2));
            }
            if (ang1 < ang2) {
                ret = 1;
            } else if (ang1 >= ang2) {
                ret = -1;
            }
            return ret;
        }

        public Geo getPivot() {
            return this.pivot;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PivotAngleComparator) {
                return this.pivot.equals(((PivotAngleComparator)obj).pivot);
            }
            return false;
        }

        public int hashCode() {
            return this.pivot.hashCode();
        }
    }
}

