/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.input.DbfInputStream;
import com.bbn.openmap.dataAccess.shape.output.DbfOutputStream;
import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.FileUtils;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class DbfFile
extends DbfTableModel {
    protected int _rowCount;
    protected int _recordLength;
    protected int _headerLength;
    protected Object[] _columnMask = null;
    protected DecimalFormat df = new DecimalFormat();
    protected BinaryFile bf;

    protected DbfFile() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.ENGLISH);
        this.df.setDecimalFormatSymbols(dfs);
    }

    public DbfFile(int columnCount) {
        this();
        this._columnCount = columnCount;
        this._records = new ArrayList();
        this._lengths = new int[columnCount];
        this._decimalCounts = new byte[columnCount];
        this._types = new byte[columnCount];
        this._names = new String[columnCount];
    }

    public DbfFile(BinaryFile bf) throws EOFException, FormatException, IOException {
        this();
        this.setBinaryFile(bf);
    }

    public void readHeader(BinaryFile bf) throws FormatException, IOException {
        try {
            bf.seek(0L);
            bf.byteOrder(false);
            bf.read();
            bf.read();
            bf.read();
            bf.read();
            this._rowCount = bf.readInteger();
            this._headerLength = bf.readShort();
            this._recordLength = bf.readShort();
            this._columnCount = (this._headerLength - 32 - 1) / 32;
            bf.skipBytes(20L);
            this._names = new String[this._columnCount];
            this._types = new byte[this._columnCount];
            this._lengths = new int[this._columnCount];
            this._decimalCounts = new byte[this._columnCount];
            for (int n = 0; n <= this._columnCount - 1; ++n) {
                this._names[n] = bf.readFixedLengthString(11);
                int ix = this._names[n].indexOf(0);
                if (ix > 0) {
                    this._names[n] = this._names[n].substring(0, ix);
                }
                this._types[n] = (byte)bf.read();
                bf.skipBytes(4L);
                this._lengths[n] = bf.readUnsigned();
                this._decimalCounts[n] = (byte)bf.read();
                bf.skipBytes(14L);
            }
            if (this.DEBUG && (long)this._headerLength != bf.getFilePointer()) {
                Debug.output("DbfFile: Header length specified in file doesn't match current pointer location");
            }
        }
        catch (EOFException eofe) {
            throw new FormatException(eofe.getMessage());
        }
    }

    public void readData() throws IOException, FormatException {
        this.readData(0, this._rowCount);
    }

    public void readData(int startingRecordIndex, int numRecordsToRead) throws IOException, FormatException {
        if (startingRecordIndex < 0) {
            startingRecordIndex = 0;
        }
        if (numRecordsToRead < 0 || numRecordsToRead > this._rowCount - startingRecordIndex) {
            numRecordsToRead = this._rowCount - startingRecordIndex;
        }
        this._records = new ArrayList(numRecordsToRead);
        for (int r = startingRecordIndex; r <= numRecordsToRead - 1; ++r) {
            List record = this.getRecordData(r);
            this._records.add(record);
        }
    }

    public List getRecordData(int index) throws IOException, FormatException {
        if (this.bf == null) {
            throw new IOException("DbfFile not set with valid BinaryFile.");
        }
        this.bf.seek(this._headerLength + index * this._recordLength);
        this.bf.read();
        int columnCount = this._columnCount;
        if (this._columnMask != null) {
            columnCount = this._columnMask.length;
        }
        ArrayList<Object> record = new ArrayList<Object>(this._columnCount);
        int targetColumnIndex = 0;
        for (int c = 0; c <= columnCount - 1; ++c) {
            if (this._columnMask == null || this._columnMask[c] == Boolean.TRUE) {
                int length = this._lengths[targetColumnIndex];
                if (length == -1) {
                    length = 255;
                }
                byte type = this._types[targetColumnIndex];
                String cell = this.bf.readFixedLengthString(length).trim();
                if (type == 78 && !cell.equals("")) {
                    try {
                        record.add(targetColumnIndex, new Double(this.df.parse(cell).doubleValue()));
                    }
                    catch (ParseException pe) {
                        if (Debug.debugging("shape")) {
                            Debug.error("DbfInputStream:  error parsing column " + targetColumnIndex + ", row " + index + ", expected number and got " + cell);
                        }
                        record.add(targetColumnIndex, DbfInputStream.ZERO);
                    }
                } else {
                    record.add(targetColumnIndex, cell);
                }
                ++targetColumnIndex;
                continue;
            }
            this.bf.skipBytes(((Integer)this._columnMask[c]).intValue());
        }
        return record;
    }

    public void clearRecords() {
        if (this._records != null) {
            this._records.clear();
        }
    }

    public DbfTableModel headerClone() {
        int size = this.getColumnCount();
        DbfFile dtm = new DbfFile(size);
        for (int i = 0; i < size; ++i) {
            dtm.setColumnName(i, this.getColumnName(i));
            dtm.setDecimalCount(i, this.getDecimalCount(i));
            dtm.setLength(i, this.getLength(i));
            dtm.setType(i, this.getType(i));
        }
        return dtm;
    }

    public static DbfTableModel getDbfTableModel(URL dbf) {
        return DbfFile.getDbfTableModel(dbf.toString());
    }

    public static DbfTableModel getDbfTableModel(String dbf) {
        DbfFile model;
        block2: {
            model = null;
            try {
                BinaryBufferedFile bbf = new BinaryBufferedFile(dbf);
                model = new DbfFile(bbf);
            }
            catch (Exception exception) {
                if (!Debug.debugging("shape")) break block2;
                Debug.error("problem loading DBF file" + exception.getMessage());
            }
        }
        return model;
    }

    public static void main(String[] args) {
        Debug.init();
        ArgParser ap = new ArgParser("DbfFile");
        ap.add("columns", "Print field header information.");
        ap.add("mask", "Only show listed columns", -1);
        ap.add("source", "The dbf file to read.", 1);
        ap.add("target", "The dbf file to write, use with mask to remove columns into new dbf file.", 1);
        ap.add("num", "Specify the number of records to read and display (handy for large dbf files)", 1);
        if (!ap.parse(args)) {
            ap.printUsage();
            System.exit(0);
        }
        String source = null;
        String target = null;
        double num = Double.MAX_VALUE;
        String[] ags = ap.getArgValues("source");
        if (ags != null) {
            source = ags[0];
        } else {
            source = FileUtils.getFilePathToOpenFromUser("Choose DBF file");
            if (source == null) {
                System.exit(0);
            }
        }
        ags = ap.getArgValues("target");
        if (ags != null) {
            target = ags[0];
        }
        boolean readData = ap.getArgValues("columns") == null;
        ags = ap.getArgValues("num");
        if (ags != null) {
            try {
                num = Double.parseDouble(ags[0]);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        String[] columnMask = ap.getArgValues("mask");
        String[] columns = ap.getArgValues("columns");
        try {
            DbfFile dtm = (DbfFile)DbfFile.getDbfTableModel(source);
            if (columns != null) {
                dtm.setColumnMask(columnMask);
            }
            if (target != null) {
                FileOutputStream os = new FileOutputStream(target);
                DbfOutputStream dos = new DbfOutputStream(os);
                dos.writeModel(dtm);
            } else {
                if (readData) {
                    dtm.readData(0, (int)num);
                }
                dtm.setWritable(true);
                dtm.exitOnClose = true;
                dtm.showGUI(args[0], 19);
            }
        }
        catch (Exception e) {
            Debug.error(e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean[] getColumnMask() {
        boolean[] columnMask = new boolean[this._columnMask.length];
        for (int i = 0; i < this._columnMask.length; ++i) {
            columnMask[i] = this._columnMask[i] == Boolean.TRUE;
        }
        return columnMask;
    }

    protected void createColumnMaskArray(boolean[] mask) {
        if (mask != null && mask.length <= this._columnCount) {
            this._columnMask = new Object[mask.length];
            for (int i = 0; i < mask.length; ++i) {
                this._columnMask[i] = mask[i] ? (Comparable<Boolean>)Boolean.TRUE : (Comparable<Boolean>)new Integer(this._lengths[i]);
            }
            this.resolveColumns();
        }
    }

    public void setColumnMask(boolean[] mask) {
        try {
            if (this._columnMask != null) {
                this.readHeader(this.bf);
            }
        }
        catch (Exception e) {
            Debug.error("problem setting column mask for DbfFile" + e.getMessage());
        }
        this.createColumnMaskArray(mask);
    }

    public void setColumnMask(String[] columnNames) {
        try {
            if (this._columnMask != null) {
                this.readHeader(this.bf);
            }
        }
        catch (Exception e) {
            Debug.error("problem setting column mask for DbfFile" + e.getMessage());
        }
        if (columnNames != null && this._names != null) {
            boolean[] mask = new boolean[this._names.length];
            block2: for (int j = 0; j < this._names.length; ++j) {
                for (int i = 0; i < columnNames.length; ++i) {
                    if (!this._names[j].equalsIgnoreCase(columnNames[i])) continue;
                    mask[j] = true;
                    continue block2;
                }
            }
            this.createColumnMaskArray(mask);
        }
    }

    protected void resolveColumns() {
        if (this._columnMask != null && this._columnMask.length == this._columnCount) {
            int newColumnCount = 0;
            for (int i = 0; i < this._columnMask.length; ++i) {
                if (this._columnMask[i] != Boolean.TRUE) continue;
                ++newColumnCount;
            }
            ArrayList records = null;
            if (this._records != null) {
                records = new ArrayList(this._rowCount);
            }
            int[] lengths = new int[newColumnCount];
            byte[] decimalCounts = new byte[newColumnCount];
            byte[] types = new byte[newColumnCount];
            String[] names = new String[newColumnCount];
            int newIndex = 0;
            for (int i = 0; i < this._columnMask.length; ++i) {
                if (this._columnMask[i] != Boolean.TRUE) continue;
                lengths[newIndex] = this._lengths[i];
                decimalCounts[newIndex] = this._decimalCounts[i];
                types[newIndex] = this._types[i];
                names[newIndex] = this._names[i];
                if (records != null) {
                    records.add(this._records.get(i));
                }
                ++newIndex;
            }
            this._lengths = lengths;
            this._decimalCounts = decimalCounts;
            this._types = types;
            this._names = names;
            this._columnCount = newColumnCount;
            if (records != null) {
                this._records = records;
            }
        }
    }

    public int getHeaderLength() {
        return this._headerLength;
    }

    public void setHeaderLength(int length) {
        this._headerLength = length;
    }

    public int getRecordLength() {
        return this._recordLength;
    }

    public void setRecordLength(int length) {
        this._recordLength = length;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public void setRowCount(int count) {
        this._rowCount = count;
    }

    public BinaryFile getBinaryFile() {
        return this.bf;
    }

    public void setBinaryFile(BinaryFile bf) throws EOFException, FormatException, IOException {
        this.bf = bf;
        this.readHeader(bf);
    }

    public DecimalFormat getDecimalFormat() {
        return this.df;
    }

    public void setDecimalFormat(DecimalFormat df) {
        this.df = df;
    }
}

