/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.iso8211;

import com.bbn.openmap.dataAccess.iso8211.DDFFieldDefinition;
import com.bbn.openmap.dataAccess.iso8211.DDFSubfield;
import com.bbn.openmap.dataAccess.iso8211.DDFSubfieldDefinition;
import com.bbn.openmap.layer.vpf.MutableInt;
import com.bbn.openmap.util.Debug;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class DDFField {
    protected DDFFieldDefinition poDefn;
    protected byte[] pachData;
    protected Hashtable subfields;
    protected int dataPosition;
    protected int dataLength;
    protected int headerOffset;

    public DDFField() {
    }

    public DDFField(DDFFieldDefinition poDefnIn, int dataPositionIn, int dataLengthIn) {
        this.initialize(poDefnIn, null);
        this.dataPosition = dataPositionIn;
        this.dataLength = dataLengthIn;
    }

    public DDFField(DDFFieldDefinition poDefnIn, byte[] pachDataIn) {
        this(poDefnIn, pachDataIn, true);
    }

    public DDFField(DDFFieldDefinition poDefnIn, byte[] pachDataIn, boolean doSubfields) {
        this.initialize(poDefnIn, pachDataIn);
        if (doSubfields) {
            this.buildSubfields();
        }
    }

    public void initialize(DDFFieldDefinition poDefnIn, byte[] pachDataIn) {
        this.pachData = pachDataIn;
        this.poDefn = poDefnIn;
        this.subfields = new Hashtable();
    }

    protected void setHeaderOffset(int headerOffsetIn) {
        this.headerOffset = headerOffsetIn;
    }

    public int getHeaderOffset() {
        return this.headerOffset;
    }

    public byte[] getData() {
        return this.pachData;
    }

    public int getDataSize() {
        if (this.pachData != null) {
            return this.pachData.length;
        }
        return 0;
    }

    public DDFFieldDefinition getFieldDefn() {
        return this.poDefn;
    }

    public int getDataPosition() {
        return this.dataPosition;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("  DDFField:\n");
        buf.append("\tTag = " + this.poDefn.getName() + "\n");
        buf.append("\tDescription = " + this.poDefn.getDescription() + "\n");
        int size = this.getDataSize();
        buf.append("\tDataSize = " + size + "\n");
        if (this.pachData == null) {
            buf.append("\tHeader offset = " + this.headerOffset + "\n");
            buf.append("\tData position = " + this.dataPosition + "\n");
            buf.append("\tData length = " + this.dataLength + "\n");
            return buf.toString();
        }
        buf.append("\tData = ");
        for (int i = 0; i < Math.min(size, 40); ++i) {
            if (this.pachData[i] < 32 || this.pachData[i] > 126) {
                buf.append(" | " + (char)this.pachData[i]);
                continue;
            }
            buf.append(this.pachData[i]);
        }
        if (size > 40) {
            buf.append("...");
        }
        buf.append("\n");
        if (Debug.debugging("iso8211.raw")) {
            int iOffset = 0;
            MutableInt nBytesConsumed = new MutableInt(0);
            for (int nLoopCount = 0; nLoopCount < this.getRepeatCount(); ++nLoopCount) {
                if (nLoopCount > 8) {
                    buf.append("      ...\n");
                    break;
                }
                for (int i = 0; i < this.poDefn.getSubfieldCount(); ++i) {
                    byte[] subPachData = new byte[this.pachData.length - iOffset];
                    System.arraycopy(this.pachData, iOffset, subPachData, 0, subPachData.length);
                    buf.append(this.poDefn.getSubfieldDefn(i).dumpData(subPachData, subPachData.length));
                    this.poDefn.getSubfieldDefn(i).getDataLength(subPachData, subPachData.length, nBytesConsumed);
                    iOffset += nBytesConsumed.value;
                }
            }
        } else {
            buf.append("      Subfields:\n");
            Enumeration enumeration = this.subfields.keys();
            while (enumeration.hasMoreElements()) {
                Object obj = this.subfields.get(enumeration.nextElement());
                if (obj instanceof List) {
                    Iterator it = ((List)obj).iterator();
                    while (it.hasNext()) {
                        DDFSubfield ddfs = (DDFSubfield)it.next();
                        buf.append("        " + ddfs.toString() + "\n");
                    }
                    continue;
                }
                buf.append("        " + obj.toString() + "\n");
            }
        }
        return buf.toString();
    }

    public List getSubfields(String subfieldName) {
        Object obj = this.subfields.get(subfieldName);
        if (obj instanceof List) {
            return (List)obj;
        }
        if (obj != null) {
            LinkedList ll = new LinkedList();
            ll.add(obj);
            return ll;
        }
        return null;
    }

    public DDFSubfield getSubfield(String subfieldName) {
        Object obj = this.subfields.get(subfieldName);
        if (obj instanceof List) {
            List l = (List)obj;
            if (!l.isEmpty()) {
                return (DDFSubfield)l.get(0);
            }
            obj = null;
        }
        return (DDFSubfield)obj;
    }

    public byte[] getSubfieldData(DDFSubfieldDefinition poSFDefn, MutableInt pnMaxBytes, int iSubfieldIndex) {
        int iOffset = 0;
        if (poSFDefn == null) {
            return null;
        }
        if (iSubfieldIndex > 0 && this.poDefn.getFixedWidth() > 0) {
            iOffset = this.poDefn.getFixedWidth() * iSubfieldIndex;
            iSubfieldIndex = 0;
        }
        MutableInt nBytesConsumed = new MutableInt(0);
        while (iSubfieldIndex >= 0) {
            for (int iSF = 0; iSF < this.poDefn.getSubfieldCount(); ++iSF) {
                DDFSubfieldDefinition poThisSFDefn = this.poDefn.getSubfieldDefn(iSF);
                byte[] subPachData = new byte[this.pachData.length - iOffset];
                System.arraycopy(this.pachData, iOffset, subPachData, 0, subPachData.length);
                if (poThisSFDefn == poSFDefn && iSubfieldIndex == 0) {
                    if (pnMaxBytes != null) {
                        pnMaxBytes.value = this.pachData.length - iOffset;
                    }
                    return subPachData;
                }
                poThisSFDefn.getDataLength(subPachData, subPachData.length, nBytesConsumed);
                iOffset += nBytesConsumed.value;
            }
            --iSubfieldIndex;
        }
        return null;
    }

    public void buildSubfields() {
        byte[] pachFieldData = this.pachData;
        int nBytesRemaining = this.pachData.length;
        for (int iRepeat = 0; iRepeat < this.getRepeatCount(); ++iRepeat) {
            for (int iSF = 0; iSF < this.poDefn.getSubfieldCount(); ++iSF) {
                DDFSubfield ddfs = new DDFSubfield(this.poDefn.getSubfieldDefn(iSF), pachFieldData, nBytesRemaining);
                this.addSubfield(ddfs);
                int nBytesConsumed = ddfs.getByteSize();
                nBytesRemaining -= nBytesConsumed;
                byte[] tempData = new byte[pachFieldData.length - nBytesConsumed];
                System.arraycopy(pachFieldData, nBytesConsumed, tempData, 0, tempData.length);
                pachFieldData = tempData;
            }
        }
    }

    protected void addSubfield(DDFSubfield ddfs) {
        String sfName;
        Object sf;
        if (Debug.debugging("iso8211")) {
            Debug.output("DDFField(" + this.getFieldDefn().getName() + ").addSubfield(" + ddfs + ")");
        }
        if ((sf = this.subfields.get(sfName = ddfs.getDefn().getName().trim().intern())) == null) {
            this.subfields.put(sfName, ddfs);
        } else if (sf instanceof List) {
            ((List)sf).add(ddfs);
        } else {
            Vector<Object> subList = new Vector<Object>();
            subList.add(sf);
            subList.add(ddfs);
            this.subfields.put(sfName, subList);
        }
    }

    public int getRepeatCount() {
        if (!this.poDefn.isRepeating()) {
            return 1;
        }
        if (this.poDefn.getFixedWidth() != 0) {
            return this.pachData.length / this.poDefn.getFixedWidth();
        }
        int iOffset = 0;
        int iRepeatCount = 1;
        MutableInt nBytesConsumed = new MutableInt(0);
        while (true) {
            for (int iSF = 0; iSF < this.poDefn.getSubfieldCount(); ++iSF) {
                DDFSubfieldDefinition poThisSFDefn = this.poDefn.getSubfieldDefn(iSF);
                if (poThisSFDefn.getWidth() > this.pachData.length - iOffset) {
                    nBytesConsumed.value = poThisSFDefn.getWidth();
                } else {
                    byte[] tempData = new byte[this.pachData.length - iOffset];
                    System.arraycopy(this.pachData, iOffset, tempData, 0, tempData.length);
                    poThisSFDefn.getDataLength(tempData, tempData.length, nBytesConsumed);
                }
                if ((iOffset += nBytesConsumed.value) <= this.pachData.length) continue;
                return iRepeatCount - 1;
            }
            if (iOffset > this.pachData.length - 2) {
                return iRepeatCount;
            }
            ++iRepeatCount;
        }
    }
}

