/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.image;

import com.bbn.openmap.dataAccess.image.ErrWorldFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorldFile {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.image.WorldFile");
    protected double xDim;
    protected double yDim;
    protected double rowRot;
    protected double colRot;
    protected double x;
    protected double y;

    protected WorldFile() {
    }

    public WorldFile(URL fileURL) throws MalformedURLException, IOException {
        this.read(fileURL.openStream());
    }

    public WorldFile(InputStream is) throws MalformedURLException, IOException {
        this.read(is);
    }

    public void read(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        this.xDim = Double.parseDouble(br.readLine());
        this.rowRot = Double.parseDouble(br.readLine());
        this.colRot = Double.parseDouble(br.readLine());
        this.yDim = Double.parseDouble(br.readLine());
        this.x = Double.parseDouble(br.readLine());
        this.y = Double.parseDouble(br.readLine());
        logger.info(this.toString());
    }

    public String toString() {
        return "WorldFile[x(" + this.x + "), y(" + this.y + "), xDim(" + this.xDim + "), yDim(" + this.yDim + "), colRot(" + this.colRot + "), rowRot(" + this.rowRot + ")]";
    }

    public static WorldFile get(URL imageFileURL) {
        WorldFile wf = null;
        try {
            String startingString = imageFileURL.toString();
            int extensionIndex = startingString.lastIndexOf(46);
            String worldFileNameBase = startingString;
            String extension = null;
            InputStream is = null;
            if (extensionIndex != -1) {
                extension = startingString.substring(extensionIndex);
                worldFileNameBase = startingString.substring(0, extensionIndex);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("base name for image: " + worldFileNameBase);
                    logger.fine("image extension: " + extension);
                }
                if ((is = WorldFile.checkValidityAndGetStream(worldFileNameBase + extension + "w")) == null && extension.length() >= 4) {
                    is = WorldFile.checkValidityAndGetStream(worldFileNameBase + "." + extension.charAt(1) + extension.charAt(3) + "w");
                }
            }
            if (is == null) {
                extension = ".wld";
                is = WorldFile.checkValidityAndGetStream(worldFileNameBase + extension);
            }
            if (is != null) {
                wf = new WorldFile(is);
                double x = wf.getX();
                double y = wf.getY();
                if (x < -180.0 || x > 180.0 || y > 90.0 || y < -90.0) {
                    logger.warning("Looks like an unsupported projection: " + wf.toString());
                    wf = new ErrWorldFile("World File (" + worldFileNameBase + extension + ") doesn't contain decimal degree coordinates");
                }
            }
        }
        catch (MalformedURLException murle) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return wf;
    }

    protected static InputStream checkValidityAndGetStream(String wfURLString) {
        try {
            logger.fine("checking for world file: " + wfURLString);
            URL wfURL = new URL(wfURLString);
            return wfURL.openStream();
        }
        catch (MalformedURLException murle) {
            logger.warning("MalformedURLException for " + wfURLString);
        }
        catch (IOException ioe) {
            logger.warning("IOException for " + wfURLString);
        }
        return null;
    }

    public double getColRot() {
        return this.colRot;
    }

    public void setColRot(double colRot) {
        this.colRot = colRot;
    }

    public double getRowRot() {
        return this.rowRot;
    }

    public void setRowRot(double rowRot) {
        this.rowRot = rowRot;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getXDim() {
        return this.xDim;
    }

    public void setXDim(double dim) {
        this.xDim = dim;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getYDim() {
        return this.yDim;
    }

    public void setYDim(double dim) {
        this.yDim = dim;
    }
}

