/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.dted;

import com.bbn.openmap.dataAccess.dted.DTEDFrameUtil;
import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.util.Debug;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DTEDFrameDSI {
    public char sec_code;
    public String sec_rel;
    public String sec_handling;
    public String sec_res;
    public String series;
    public String ser_ref_num;
    public String ser_res;
    public int data_ed;
    public char merge_version;
    public String maint_date;
    public String merge_date;
    public String maint_desc;
    public String prod_code;
    public String prod_res;
    public String spec;
    public int spec_amen;
    public String product_date;
    public String vert_datum;
    public String horiz_datum;
    public String dc_system;
    public String compilation_date;
    public String date_res;
    public float lat_origin;
    public float lon_origin;
    public float sw_lat;
    public float sw_lon;
    public float nw_lat;
    public float nw_lon;
    public float ne_lat;
    public float ne_lon;
    public float se_lat;
    public float se_lon;
    public float orient_ang;
    public int lat_post_interval;
    public int lon_post_interval;
    public int num_lat_lines;
    public int num_lon_points;
    public int part_cell;

    public DTEDFrameDSI(BinaryFile binFile) {
        try {
            String test;
            binFile.seek(80L);
            binFile.skipBytes(3L);
            this.sec_code = binFile.readChar();
            this.sec_rel = binFile.readFixedLengthString(2);
            this.sec_handling = binFile.readFixedLengthString(27);
            this.sec_res = binFile.readFixedLengthString(26);
            this.series = binFile.readFixedLengthString(5);
            this.ser_ref_num = binFile.readFixedLengthString(15);
            this.ser_res = binFile.readFixedLengthString(8);
            try {
                test = binFile.readFixedLengthString(2);
                this.data_ed = Integer.parseInt(test, 10);
            }
            catch (NumberFormatException nfe) {
                Debug.message("dted", "DTEDFrameDSI: Data Edition number bad, using 0");
                this.data_ed = 0;
            }
            this.merge_version = binFile.readChar();
            this.maint_date = binFile.readFixedLengthString(4);
            this.merge_date = binFile.readFixedLengthString(4);
            this.maint_desc = binFile.readFixedLengthString(4);
            this.prod_code = binFile.readFixedLengthString(8);
            this.prod_res = binFile.readFixedLengthString(16);
            this.spec = binFile.readFixedLengthString(9);
            try {
                test = binFile.readFixedLengthString(2);
                this.spec_amen = Integer.parseInt(test, 10);
            }
            catch (NumberFormatException nfe) {
                Debug.message("dted", "DTEDFrameDSI: Spec Amendment number bad, using 0");
                this.spec_amen = 0;
            }
            this.product_date = binFile.readFixedLengthString(4);
            this.vert_datum = binFile.readFixedLengthString(3);
            this.horiz_datum = binFile.readFixedLengthString(5);
            this.dc_system = binFile.readFixedLengthString(10);
            this.compilation_date = binFile.readFixedLengthString(4);
            this.date_res = binFile.readFixedLengthString(22);
            this.lat_origin = DTEDFrameUtil.stringToLat(binFile.readFixedLengthString(9));
            this.lon_origin = DTEDFrameUtil.stringToLon(binFile.readFixedLengthString(10));
            this.sw_lat = DTEDFrameUtil.stringToLat(binFile.readFixedLengthString(7));
            this.sw_lon = DTEDFrameUtil.stringToLon(binFile.readFixedLengthString(8));
            this.nw_lat = DTEDFrameUtil.stringToLat(binFile.readFixedLengthString(7));
            this.nw_lon = DTEDFrameUtil.stringToLon(binFile.readFixedLengthString(8));
            this.ne_lat = DTEDFrameUtil.stringToLat(binFile.readFixedLengthString(7));
            this.ne_lon = DTEDFrameUtil.stringToLon(binFile.readFixedLengthString(8));
            this.se_lat = DTEDFrameUtil.stringToLat(binFile.readFixedLengthString(7));
            this.se_lon = DTEDFrameUtil.stringToLon(binFile.readFixedLengthString(8));
            try {
                test = binFile.readFixedLengthString(9);
                this.orient_ang = Float.valueOf(test).floatValue();
            }
            catch (NumberFormatException nfe) {
                Debug.message("dted", "DTEDFrameDSI: orient angle number bad, using 0");
                this.orient_ang = 0.0f;
            }
            this.lat_post_interval = Integer.parseInt(binFile.readFixedLengthString(4), 10);
            this.lon_post_interval = Integer.parseInt(binFile.readFixedLengthString(4), 10);
            this.num_lat_lines = Integer.parseInt(binFile.readFixedLengthString(4), 10);
            this.num_lon_points = Integer.parseInt(binFile.readFixedLengthString(4), 10);
            try {
                test = binFile.readFixedLengthString(2);
                this.part_cell = Integer.parseInt(test, 10);
            }
            catch (NumberFormatException nfe) {
                Debug.message("dted", "DTEDFrameDSI: partial cell number bad, using 0");
                this.part_cell = 0;
            }
        }
        catch (IOException e) {
            Debug.error("DTEDFrameDSI: File IO Error!\n" + e.toString());
        }
        catch (FormatException f) {
            Debug.error("DTEDFrameDSI: File IO Format error!\n" + f.toString());
        }
        catch (NumberFormatException nfe) {
            Debug.error("DTEDFrameDSI: Number format error!\n" + nfe.toString());
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("***DSI***\n");
        s.append("  sec_code: " + this.sec_code);
        s.append("  sec_rel: " + this.sec_rel + "\n");
        s.append("  sec_handling: " + this.sec_handling + "\n");
        s.append("  sec_res: " + this.sec_res + "\n");
        s.append("  series: " + this.series + "\n");
        s.append("  ser_ref_num: " + this.ser_ref_num + "\n");
        s.append("  ser_res: " + this.ser_res + "\n");
        s.append("  data_ed: " + this.data_ed + "\n");
        s.append("  merge_version: " + this.merge_version + "\n");
        s.append("  maint_date: " + this.maint_date + "\n");
        s.append("  merge_date: " + this.merge_date + "\n");
        s.append("  maint_desc: " + this.maint_desc + "\n");
        s.append("  prod_code: " + this.prod_code + "\n");
        s.append("  prod_res: " + this.prod_res + "\n");
        s.append("  spec: " + this.spec + "\n");
        s.append("  spec_amen: " + this.spec_amen + "\n");
        s.append("  product_date: " + this.product_date + "\n");
        s.append("  vert_datum: " + this.vert_datum + "\n");
        s.append("  horiz_datum: " + this.horiz_datum + "\n");
        s.append("  dc_system: " + this.dc_system + "\n");
        s.append("  compilation_date: " + this.compilation_date + "\n");
        s.append("  date_res: " + this.date_res + "\n");
        s.append("  lat_origin: " + this.lat_origin + "\n");
        s.append("  lon_origin: " + this.lon_origin + "\n");
        s.append("  sw_lat: " + this.sw_lat + "\n");
        s.append("  sw_lon: " + this.sw_lon + "\n");
        s.append("  nw_lat: " + this.nw_lat + "\n");
        s.append("  nw_lon: " + this.nw_lon + "\n");
        s.append("  ne_lat: " + this.ne_lat + "\n");
        s.append("  ne_lon: " + this.ne_lon + "\n");
        s.append("  se_lat: " + this.se_lat + "\n");
        s.append("  se_lon: " + this.se_lon + "\n");
        s.append("  orient_ang: " + this.orient_ang + "\n");
        s.append("  lat_post_interval: " + this.lat_post_interval + "\n");
        s.append("  lon_post_interval: " + this.lon_post_interval + "\n");
        s.append("  num_lat_lines: " + this.num_lat_lines + "\n");
        s.append("  num_lon_points: " + this.num_lon_points + "\n");
        s.append("  part_cell: " + this.part_cell + "\n");
        return s.toString();
    }

    public static void main(String[] args) {
        Debug.init();
        if (args.length < 1) {
            Debug.output("dtedframe_dsi:  Need a path/filename");
            System.exit(0);
        }
        Debug.output("DTEDFrameDSI: using frame " + args[0]);
        File file = new File(args[0]);
        try {
            BinaryBufferedFile binFile = new BinaryBufferedFile(file);
            DTEDFrameDSI dfd = new DTEDFrameDSI(binFile);
            Debug.output(dfd.toString());
        }
        catch (FileNotFoundException e) {
            Debug.error("DTEDFrameDSI: file " + args[0] + " not found");
            System.exit(-1);
        }
        catch (IOException e) {
            Debug.error("DTEDFrameDSI: File IO Error!\n" + e.toString());
        }
    }
}

