/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.fonts.base14.Symbol;
import org.apache.fop.fonts.base14.ZapfDingbats;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFICCBasedColorSpace;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.util.ColorProfileUtil;

public class PDFResources
extends PDFObject {
    protected Map fonts = new HashMap();
    protected Set xObjects = new HashSet();
    protected Set patterns = new HashSet();
    protected Set shadings = new HashSet();
    protected Set gstates = new HashSet();
    protected Map colorSpaces = new HashMap();
    protected Map iccColorSpaces = new HashMap();

    public PDFResources(int objnum) {
        this.setObjectNumber(objnum);
    }

    public void addFont(PDFFont font) {
        this.fonts.put(font.getName(), font);
    }

    public void addFonts(PDFDocument doc, FontInfo fontInfo) {
        Map usedFonts = fontInfo.getUsedFonts();
        Iterator e = usedFonts.keySet().iterator();
        while (e.hasNext()) {
            String f = (String)e.next();
            Typeface font = (Typeface)usedFonts.get(f);
            if (!font.hadMappingOperations()) continue;
            FontDescriptor desc = null;
            if (font instanceof FontDescriptor) {
                desc = (FontDescriptor)((Object)font);
            }
            String encoding = font.getEncoding();
            if (font instanceof Symbol || font instanceof ZapfDingbats) {
                encoding = null;
            }
            this.addFont(doc.getFactory().makeFont(f, font.getEmbedFontName(), encoding, font, desc));
        }
    }

    public void addGState(PDFGState gs) {
        this.gstates.add(gs);
    }

    public void addShading(PDFShading theShading) {
        this.shadings.add(theShading);
    }

    public void addPattern(PDFPattern thePattern) {
        this.patterns.add(thePattern);
    }

    public void addXObject(PDFXObject xObject) {
        this.xObjects.add(xObject);
    }

    public void addColorSpace(PDFICCBasedColorSpace colorSpace) {
        this.colorSpaces.put(colorSpace.getName(), colorSpace);
        String desc = ColorProfileUtil.getICCProfileDescription(colorSpace.getICCStream().getICCProfile());
        this.iccColorSpaces.put(desc, colorSpace);
    }

    public PDFICCBasedColorSpace getICCColorSpaceByProfileName(String desc) {
        PDFICCBasedColorSpace cs = (PDFICCBasedColorSpace)this.iccColorSpaces.get(desc);
        return cs;
    }

    public PDFICCBasedColorSpace getColorSpace(String name) {
        PDFICCBasedColorSpace cs = (PDFICCBasedColorSpace)this.colorSpaces.get(name);
        return cs;
    }

    public String toPDFString() {
        Iterator<Object> iter;
        StringBuffer p = new StringBuffer(128);
        p.append(this.getObjectID() + "<<\n");
        if (!this.fonts.isEmpty()) {
            p.append("/Font <<\n");
            Iterator fontIterator = this.fonts.keySet().iterator();
            while (fontIterator.hasNext()) {
                String fontName = (String)fontIterator.next();
                p.append("  /" + fontName + " " + ((PDFFont)this.fonts.get(fontName)).referencePDF() + "\n");
            }
            p.append(">>\n");
        }
        PDFShading currentShading = null;
        if (!this.shadings.isEmpty()) {
            p.append("/Shading <<\n");
            Iterator iter2 = this.shadings.iterator();
            while (iter2.hasNext()) {
                currentShading = (PDFShading)iter2.next();
                p.append("  /" + currentShading.getName() + " " + currentShading.referencePDF() + " ");
            }
            p.append(">>\n");
        }
        currentShading = null;
        PDFPattern currentPattern = null;
        if (!this.patterns.isEmpty()) {
            p.append("/Pattern <<\n");
            iter = this.patterns.iterator();
            while (iter.hasNext()) {
                currentPattern = (PDFPattern)iter.next();
                p.append("  /" + currentPattern.getName() + " " + currentPattern.referencePDF() + " ");
            }
            p.append(">>\n");
        }
        currentPattern = null;
        p.append("/ProcSet [ /PDF /ImageB /ImageC /Text ]\n");
        if (this.xObjects != null && !this.xObjects.isEmpty()) {
            p = p.append("/XObject <<\n");
            iter = this.xObjects.iterator();
            while (iter.hasNext()) {
                PDFXObject xobj = (PDFXObject)iter.next();
                p = p.append("  " + xobj.getName() + " " + xobj.referencePDF() + "\n");
            }
            p = p.append(">>\n");
        }
        if (!this.gstates.isEmpty()) {
            p = p.append("/ExtGState <<\n");
            iter = this.gstates.iterator();
            while (iter.hasNext()) {
                PDFGState gs = (PDFGState)iter.next();
                p = p.append("  /" + gs.getName() + " " + gs.referencePDF() + "\n");
            }
            p = p.append(">>\n");
        }
        if (!this.colorSpaces.isEmpty()) {
            p = p.append("/ColorSpace <<\n");
            iter = this.colorSpaces.values().iterator();
            while (iter.hasNext()) {
                PDFICCBasedColorSpace colorSpace = (PDFICCBasedColorSpace)iter.next();
                p = p.append("  /" + colorSpace.getName() + " " + colorSpace.referencePDF() + "\n");
            }
            p = p.append(">>\n");
        }
        p = p.append(">>\nendobj\n");
        return p.toString();
    }
}

