/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area.inline;

import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineParent;

public abstract class AbstractTextArea
extends InlineParent {
    private int textWordSpaceAdjust = 0;
    private int textLetterSpaceAdjust = 0;
    private TextAdjustingInfo textAdjustingInfo = null;
    private int baselineOffset = 0;

    public AbstractTextArea() {
    }

    public AbstractTextArea(int stretch, int shrink, int adj) {
        this.textAdjustingInfo = new TextAdjustingInfo(stretch, shrink, adj);
    }

    public int getTextWordSpaceAdjust() {
        return this.textWordSpaceAdjust;
    }

    public void setTextWordSpaceAdjust(int textWordSpaceAdjust) {
        this.textWordSpaceAdjust = textWordSpaceAdjust;
    }

    public int getTextLetterSpaceAdjust() {
        return this.textLetterSpaceAdjust;
    }

    public void setTextLetterSpaceAdjust(int textLetterSpaceAdjust) {
        this.textLetterSpaceAdjust = textLetterSpaceAdjust;
    }

    public void setSpaceDifference(int spaceDiff) {
        this.textAdjustingInfo.spaceDifference = spaceDiff;
    }

    public boolean applyVariationFactor(double variationFactor, int lineStretch, int lineShrink) {
        if (this.textAdjustingInfo != null) {
            double balancingFactor = 1.0;
            if (variationFactor < 0.0) {
                balancingFactor = this.textWordSpaceAdjust < 0 ? (double)this.textAdjustingInfo.availableStretch / (double)this.textAdjustingInfo.availableShrink * ((double)lineShrink / (double)lineStretch) : (double)this.textAdjustingInfo.availableShrink / (double)this.textAdjustingInfo.availableStretch * ((double)lineStretch / (double)lineShrink);
            }
            this.textWordSpaceAdjust = (int)((double)(this.textWordSpaceAdjust - this.textAdjustingInfo.spaceDifference) * variationFactor * balancingFactor) + this.textAdjustingInfo.spaceDifference;
            this.textLetterSpaceAdjust = (int)((double)this.textLetterSpaceAdjust * variationFactor);
            int oldAdjustment = this.textAdjustingInfo.adjustment;
            this.textAdjustingInfo.adjustment = (int)((double)this.textAdjustingInfo.adjustment * (balancingFactor * variationFactor));
            this.ipd += this.textAdjustingInfo.adjustment - oldAdjustment;
        }
        return false;
    }

    public int getBaselineOffset() {
        return this.baselineOffset;
    }

    public void setBaselineOffset(int baselineOffset) {
        this.baselineOffset = baselineOffset;
    }

    protected class TextAdjustingInfo
    extends InlineArea.InlineAdjustingInfo {
        protected int spaceDifference;

        protected TextAdjustingInfo(int stretch, int shrink, int adj) {
            super(AbstractTextArea.this, stretch, shrink, adj);
            this.spaceDifference = 0;
        }
    }
}

