/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.fits;

import java.util.List;
import ncsa.hdf.object.Datatype;

public class FitsDatatype
extends Datatype {
    private static final long serialVersionUID = 6545936196104493765L;
    private int nativeType;

    public FitsDatatype(int tclass, int tsize, int torder, int tsign) {
        super(tclass, tsize, torder, tsign);
    }

    public FitsDatatype(int theType) {
        super(-1);
        this.nativeType = theType;
        this.fromNative(0);
    }

    @Override
    public boolean hasAttribute() {
        return false;
    }

    public static Object allocateArray(int dtype, int size) throws OutOfMemoryError {
        Object[] data = null;
        if (size <= 0) {
            return null;
        }
        switch (dtype) {
            case 8: {
                data = new byte[size];
                break;
            }
            case 16: {
                data = new short[size];
                break;
            }
            case 32: {
                data = new int[size];
                break;
            }
            case 64: {
                data = new long[size];
                break;
            }
            case -32: {
                data = new float[size];
                break;
            }
            case -64: {
                data = new double[size];
            }
        }
        return data;
    }

    public void fromNative() {
        this.fromNative(this.nativeType);
    }

    @Override
    public void fromNative(int dtype) {
        switch (dtype) {
            case 8: {
                this.datatypeClass = 0;
                this.datatypeSize = 1;
                break;
            }
            case 16: {
                this.datatypeClass = 0;
                this.datatypeSize = 2;
                break;
            }
            case 32: {
                this.datatypeClass = 0;
                this.datatypeSize = 4;
                break;
            }
            case 64: {
                this.datatypeClass = 0;
                this.datatypeSize = 8;
                break;
            }
            case -32: {
                this.datatypeClass = 1;
                this.datatypeSize = 4;
                break;
            }
            case -64: {
                this.datatypeClass = 1;
                this.datatypeSize = 8;
            }
        }
    }

    @Override
    public String getDatatypeDescription() {
        String description = "Unknown data type.";
        switch (this.nativeType) {
            case 8: {
                description = "8-bit integer";
                break;
            }
            case 16: {
                description = "16-bit integer";
                break;
            }
            case 32: {
                description = "32-bit integer";
                break;
            }
            case 64: {
                description = "64-bit integer";
                break;
            }
            case -32: {
                description = "32-bit float";
                break;
            }
            case -64: {
                description = "64-bit float";
                break;
            }
            default: {
                if (this.datatypeClass == 3) {
                    description = "String";
                    break;
                }
                if (this.datatypeClass == 2) {
                    description = "Char";
                    break;
                }
                if (this.datatypeClass == 0) {
                    description = "Integer";
                    break;
                }
                if (this.datatypeClass != 1) break;
                description = "Float";
            }
        }
        return description;
    }

    @Override
    public boolean isUnsigned() {
        return false;
    }

    @Override
    public int toNative() {
        if (this.datatypeClass == 0) {
            if (this.datatypeSize == 1) {
                this.nativeType = 8;
            } else if (this.datatypeSize == 2) {
                this.nativeType = 16;
            } else if (this.datatypeSize == 4) {
                this.nativeType = 32;
            } else if (this.datatypeSize == 8) {
                this.nativeType = 64;
            }
        } else if (this.datatypeClass == 1) {
            if (this.datatypeSize == 4) {
                this.nativeType = -32;
            } else if (this.datatypeSize == 8) {
                this.nativeType = -64;
            }
        }
        return this.nativeType;
    }

    @Override
    public void close(int id) {
    }

    public List getMetadata(int ... attrPropList) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

