/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;

public class TemporalConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class source, Class target, Hints hints) {
        if (Date.class.isAssignableFrom(source)) {
            if (Calendar.class.isAssignableFrom(target)) {
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime((Date)source);
                        return calendar;
                    }
                };
            }
            if (Timestamp.class.isAssignableFrom(target) || Time.class.isAssignableFrom(target) || java.sql.Date.class.isAssignableFrom(target)) {
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        Date date = (Date)source;
                        return target.getConstructor(Long.TYPE).newInstance(new Long(date.getTime()));
                    }
                };
            }
        }
        if (Calendar.class.isAssignableFrom(source)) {
            if (Date.class.isAssignableFrom(target)) {
                Class fTarget = target;
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        Calendar calendar = (Calendar)source;
                        return target.getConstructor(Long.TYPE).newInstance(new Long(calendar.getTimeInMillis()));
                    }
                };
            }
            if (XMLGregorianCalendar.class.isAssignableFrom(target)) {
                return new Converter(){

                    @Override
                    public <T> T convert(Object source, Class<T> target) throws Exception {
                        if (source instanceof GregorianCalendar) {
                            return (T)DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar)source);
                        }
                        return null;
                    }
                };
            }
        }
        if (XMLGregorianCalendar.class.isAssignableFrom(source) && Calendar.class.isAssignableFrom(target)) {
            return new Converter(){

                @Override
                public <T> T convert(Object source, Class<T> target) throws Exception {
                    XMLGregorianCalendar calendar = (XMLGregorianCalendar)source;
                    return (T)calendar.toGregorianCalendar();
                }
            };
        }
        return null;
    }
}

