/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.geotools.data.TransactionStateDiff;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.BoundingBox;

public class Diff {
    private final Map modifiedFeatures;
    private final Map addedFeatures;
    public final Map modified2;
    public final Map added;
    public int nextFID = 0;
    private SpatialIndex spatialIndex;
    Object mutex;

    public Diff() {
        this.modifiedFeatures = new ConcurrentHashMap();
        this.addedFeatures = new ConcurrentHashMap();
        this.modified2 = Collections.unmodifiableMap(this.modifiedFeatures);
        this.added = Collections.unmodifiableMap(this.addedFeatures);
        this.spatialIndex = new Quadtree();
        this.mutex = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.modifiedFeatures.isEmpty() && this.addedFeatures.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            this.nextFID = 0;
            this.addedFeatures.clear();
            this.modifiedFeatures.clear();
            this.spatialIndex = new Quadtree();
        }
    }

    public Diff(Diff other) {
        this.modifiedFeatures = Collections.synchronizedMap(new HashMap(other.modifiedFeatures));
        this.addedFeatures = Collections.synchronizedMap(new HashMap(other.addedFeatures));
        this.modified2 = Collections.unmodifiableMap(this.modifiedFeatures);
        this.added = Collections.unmodifiableMap(this.addedFeatures);
        this.spatialIndex = this.copySTRtreeFrom(other);
        this.nextFID = other.nextFID;
        this.mutex = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(String fid, SimpleFeature f) {
        Object object = this.mutex;
        synchronized (object) {
            SimpleFeature old;
            if (this.addedFeatures.containsKey(fid)) {
                old = (SimpleFeature)this.addedFeatures.get(fid);
                this.addedFeatures.put(fid, f);
            } else {
                old = (SimpleFeature)this.modifiedFeatures.get(fid);
                this.modifiedFeatures.put(fid, f);
            }
            if (old != null) {
                this.spatialIndex.remove(ReferencedEnvelope.reference(old.getBounds()), old);
            }
            this.addToSpatialIndex(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String fid, SimpleFeature f) {
        Object object = this.mutex;
        synchronized (object) {
            this.addedFeatures.put(fid, f);
            this.addToSpatialIndex(f);
        }
    }

    protected void addToSpatialIndex(SimpleFeature f) {
        BoundingBox bounds;
        if (f.getDefaultGeometry() != null && !(bounds = f.getBounds()).isEmpty()) {
            this.spatialIndex.insert(ReferencedEnvelope.reference(bounds), f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String fid) {
        Object object = this.mutex;
        synchronized (object) {
            SimpleFeature old = null;
            if (this.addedFeatures.containsKey(fid)) {
                old = (SimpleFeature)this.addedFeatures.get(fid);
                this.addedFeatures.remove(fid);
            } else {
                old = (SimpleFeature)this.modifiedFeatures.get(fid);
                this.modifiedFeatures.put(fid, TransactionStateDiff.NULL);
            }
            if (old != null) {
                this.spatialIndex.remove(ReferencedEnvelope.reference(old.getBounds()), old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List queryIndex(Envelope env) {
        Object object = this.mutex;
        synchronized (object) {
            return this.spatialIndex.query(env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Quadtree copySTRtreeFrom(Diff diff) {
        Quadtree tree = new Quadtree();
        Diff diff2 = diff;
        synchronized (diff2) {
            for (Map.Entry e : diff.added.entrySet()) {
                SimpleFeature f = (SimpleFeature)e.getValue();
                if (diff.modifiedFeatures.containsKey(f.getID())) continue;
                tree.insert(ReferencedEnvelope.reference(f.getBounds()), f);
            }
            for (Map.Entry e : diff.modified2.entrySet()) {
                SimpleFeature f = (SimpleFeature)e.getValue();
                tree.insert(ReferencedEnvelope.reference(f.getBounds()), f);
            }
        }
        return tree;
    }
}

