/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdflib;

import java.io.File;
import java.io.Serializable;
import ncsa.hdf.hdflib.HDFArray;
import ncsa.hdf.hdflib.HDFChunkInfo;
import ncsa.hdf.hdflib.HDFCompInfo;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFJavaException;
import ncsa.hdf.hdflib.HDFNativeData;

public class HDFLibrary
implements Serializable {
    private static final long serialVersionUID = -1695429510319126910L;
    public static final String HDFPATH_PROPERTY_KEY = "ncsa.hdf.hdflib.HDFLibrary.hdflib";
    private static final String JHI_VERSION = "2.6";
    private static boolean isLibraryLoaded = false;

    public static void loadH4Lib() {
        if (isLibraryLoaded) {
            return;
        }
        String filename = System.getProperty(HDFPATH_PROPERTY_KEY, null);
        if (filename != null && filename.length() > 0) {
            File h5dll = new File(filename);
            if (h5dll.exists() && h5dll.canRead() && h5dll.isFile()) {
                try {
                    System.load(filename);
                    isLibraryLoaded = true;
                }
                catch (Throwable err) {
                    isLibraryLoaded = false;
                }
            } else {
                isLibraryLoaded = false;
                throw new UnsatisfiedLinkError("Invalid HDF4 library, " + filename);
            }
        }
        if (!isLibraryLoaded) {
            try {
                System.loadLibrary("jhdf");
                isLibraryLoaded = true;
            }
            catch (Throwable err) {
                isLibraryLoaded = false;
            }
        }
        try {
            HDFLibrary.HDdont_atexit();
        }
        catch (HDFException e) {
            System.exit(1);
        }
    }

    public static final String getJHIVersion() {
        return JHI_VERSION;
    }

    public static int Hopen(String filename) throws HDFException {
        return HDFLibrary.Hopen(filename, 1);
    }

    public static native int Hopen(String var0, int var1) throws HDFException;

    public static native boolean Hclose(int var0) throws HDFException;

    public static native int HDdont_atexit() throws HDFException;

    public static native boolean Hishdf(String var0) throws HDFException;

    public static native int Hnumber(int var0) throws HDFException;

    public static native int DFKNTsize(int var0) throws HDFException;

    public static native String HDgetNTdesc(int var0) throws HDFException;

    public static native boolean Hcache(int var0, int var1) throws HDFException;

    public static native boolean Hgetfileversion(int var0, int[] var1, String[] var2) throws HDFException;

    public static native boolean Hgetlibversion(int[] var0, String[] var1) throws HDFException;

    public static native boolean Hsetaccesstype(int var0, int var1) throws HDFException;

    public static native boolean Hsync(int var0) throws HDFException;

    public static native int ANstart(int var0) throws HDFException;

    public static native boolean ANend(int var0) throws HDFException;

    public static native boolean ANendaccess(int var0) throws HDFException;

    public static native boolean ANfileinfo(int var0, int[] var1) throws HDFException;

    public static native int ANselect(int var0, int var1, int var2) throws HDFException;

    public static native int ANnumann(int var0, int var1, short var2, short var3) throws HDFException;

    public static native short ANatype2tag(int var0) throws HDFException;

    public static native int ANtag2atype(short var0) throws HDFException;

    public static native int ANannlist(int var0, int var1, int var2, int var3, int[] var4) throws HDFException;

    public static native int ANannlen(int var0) throws HDFException;

    public static native boolean ANreadann(int var0, String[] var1, int var2) throws HDFException;

    public static native int ANcreate(int var0, short var1, short var2, int var3) throws HDFException;

    public static native int ANcreatef(int var0, int var1) throws HDFException;

    public static native int ANget_tagref(int var0, int var1, int var2, short[] var3) throws HDFException;

    public static native boolean ANid2tagref(int var0, short[] var1) throws HDFException;

    public static native int ANtagref2id(int var0, short var1, short var2) throws HDFException;

    public static native boolean ANwriteann(int var0, String var1, int var2) throws HDFException;

    public static native boolean DFPaddpal(String var0, byte[] var1) throws HDFException;

    public static native boolean DFPgetpal(String var0, byte[] var1) throws HDFException;

    public static native short DFPlastref() throws HDFException;

    public static native int DFPnpals(String var0) throws HDFException;

    public static native boolean DFPputpal(String var0, byte[] var1, int var2, String var3) throws HDFException;

    public static boolean DFPputpal(String filename, byte[] palette, boolean overwrite, String filemode) throws HDFException {
        if (overwrite) {
            return HDFLibrary.DFPputpal(filename, palette, 1, filemode);
        }
        return HDFLibrary.DFPputpal(filename, palette, 0, filemode);
    }

    public static native boolean DFPreadref(String var0, short var1) throws HDFException;

    public static native short DFPrestart() throws HDFException;

    public static native boolean DFPwriteref(String var0, short var1) throws HDFException;

    public static native int GRstart(int var0) throws HDFException;

    public static native boolean GRend(int var0) throws HDFException;

    public static native boolean GRfileinfo(int var0, int[] var1) throws HDFException;

    public static native boolean GRgetchunkinfo(int var0, HDFChunkInfo var1, int[] var2) throws HDFException;

    public static native int GRselect(int var0, int var1) throws HDFException;

    public static native int GRnametoindex(int var0, String var1) throws HDFException;

    public static native boolean GRgetiminfo(int var0, String[] var1, int[] var2, int[] var3) throws HDFException;

    public static native boolean GRreadimage(int var0, int[] var1, int[] var2, int[] var3, byte[] var4) throws HDFException;

    public static boolean GRreadimage(int grid, int[] start, int[] stride, int[] count, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.emptyBytes();
        boolean rval = HDFLibrary.GRreadimage(grid, start, stride, count, data);
        theData = theArray.arrayify(data);
        return rval;
    }

    public static native boolean GRendaccess(int var0) throws HDFException;

    public static native short GRidtoref(int var0) throws HDFException;

    public static native int GRreftoindex(int var0, short var1) throws HDFException;

    public static native boolean GRreqlutil(int var0, int var1) throws HDFException;

    public static native boolean GRreqimageil(int var0, int var1) throws HDFException;

    public static native int GRgetlutid(int var0, int var1) throws HDFException;

    public static native int GRgetnluts(int var0) throws HDFException;

    public static native boolean GRgetlutinfo(int var0, int[] var1) throws HDFException;

    public static native boolean GRreadlut(int var0, byte[] var1) throws HDFException;

    public static boolean GRreadlut(int lutid, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.emptyBytes();
        boolean rval = HDFLibrary.GRreadlut(lutid, data);
        theData = theArray.arrayify(data);
        return rval;
    }

    public static native boolean GRattrinfo(int var0, int var1, String[] var2, int[] var3) throws HDFException;

    public static native boolean GRgetattr(int var0, int var1, byte[] var2) throws HDFException;

    public static boolean GRgetattr(int id, int index, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.emptyBytes();
        boolean rval = HDFLibrary.GRgetattr(id, index, data);
        theData = theArray.arrayify(data);
        return rval;
    }

    public static native int GRfindattr(int var0, String var1) throws HDFException;

    public static native int GRcreate(int var0, String var1, int var2, int var3, int var4, int[] var5) throws HDFException;

    public static native short GRluttoref(int var0) throws HDFException;

    public static native boolean GRsetattr(int var0, String var1, int var2, int var3, String var4) throws HDFException;

    public static native boolean GRsetattr(int var0, String var1, int var2, int var3, byte[] var4) throws HDFException;

    public static boolean GRsetattr(int gr_id, String attr_name, int data_type, int count, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.byteify();
        return HDFLibrary.GRsetattr(gr_id, attr_name, data_type, count, data);
    }

    public static native boolean GRsetchunk(int var0, HDFChunkInfo var1, int var2) throws HDFException;

    public static native int GRsetchunkcache(int var0, int var1, int var2) throws HDFException;

    public static native boolean GRsetcompress(int var0, int var1, HDFCompInfo var2) throws HDFException;

    public static native boolean GRgetcompress(int var0, HDFCompInfo var1) throws HDFException;

    public static native boolean GRsetexternalfile(int var0, String var1, int var2) throws HDFException;

    public static native boolean GRwriteimage(int var0, int[] var1, int[] var2, int[] var3, byte[] var4) throws HDFException;

    public static boolean GRwriteimage(int grid, int[] start, int[] stride, int[] edge, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.byteify();
        return HDFLibrary.GRwriteimage(grid, start, stride, edge, data);
    }

    public static native boolean GRwritelut(int var0, int var1, int var2, int var3, int var4, byte[] var5) throws HDFException;

    public static boolean GRwritelut(int pal_id, int ncomp, int data_type, int interlace, int num_entries, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.byteify();
        return HDFLibrary.GRwritelut(pal_id, ncomp, data_type, interlace, num_entries, data);
    }

    public static native boolean GRreadchunk(int var0, int[] var1, byte[] var2) throws HDFException;

    public static boolean GRreadchunk(int grid, int[] origin, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.emptyBytes();
        boolean rval = HDFLibrary.GRreadchunk(grid, origin, data);
        theData = theArray.arrayify(data);
        return rval;
    }

    public static native boolean HDFclose(int var0) throws HDFException;

    public static native int HDFopen(String var0, int var1, short var2) throws HDFException;

    public static native short HEvalue(int var0) throws HDFException;

    public static native String HEstring(int var0) throws HDFException;

    public static native boolean HXsetcreatedir(String var0) throws HDFException;

    public static native boolean HXsetdir(String var0) throws HDFException;

    public static native int SDstart(String var0, int var1) throws HDFException;

    public static native boolean SDend(int var0) throws HDFException;

    public static native boolean SDfileinfo(int var0, int[] var1) throws HDFException;

    public static native int SDselect(int var0, int var1) throws HDFException;

    public static native int SDnametoindex(int var0, String var1) throws HDFException;

    public static native boolean SDgetinfo(int var0, String[] var1, int[] var2, int[] var3) throws HDFException;

    public static native boolean SDcheckempty(int var0, int[] var1) throws HDFException;

    public static native boolean SDreaddata(int var0, int[] var1, int[] var2, int[] var3, byte[] var4) throws HDFException;

    public static boolean SDreaddata(int sdsid, int[] start, int[] stride, int[] count, Object theData) throws HDFException {
        boolean status = false;
        boolean is1D = false;
        Class<?> dataClass = theData.getClass();
        if (!dataClass.isArray()) {
            throw new HDFJavaException("SDreaddata: data is not an array");
        }
        String cname = dataClass.getName();
        is1D = cname.lastIndexOf(91) == cname.indexOf(91);
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        if (is1D && dname == 'B') {
            status = HDFLibrary.SDreaddata(sdsid, start, stride, count, (byte[])theData);
        } else if (is1D && dname == 'S') {
            status = HDFLibrary.SDreaddata_short(sdsid, start, stride, count, (short[])theData);
        } else if (is1D && dname == 'I') {
            status = HDFLibrary.SDreaddata_int(sdsid, start, stride, count, (int[])theData);
        } else if (is1D && dname == 'J') {
            status = HDFLibrary.SDreaddata_long(sdsid, start, stride, count, (long[])theData);
        } else if (is1D && dname == 'F') {
            status = HDFLibrary.SDreaddata_float(sdsid, start, stride, count, (float[])theData);
        } else if (is1D && dname == 'D') {
            status = HDFLibrary.SDreaddata_double(sdsid, start, stride, count, (double[])theData);
        } else {
            HDFArray theArray = new HDFArray(theData);
            byte[] data = theArray.emptyBytes();
            status = HDFLibrary.SDreaddata(sdsid, start, stride, count, data);
            theData = theArray.arrayify(data);
        }
        return status;
    }

    public static native boolean SDendaccess(int var0) throws HDFException;

    public static native int SDgetdimid(int var0, int var1) throws HDFException;

    public static native boolean SDdiminfo(int var0, String[] var1, int[] var2) throws HDFException;

    public static native int SDidtoref(int var0) throws HDFException;

    public static native int SDreftoindex(int var0, int var1) throws HDFException;

    public static native boolean SDattrinfo(int var0, int var1, String[] var2, int[] var3) throws HDFException;

    public static native boolean SDreadattr(int var0, int var1, byte[] var2) throws HDFException;

    public static boolean SDreadattr(int id, int index, Object theData) throws HDFException {
        boolean rval;
        Class<?> theClass = theData.getClass();
        String name = theClass.getName();
        if (name.equals("java.lang.String")) {
            byte[] data = ((String)theData).getBytes();
            rval = HDFLibrary.SDreadattr(id, index, data);
            theData = new String(data);
        } else {
            HDFArray theArray = new HDFArray(theData);
            byte[] data = theArray.emptyBytes();
            rval = HDFLibrary.SDreadattr(id, index, data);
            theData = theArray.arrayify(data);
        }
        return rval;
    }

    public static native int SDfindattr(int var0, String var1) throws HDFException;

    public static native boolean SDiscoordvar(int var0) throws HDFException;

    public static native boolean SDgetcal(int var0, double[] var1, int[] var2) throws HDFException;

    public static native boolean SDgetdatastrs(int var0, String[] var1, int var2) throws HDFException;

    public static native boolean SDgetdimstrs(int var0, String[] var1, int var2) throws HDFException;

    public static native boolean SDgetdimscale(int var0, byte[] var1) throws HDFException;

    public static boolean SDgetdimscale(int dimid, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.emptyBytes();
        boolean rval = HDFLibrary.SDgetdimscale(dimid, data);
        theData = theArray.arrayify(data);
        return rval;
    }

    public static native boolean SDgetfillvalue(int var0, byte[] var1) throws HDFException;

    public static boolean SDgetfillvalue(int sdsid, Object[] theFillValue) throws HDFException {
        int[] SDInfo = new int[3];
        String datasetname = new String(" ");
        String[] ss = new String[]{datasetname};
        int[] dimsize = new int[16];
        HDFLibrary.SDgetinfo(sdsid, ss, dimsize, SDInfo);
        datasetname = ss[0];
        byte[] d1 = new byte[8];
        boolean rval = HDFLibrary.SDgetfillvalue(sdsid, d1);
        if (!rval) {
            return rval;
        }
        int NT = SDInfo[1];
        if ((NT & 0x4000) != 0) {
            NT -= 16384;
        }
        if (NT == 20 || NT == 4 || NT == 4) {
            theFillValue[0] = new Byte(d1[0]);
        } else if (NT == 21 || NT == 3 || NT == 3) {
            Byte f = new Byte(d1[0]);
            theFillValue[0] = f.shortValue() < 0 ? new Short((short)(f.intValue() + 256)) : new Short(f.shortValue());
        } else if (NT == 22 || NT == 42) {
            short[] fx = HDFNativeData.byteToShort(0, 1, d1);
            theFillValue[0] = new Short(fx[0]);
        } else if (NT == 23 || NT == 43) {
            short[] fmx = HDFNativeData.byteToShort(0, 1, d1);
            Short f = new Short(fmx[0]);
            theFillValue[0] = f.intValue() < 0 ? new Integer(f.intValue() + 65536) : new Integer(f.intValue());
        } else if (NT == 24) {
            int[] fx = HDFNativeData.byteToInt(0, 1, d1);
            theFillValue[0] = new Integer(fx[0]);
        } else if (NT == 25) {
            int[] fmx = HDFNativeData.byteToInt(0, 1, d1);
            Integer i = new Integer(fmx[0]);
            theFillValue[0] = i.floatValue() < 0.0f ? new Float((float)((double)i.floatValue() + 4.294967296E9)) : new Float(i.floatValue());
        } else if (NT == 5) {
            float[] fx = HDFNativeData.byteToFloat(0, 1, d1);
            theFillValue[0] = new Float(fx[0]);
        } else if (NT == 6) {
            double[] fx = HDFNativeData.byteToDouble(0, 1, d1);
            theFillValue[0] = new Double(fx[0]);
        } else {
            System.out.println("Error: SDgetfillvalue not converting, type " + NT);
        }
        return rval;
    }

    public static native boolean SDgetrange(int var0, byte[] var1, byte[] var2) throws HDFException;

    public static boolean SDgetrange(int sdsid, double[] maxmin) throws HDFException {
        int[] SDInfo = new int[3];
        String datasetname = new String(" ");
        String[] ss = new String[]{datasetname};
        int[] dimsize = new int[16];
        HDFLibrary.SDgetinfo(sdsid, ss, dimsize, SDInfo);
        datasetname = ss[0];
        byte[] max = new byte[8];
        byte[] min = new byte[8];
        boolean rval = HDFLibrary.SDgetrange(sdsid, max, min);
        if (!rval) {
            return rval;
        }
        int NT = SDInfo[1];
        if ((NT & 0x4000) != 0) {
            NT -= 16384;
        }
        if (NT == 20 || NT == 4 || NT == 4) {
            Byte f = new Byte(max[0]);
            maxmin[0] = f.doubleValue();
            f = new Byte(min[0]);
            maxmin[1] = f.doubleValue();
        } else if (NT == 21 || NT == 3 || NT == 3) {
            Byte f = new Byte(max[0]);
            Short fmx = f.shortValue() < 0 ? new Short((short)(f.intValue() + 256)) : new Short(f.shortValue());
            maxmin[0] = fmx.doubleValue();
            f = new Byte(min[0]);
            fmx = new Short(f.shortValue());
            maxmin[1] = fmx.doubleValue();
        } else if (NT == 22 || NT == 42) {
            short[] fmx = HDFNativeData.byteToShort(0, 1, max);
            short[] fmn = HDFNativeData.byteToShort(0, 1, min);
            Short f = new Short(fmx[0]);
            maxmin[0] = f.doubleValue();
            f = new Short(fmn[0]);
            maxmin[1] = f.doubleValue();
        } else if (NT == 23 || NT == 23) {
            short[] fmx = HDFNativeData.byteToShort(0, 1, max);
            Short f = new Short(fmx[0]);
            Integer i = f.intValue() < 0 ? new Integer(f.intValue() + 65536) : new Integer(f.intValue());
            maxmin[0] = i.doubleValue();
            fmx = HDFNativeData.byteToShort(0, 1, min);
            f = new Short(fmx[0]);
            i = f.intValue() < 0 ? new Integer(f.intValue() + 65536) : new Integer(f.intValue());
            maxmin[1] = i.doubleValue();
        } else if (NT == 24) {
            int[] fmx = HDFNativeData.byteToInt(0, 1, max);
            int[] fmn = HDFNativeData.byteToInt(0, 1, min);
            Integer f = new Integer(fmx[0]);
            maxmin[0] = f.doubleValue();
            f = new Integer(fmn[0]);
            maxmin[1] = f.doubleValue();
        } else if (NT == 25) {
            int[] fmx = HDFNativeData.byteToInt(0, 1, max);
            Integer i = new Integer(fmx[0]);
            Float f = i.floatValue() < 0.0f ? new Float((float)((double)i.floatValue() + 4.294967296E9)) : new Float(i.floatValue());
            maxmin[0] = f.doubleValue();
            fmx = HDFNativeData.byteToInt(0, 1, max);
            i = new Integer(fmx[0]);
            f = i.floatValue() < 0.0f ? new Float((float)((double)i.floatValue() + 4.294967296E9)) : new Float(i.floatValue());
            maxmin[1] = f.doubleValue();
        } else if (NT == 5) {
            float[] fmx = HDFNativeData.byteToFloat(0, 1, max);
            float[] fmn = HDFNativeData.byteToFloat(0, 1, min);
            Float f = new Float(fmx[0]);
            maxmin[0] = f.doubleValue();
            f = new Float(fmn[0]);
            maxmin[1] = f.doubleValue();
        } else if (NT == 6) {
            double[] fmx = HDFNativeData.byteToDouble(0, 1, max);
            double[] fmn = HDFNativeData.byteToDouble(0, 1, min);
            Double f = new Double(fmx[0]);
            maxmin[0] = f;
            f = new Double(fmn[0]);
            maxmin[1] = f;
        } else {
            System.out.println("Error: SDgetrange not converting, type " + NT);
        }
        return rval;
    }

    public static native int SDcreate(int var0, String var1, int var2, int var3, int[] var4) throws HDFException;

    public static native boolean SDisrecord(int var0) throws HDFException;

    public static native boolean SDsetattr(int var0, String var1, int var2, int var3, byte[] var4) throws HDFException;

    public static boolean SDsetattr(int s_id, String attr_name, int num_type, int count, Object theValues) throws HDFException {
        HDFArray theArray = new HDFArray(theValues);
        byte[] data = theArray.byteify();
        return HDFLibrary.SDsetattr(s_id, attr_name, num_type, count, data);
    }

    public static native boolean SDsetcal(int var0, double var1, double var3, double var5, double var7, int var9) throws HDFException;

    public static native boolean SDsetdatastrs(int var0, String var1, String var2, String var3, String var4) throws HDFException;

    public static native boolean SDsetdimname(int var0, String var1) throws HDFException;

    public static native boolean SDsetdimscale(int var0, int var1, int var2, byte[] var3) throws HDFException;

    public static boolean SDsetdimscale(int dim_id, int count, int number_type, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.byteify();
        return HDFLibrary.SDsetdimscale(dim_id, count, number_type, data);
    }

    public static native boolean SDsetdimstrs(int var0, String var1, String var2, String var3) throws HDFException;

    public static native boolean SDsetexternalfile(int var0, String var1, int var2) throws HDFException;

    public static native boolean SDsetfillvalue(int var0, byte[] var1) throws HDFException;

    public static boolean SDsetfillvalue(int sds_id, Object the_fill_val) throws HDFException {
        HDFArray theArray = new HDFArray(the_fill_val);
        byte[] data = theArray.byteify();
        return HDFLibrary.SDsetfillvalue(sds_id, data);
    }

    public static native boolean SDsetrange(int var0, byte[] var1, byte[] var2) throws HDFException;

    public static boolean SDsetrange(int sdsid, Object max, Object min) throws HDFException {
        HDFArray theArray1 = new HDFArray(max);
        byte[] d1 = theArray1.byteify();
        HDFArray theArray2 = new HDFArray(min);
        byte[] d2 = theArray2.byteify();
        return HDFLibrary.SDgetrange(sdsid, d1, d2);
    }

    public static native boolean SDwritedata(int var0, int[] var1, int[] var2, int[] var3, byte[] var4) throws HDFException;

    public static boolean SDwritedata(int sdsid, int[] start, int[] stride, int[] count, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.byteify();
        return HDFLibrary.SDwritedata(sdsid, start, stride, count, data);
    }

    public static native boolean SDsetnbitdataset(int var0, int var1, int var2, int var3, int var4) throws HDFException;

    public static native boolean SDsetcompress(int var0, int var1, HDFCompInfo var2) throws HDFException;

    public static native boolean SDgetcompress(int var0, HDFCompInfo var1) throws HDFException;

    public static native boolean SDsetaccesstype(int var0, int var1) throws HDFException;

    public static native boolean SDsetblocksize(int var0, int var1) throws HDFException;

    public static boolean SDsetfillmode(int sdsid, boolean fill_enable) throws HDFException {
        int fm = fill_enable ? 0 : 256;
        return HDFLibrary.SDsetfillmode(sdsid, fm);
    }

    public static native boolean SDsetfillmode(int var0, int var1) throws HDFException;

    public static native boolean SDsetdimval_comp(int var0, int var1) throws HDFException;

    public static native boolean SDisdimval_bwcomp(int var0) throws HDFException;

    public static native boolean SDsetchunk(int var0, HDFChunkInfo var1, int var2) throws HDFException;

    public static native boolean SDgetchunkinfo(int var0, HDFChunkInfo var1, int[] var2) throws HDFException;

    public static native boolean SDreadchunk(int var0, int[] var1, byte[] var2) throws HDFException;

    public static boolean SDreadchunk(int sdsid, int[] origin, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.emptyBytes();
        boolean rval = HDFLibrary.SDreadchunk(sdsid, origin, data);
        theData = theArray.arrayify(data);
        return rval;
    }

    public static native int SDsetchunkcache(int var0, int var1, int var2) throws HDFException;

    public static native boolean SDwritechunk(int var0, int[] var1, byte[] var2) throws HDFException;

    public static boolean SDwritechunk(int sdsid, int[] origin, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.byteify();
        return HDFLibrary.SDwritechunk(sdsid, origin, data);
    }

    public static native int VFfieldesize(int var0, int var1) throws HDFException;

    public static native int VFfieldisize(int var0, int var1) throws HDFException;

    public static native String VFfieldname(int var0, int var1) throws HDFException;

    public static native int VFfieldorder(int var0, int var1) throws HDFException;

    public static native int VFfieldtype(int var0, int var1) throws HDFException;

    public static native int VFnfields(int var0) throws HDFException;

    public static native int VHmakegroup(int var0, int[] var1, int[] var2, int var3, String var4, String var5) throws HDFException;

    public static native int VHstoredata(int var0, String var1, byte[] var2, int var3, int var4, String var5, String var6) throws HDFException;

    public static int VHstoredata(int file_id, String fieldname, Object thebuf, int n_records, int data_type, String vdata_name, String vdata_class) throws HDFException {
        HDFArray theArray = new HDFArray(thebuf);
        byte[] data = theArray.byteify();
        return HDFLibrary.VHstoredata(file_id, fieldname, data, n_records, data_type, vdata_name, vdata_class);
    }

    public static native int VHstoredatam(int var0, String var1, byte[] var2, int var3, int var4, String var5, String var6, int var7) throws HDFException;

    public static int VHstoredatam(int file_id, String fieldname, Object buf, int n_records, int data_type, String vdata_name, String vdata_class, int order) throws HDFException {
        HDFArray theArray = new HDFArray(buf);
        byte[] data = theArray.byteify();
        return HDFLibrary.VHstoredatam(file_id, fieldname, data, n_records, data_type, vdata_name, vdata_class, order);
    }

    public static native int VQueryref(int var0) throws HDFException;

    public static native int VQuerytag(int var0) throws HDFException;

    public static native boolean VSQuerycount(int var0, int[] var1) throws HDFException;

    public static native boolean VSQueryfields(int var0, String[] var1) throws HDFException;

    public static native boolean VSQueryinterlace(int var0, int[] var1) throws HDFException;

    public static native boolean VSQueryname(int var0, String[] var1) throws HDFException;

    public static native int VSQueryref(int var0) throws HDFException;

    public static native int VSQuerytag(int var0) throws HDFException;

    public static native boolean VSQueryvsize(int var0, int[] var1) throws HDFException;

    public static native int VSattach(int var0, int var1, String var2) throws HDFException;

    public static native void VSdetach(int var0) throws HDFException;

    public static native int VSgetid(int var0, int var1) throws HDFException;

    public static native void VSgetclass(int var0, String[] var1) throws HDFException;

    public static native void VSgetname(int var0, String[] var1) throws HDFException;

    public static native int VSelts(int var0) throws HDFException;

    public static native boolean VSfdefine(int var0, String var1, int var2, int var3) throws HDFException;

    public static native boolean VSfexist(int var0, String var1) throws HDFException;

    public static native int VSfind(int var0, String var1) throws HDFException;

    public static native int VSsetblocksize(int var0, int var1) throws HDFException;

    public static native int VSsetnumblocks(int var0, int var1) throws HDFException;

    public static native int VSgetfields(int var0, String[] var1) throws HDFException;

    public static native int VSgetinterlace(int var0) throws HDFException;

    public static native boolean VSinquire(int var0, int[] var1, String[] var2) throws HDFException;

    public static native boolean VSinquire(int var0, int[] var1) throws HDFException;

    public static native int VSlone(int var0, int[] var1, int var2) throws HDFException;

    public static native int VSread(int var0, byte[] var1, int var2, int var3) throws HDFException;

    public static int VSread(int vdata_id, Object theData, int nrecord, int interlace) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.emptyBytes();
        int rval = HDFLibrary.VSread(vdata_id, data, nrecord, interlace);
        theData = theArray.arrayify(data);
        return rval;
    }

    public static native int VSseek(int var0, int var1) throws HDFException;

    public static native boolean VSsetfields(int var0, String var1) throws HDFException;

    public static native boolean VSsetinterlace(int var0, int var1) throws HDFException;

    public static native int VSsizeof(int var0, String var1) throws HDFException;

    public static native boolean VSappendable(int var0, int var1) throws HDFException;

    public static native int VSfindclass(int var0, String var1) throws HDFException;

    public static native int VSgetversion(int var0) throws HDFException;

    public static native void VSsetclass(int var0, String var1) throws HDFException;

    public static native boolean VSsetexternalfile(int var0, String var1, int var2) throws HDFException;

    public static native void VSsetname(int var0, String var1) throws HDFException;

    public static native int VSwrite(int var0, byte[] var1, int var2, int var3) throws HDFException;

    public static int VSwrite(int vdata_id, Object databuf, int n_records, int interlace) throws HDFException {
        HDFArray theArray = new HDFArray(databuf);
        byte[] data = theArray.byteify();
        return HDFLibrary.VSwrite(vdata_id, data, n_records, interlace);
    }

    public static native boolean Vstart(int var0) throws HDFException;

    public static native int Vattach(int var0, int var1, String var2) throws HDFException;

    public static native void Vdetach(int var0) throws HDFException;

    public static native void Vend(int var0) throws HDFException;

    public static native int Vgetid(int var0, int var1) throws HDFException;

    public static native void Vgetclass(int var0, String[] var1) throws HDFException;

    public static native void Vgetname(int var0, String[] var1) throws HDFException;

    public static native boolean Visvg(int var0, int var1) throws HDFException;

    public static native boolean Visvs(int var0, int var1) throws HDFException;

    public static native int Vgettagrefs(int var0, int[] var1, int[] var2, int var3) throws HDFException;

    public static native boolean Vgettagref(int var0, int var1, int[] var2) throws HDFException;

    public static native int Vntagrefs(int var0) throws HDFException;

    public static native boolean Vinqtagref(int var0, int var1, int var2) throws HDFException;

    public static native int Vlone(int var0, int[] var1, int var2) throws HDFException;

    public static native int Vaddtagref(int var0, int var1, int var2) throws HDFException;

    public static native int Vdeletetagref(int var0, int var1, int var2) throws HDFException;

    public static native int Vfind(int var0, String var1) throws HDFException;

    public static native int Vfindclass(int var0, String var1) throws HDFException;

    public static native int Vflocate(int var0, String var1) throws HDFException;

    public static native int Vgetnext(int var0, int var1) throws HDFException;

    public static native boolean Vinquire(int var0, int[] var1, String[] var2) throws HDFException;

    public static native int Vinsert(int var0, int var1) throws HDFException;

    public static native int Vnrefs(int var0, int var1) throws HDFException;

    public static native boolean Vsetclass(int var0, String var1) throws HDFException;

    public static native boolean Vsetname(int var0, String var1) throws HDFException;

    public static native boolean Vattrinfo(int var0, int var1, String[] var2, int[] var3) throws HDFException;

    public static native int Vfindattr(int var0, String var1) throws HDFException;

    public static native boolean Vgetattr(int var0, int var1, byte[] var2) throws HDFException;

    public static boolean Vgetattr(int id, int index, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.emptyBytes();
        boolean rval = HDFLibrary.Vgetattr(id, index, data);
        theData = theArray.arrayify(data);
        return rval;
    }

    public static native int Vgetversion(int var0) throws HDFException;

    public static native int Vnattrs(int var0) throws HDFException;

    public static native boolean Vsetattr(int var0, String var1, int var2, int var3, String var4) throws HDFException;

    public static native boolean Vsetattr(int var0, String var1, int var2, int var3, byte[] var4) throws HDFException;

    public static boolean Vsetattr(int id, String attr_name, int data_type, int count, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.byteify();
        return HDFLibrary.Vsetattr(id, attr_name, data_type, count, data);
    }

    public static native boolean VSattrinfo(int var0, int var1, int var2, String[] var3, int[] var4) throws HDFException;

    public static native int VSfindex(int var0, String var1, int[] var2) throws HDFException;

    public static native int VSfindattr(int var0, int var1, String var2) throws HDFException;

    public static native int VSfnattrs(int var0, int var1) throws HDFException;

    public static native boolean VSgetattr(int var0, int var1, int var2, byte[] var3) throws HDFException;

    public static boolean VSgetattr(int id, int index, int attr_index, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.emptyBytes();
        boolean rval = HDFLibrary.VSgetattr(id, index, attr_index, data);
        theData = theArray.arrayify(data);
        return rval;
    }

    public static native boolean VSisattr(int var0) throws HDFException;

    public static native int VSnattrs(int var0) throws HDFException;

    public static native boolean VSsetattr(int var0, int var1, String var2, int var3, int var4, String var5) throws HDFException;

    public static native boolean VSsetattr(int var0, int var1, String var2, int var3, int var4, byte[] var5) throws HDFException;

    public static boolean VSsetattr(int id, int index, String attr_name, int data_type, int count, Object theData) throws HDFException {
        HDFArray theArray = new HDFArray(theData);
        byte[] data = theArray.byteify();
        return HDFLibrary.VSsetattr(id, index, attr_name, data_type, count, data);
    }

    public static native boolean DF24getdims(String var0, int[] var1) throws HDFException;

    public static native boolean DF24reqil(int var0) throws HDFException;

    public static native boolean DF24getimage(String var0, byte[] var1, int var2, int var3) throws HDFException;

    public static boolean DF24getimage(String fileName, Object theImagedata, int width, int height) throws HDFException {
        HDFArray theArray = new HDFArray(theImagedata);
        byte[] data = theArray.emptyBytes();
        boolean rval = HDFLibrary.DF24getimage(fileName, data, width, height);
        theImagedata = theArray.arrayify(data);
        return rval;
    }

    public static native short DF24lastref() throws HDFException;

    public static native boolean DF24restart() throws HDFException;

    public static native boolean DF24readref(String var0, int var1) throws HDFException;

    public static native int DF24nimages(String var0) throws HDFException;

    public static native boolean DF24addimage(String var0, byte[] var1, int var2, int var3) throws HDFException;

    public static boolean DF24addimage(String filename, Object theImage, int width, int height) throws HDFException {
        HDFArray theArray = new HDFArray(theImage);
        byte[] data = theArray.byteify();
        return HDFLibrary.DF24addimage(filename, data, width, height);
    }

    public static native boolean DF24putimage(String var0, byte[] var1, int var2, int var3) throws HDFException;

    public static boolean DF24putimage(String filename, Object theImage, int width, int height) throws HDFException {
        HDFArray theArray = new HDFArray(theImage);
        byte[] data = theArray.byteify();
        return HDFLibrary.DF24putimage(filename, data, width, height);
    }

    public static native boolean DF24setcompress(int var0, HDFCompInfo var1) throws HDFException;

    public static native boolean DF24setdims(int var0, int var1) throws HDFException;

    public static native boolean DF24setil(int var0) throws HDFException;

    public static native boolean DFR8getdims(String var0, int[] var1, boolean[] var2) throws HDFException;

    public static native boolean DFR8getimage(String var0, byte[] var1, int var2, int var3, byte[] var4) throws HDFException;

    public static boolean DFR8getimage(String fileName, Object theImagedata, int width, int height, byte[] palette) throws HDFException {
        HDFArray theArray = new HDFArray(theImagedata);
        byte[] data = theArray.emptyBytes();
        boolean rval = HDFLibrary.DFR8getimage(fileName, data, width, height, palette);
        theImagedata = theArray.arrayify(data);
        return rval;
    }

    public static native short DFR8lastref() throws HDFException;

    public static native boolean DFR8restart() throws HDFException;

    public static native boolean DFR8readref(String var0, int var1) throws HDFException;

    public static native int DFR8nimages(String var0) throws HDFException;

    public static native boolean DFR8addimage(String var0, byte[] var1, int var2, int var3, short var4) throws HDFException;

    public static boolean DFR8addimage(String filename, Object theImage, int width, int height, short compress) throws HDFException {
        HDFArray theArray = new HDFArray(theImage);
        byte[] data = theArray.byteify();
        return HDFLibrary.DFR8addimage(filename, data, width, height, compress);
    }

    public static native boolean DFR8putimage(String var0, byte[] var1, int var2, int var3, short var4) throws HDFException;

    public static boolean DFR8putimage(String filename, Object theImage, int width, int height, short compress) throws HDFException {
        HDFArray theArray = new HDFArray(theImage);
        byte[] data = theArray.byteify();
        return HDFLibrary.DFR8putimage(filename, data, width, height, compress);
    }

    public static native boolean DFR8setcompress(int var0, HDFCompInfo var1) throws HDFException;

    public static native boolean DFR8getpalref(short[] var0) throws HDFException;

    public static native boolean DFR8setpalette(byte[] var0) throws HDFException;

    public static native boolean DFR8writeref(String var0, short var1) throws HDFException;

    public static native boolean SDreaddata_short(int var0, int[] var1, int[] var2, int[] var3, short[] var4) throws HDFException;

    public static native boolean SDreaddata_int(int var0, int[] var1, int[] var2, int[] var3, int[] var4) throws HDFException;

    public static native boolean SDreaddata_long(int var0, int[] var1, int[] var2, int[] var3, long[] var4) throws HDFException;

    public static native boolean SDreaddata_float(int var0, int[] var1, int[] var2, int[] var3, float[] var4) throws HDFException;

    public static native boolean SDreaddata_double(int var0, int[] var1, int[] var2, int[] var3, double[] var4) throws HDFException;

    public static native int HCget_config_info(int var0) throws HDFException;

    static {
        HDFLibrary.loadH4Lib();
    }
}

