/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.math;

import org.geotools.math.XMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Fraction
extends Number
implements Comparable<Fraction>,
Cloneable {
    private static final long serialVersionUID = -4501644254763471216L;
    private int numerator;
    private int denominator;

    public Fraction() {
    }

    public Fraction(Fraction other) {
        this.numerator = other.numerator;
        this.denominator = other.denominator;
    }

    public Fraction(int numerator) {
        this.numerator = numerator;
        this.denominator = 1;
    }

    public Fraction(int numerator, int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.simplify();
    }

    public void set(int numerator, int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.simplify();
    }

    public void add(Fraction other) {
        this.numerator = this.numerator * other.denominator + other.numerator * this.denominator;
        this.denominator *= other.denominator;
        this.simplify();
    }

    public void subtract(Fraction other) {
        this.numerator = this.numerator * other.denominator - other.numerator * this.denominator;
        this.denominator *= other.denominator;
        this.simplify();
    }

    public void multiply(Fraction other) {
        this.numerator *= other.numerator;
        this.denominator *= other.denominator;
        this.simplify();
    }

    public void divide(Fraction other) {
        this.numerator *= other.denominator;
        this.denominator *= other.numerator;
        this.simplify();
    }

    private void simplify() {
        if (this.numerator == 0) {
            this.denominator = XMath.sgn(this.denominator);
            return;
        }
        if (this.denominator == 0) {
            this.numerator = XMath.sgn(this.numerator);
            return;
        }
        if (this.denominator % this.numerator == 0) {
            this.denominator /= this.numerator;
            if (this.denominator < 0) {
                this.denominator = -this.denominator;
                this.numerator = -1;
            } else {
                this.numerator = 1;
            }
            return;
        }
        int num = Math.abs(this.numerator);
        int den = Math.abs(this.denominator);
        if ((num %= den) == 0) {
            this.numerator /= this.denominator;
            this.denominator = 1;
            return;
        }
        int pgcd = 1;
        int remainder = num;
        do {
            num = den;
            den = remainder;
            pgcd = remainder;
        } while ((remainder = num % den) != 0);
        this.numerator /= pgcd;
        this.denominator /= pgcd;
        if (this.denominator < 0) {
            this.numerator = -this.numerator;
            this.denominator = -this.denominator;
        }
    }

    public int numerator() {
        return this.numerator;
    }

    public int denominator() {
        return this.denominator;
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public int intValue() {
        return Fraction.round(this.numerator, this.denominator);
    }

    public static long round(long numerator, long denominator) {
        long d;
        long n = numerator / denominator;
        long r = numerator % denominator;
        if (r != 0L && ((r = Math.abs(r << 1)) > (d = Math.abs(denominator)) || r == d && (n & 1L) != 0L)) {
            n = (numerator ^ denominator) >= 0L ? ++n : --n;
        }
        return n;
    }

    public static int round(int numerator, int denominator) {
        int d;
        int n = numerator / denominator;
        int r = numerator % denominator;
        if (r != 0 && ((r = Math.abs(r << 1)) > (d = Math.abs(denominator)) || r == d && (n & 1) != 0)) {
            n = (numerator ^ denominator) >= 0 ? ++n : --n;
        }
        return n;
    }

    public static int floor(int numerator, int denominator) {
        int n = numerator / denominator;
        if ((numerator ^ denominator) < 0 && numerator % denominator != 0) {
            --n;
        }
        return n;
    }

    public static int ceil(int numerator, int denominator) {
        int n = numerator / denominator;
        if ((numerator ^ denominator) >= 0 && numerator % denominator != 0) {
            ++n;
        }
        return n;
    }

    @Override
    public int compareTo(Fraction other) {
        return this.numerator * other.denominator - other.numerator * this.denominator;
    }

    public boolean equals(Object other) {
        if (other instanceof Fraction) {
            Fraction that = (Fraction)other;
            return this.numerator == that.numerator && this.denominator == that.denominator;
        }
        return false;
    }

    public Fraction clone() {
        try {
            return (Fraction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        return String.valueOf(this.numerator) + '/' + this.denominator;
    }
}

