/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.language.d3;

import java.awt.geom.Rectangle2D;
import javax.media.j3d.Bounds;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import nl.tudelft.simulation.language.d3.BoundingBox;
import nl.tudelft.simulation.language.d3.DirectedPoint;

public final class BoundsUtil {
    private BoundsUtil() {
    }

    public static Rectangle2D getIntersect(DirectedPoint center, Bounds bounds, double zValue) {
        BoundingBox box = new BoundingBox((Bounds)bounds.clone());
        Transform3D transform = new Transform3D();
        transform.rotZ(center.getRotZ());
        transform.rotY(center.getRotY());
        transform.rotX(center.getRotX());
        transform.setTranslation(new Vector3d((Tuple3d)new Point3d(((Tuple3d)center).x, ((Tuple3d)center).y, ((Tuple3d)center).z)));
        box.transform(transform);
        Point3d lower = new Point3d();
        box.getLower(lower);
        lower.set(lower.x, lower.y, zValue);
        if (!box.intersect(lower)) {
            return null;
        }
        Point3d upper = new Point3d();
        box.getUpper(upper);
        return new Rectangle2D.Double(lower.x, lower.y, upper.x - lower.x, upper.y - lower.y);
    }

    public static Bounds transform(Bounds bounds, DirectedPoint point) {
        Bounds result = (Bounds)bounds.clone();
        Transform3D transform = new Transform3D();
        transform.rotX(point.getRotX());
        transform.rotY(point.getRotY());
        transform.rotZ(point.getRotZ());
        transform.setTranslation(new Vector3d((Tuple3d)point));
        result.transform(transform);
        return result;
    }

    public static boolean contains(DirectedPoint center, Bounds bounds, Point3d point) {
        BoundingBox box = new BoundingBox((Bounds)bounds.clone());
        Transform3D transform = new Transform3D();
        transform.rotZ(center.getRotZ());
        transform.rotY(center.getRotY());
        transform.rotX(center.getRotX());
        transform.setTranslation(new Vector3d((Tuple3d)center));
        box.transform(transform);
        Point3d lower = new Point3d();
        box.getLower(lower);
        Point3d upper = new Point3d();
        box.getUpper(upper);
        return point.x >= lower.x && point.x <= upper.x && point.y >= lower.y && point.y <= upper.y && point.z >= lower.z && point.z <= upper.z;
    }
}

