/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.geotools.feature.AttributeType;
import org.geotools.feature.DefaultFeatureBuilder;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.resources.Utilities;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFeatureType
extends SimpleFeatureTypeImpl
implements FeatureType {
    private final int hashCode;
    public static final FeatureType EMPTY = new DefaultFeatureType();

    private static final URI toURI(String namespace) throws SchemaException {
        try {
            return new URI(namespace);
        }
        catch (URISyntaxException badNamespace) {
            throw new SchemaException(badNamespace);
        }
    }

    public DefaultFeatureType(String typeName, String namespace, Collection types, Collection superTypes, GeometryAttributeType defaultGeom) throws SchemaException, NullPointerException {
        this(typeName, DefaultFeatureType.toURI(namespace), types, superTypes, defaultGeom);
    }

    public DefaultFeatureType(String typeName, URI namespace, Collection types, Collection superTypes, GeometryAttributeType defaultGeom) throws NullPointerException {
        this(namespace != null ? new NameImpl(namespace.toString(), typeName) : new NameImpl(FeatureTypes.DEFAULT_NAMESPACE.toString(), typeName), types, superTypes, defaultGeom);
    }

    private static final <T> List<T> toList(Collection<T> collection) {
        if (collection == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(collection);
    }

    private static final FeatureType toFeatureType(Collection types) {
        if (types == null || types.isEmpty()) {
            return null;
        }
        if (types.size() > 1) {
            throw new IllegalArgumentException("May only specify a single parent");
        }
        return (FeatureType)types.iterator().next();
    }

    public DefaultFeatureType(Name name, Collection types, Collection superTypes, GeometryAttributeType defaultGeom) throws NullPointerException {
        super(name, (List)types, (GeometryDescriptor)defaultGeom, false, (List<Filter>)null, (org.opengis.feature.type.AttributeType)DefaultFeatureType.toFeatureType(superTypes), (InternationalString)null);
        if (name == null) {
            throw new NullPointerException("Name required");
        }
        this.hashCode = this.computeHash();
    }

    public DefaultFeatureType(Name name, List schema, GeometryDescriptor defaultGeometry, boolean isAbstract, List restrictions, org.opengis.feature.type.AttributeType superType, InternationalString description) {
        super(name, schema, defaultGeometry, isAbstract, (List<Filter>)restrictions, superType, description);
        this.hashCode = this.computeHash();
    }

    private DefaultFeatureType() {
        this("emptyFeatreType", FeatureTypes.DEFAULT_NAMESPACE, (Collection)Collections.EMPTY_LIST, (Collection)Collections.EMPTY_LIST, null);
    }

    private void init() {
    }

    @Override
    public Feature create(Object[] attributes) throws IllegalAttributeException {
        return this.create(attributes, null);
    }

    @Override
    public Feature create(Object[] attributes, String featureID) throws IllegalAttributeException {
        if (attributes == null && this.getAttributeCount() != 0) {
            throw new IllegalAttributeException("attributes null");
        }
        try {
            DefaultFeatureBuilder builder = new DefaultFeatureBuilder(this);
            builder.add(attributes);
            return (Feature)builder.buildFeature(featureID);
        }
        catch (Exception e) {
            throw (IllegalAttributeException)((Object)new IllegalAttributeException("illegal attribute").initCause(e));
        }
    }

    @Override
    public Feature duplicate(Feature original) throws IllegalAttributeException {
        if (original == null) {
            return null;
        }
        FeatureType featureType = original.getFeatureType();
        if (!((Object)featureType).equals(this)) {
            throw new IllegalAttributeException("Feature type " + featureType + " does not match " + this);
        }
        try {
            DefaultFeatureBuilder builder = new DefaultFeatureBuilder(original);
            return (Feature)builder.buildFeature(original.getID());
        }
        catch (Exception e) {
            throw (IllegalAttributeException)((Object)new IllegalAttributeException("illegal attribute").initCause(e));
        }
    }

    @Override
    public GeometryAttributeType getGeometryDescriptor() {
        return (GeometryAttributeType)super.getGeometryDescriptor();
    }

    @Override
    public AttributeType getAttributeType(String xPath) {
        return (AttributeType)this.getDescriptor(xPath);
    }

    @Override
    public int find(AttributeType type) {
        if (type == null) {
            return -1;
        }
        int idx = this.find(type.getLocalName());
        if (idx < 0 || !this.getAttributeDescriptors().get(idx).equals(type)) {
            idx = -1;
        }
        return idx;
    }

    @Override
    public int find(String attName) {
        return this.indexOf(attName);
    }

    @Override
    public AttributeType getAttributeType(int position) {
        return (AttributeType)this.getAttributeDescriptors().get(position);
    }

    @Override
    public AttributeType[] getAttributeTypes() {
        return this.getAttributeDescriptors().toArray(new AttributeType[this.getAttributeDescriptors().size()]);
    }

    @Override
    public URI getNamespace() {
        try {
            return this.getName().getNamespaceURI() != null ? new URI(this.getName().getNamespaceURI()) : null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public String getTypeName() {
        return this.getName().getLocalPart();
    }

    @Override
    public boolean hasAttributeType(String xPath) {
        return this.getAttributeType(xPath) != null;
    }

    @Override
    public int getAttributeCount() {
        return this.getAttributeDescriptors().size();
    }

    private int computeHash() {
        return super.hashCode();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof FeatureType) {
            return super.equals((FeatureType)other);
        }
        return false;
    }

    @Override
    public FeatureType[] getAncestors() {
        return null;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isDescendedFrom(FeatureType type) {
        return this.isDescendedFrom(type.getNamespace(), type.getTypeName());
    }

    @Override
    public boolean isDescendedFrom(URI nsURI, String typeName1) {
        for (FeatureType superType = (FeatureType)this.getSuper(); superType != null; superType = (FeatureType)superType.getSuper()) {
            if (!(nsURI == null ? Utilities.equals((Object)superType.getTypeName(), (Object)typeName1) : Utilities.equals((Object)superType.getNamespace(), (Object)nsURI) && Utilities.equals((Object)superType.getTypeName(), (Object)typeName1))) continue;
            return true;
        }
        return false;
    }

    static final class Abstract
    extends DefaultFeatureType {
        public Abstract(String typeName, URI namespace, Collection types, Collection superTypes, GeometryAttributeType defaultGeom) throws SchemaException {
            super(typeName, namespace, types, superTypes, defaultGeom);
            for (FeatureType ft : superTypes) {
            }
        }

        public final boolean isAbstract() {
            return true;
        }

        public Feature create(Object[] atts) throws IllegalAttributeException {
            throw new UnsupportedOperationException("Abstract Type");
        }

        public Feature create(Object[] atts, String id) throws IllegalAttributeException {
            throw new UnsupportedOperationException("Abstract Type");
        }
    }
}

