/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import gov.nasa.worldwind.ViewStateIterator;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.view.BasicOrbitView;
import gov.nasa.worldwind.view.FlyToOrbitViewStateIterator;
import gov.nasa.worldwind.view.OrbitView;
import gw.renderables.ComplexPolygon;
import gw.renderables.LinePath;
import gw.util.ProjectionUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WorldWindUtils {
    static final double DEG_IN_METER = 111131.745;

    public static void flyTo(LatLon upperleft, LatLon lowerright, WorldWindow canvas) {
        WorldWindUtils.flyTo(new Sector(lowerright.getLatitude(), upperleft.getLatitude(), upperleft.getLongitude(), lowerright.getLongitude()), canvas);
    }

    public static void flyTo(Sector sect, WorldWindow canvas) {
        double majorDimension = sect.getDeltaLatDegrees() > sect.getDeltaLonDegrees() ? sect.getDeltaLatDegrees() : sect.getDeltaLonDegrees();
        BasicOrbitView vw = (BasicOrbitView)canvas.getView();
        double fov = vw.getFieldOfView().getRadians();
        double alt = majorDimension * 111131.745 / Math.sin(fov);
        LatLon ll = sect.getCentroid();
        Position p = Position.fromDegrees((double)ll.getLatitude().getDegrees(), (double)ll.getLongitude().getDegrees(), (double)0.0);
        FlyToOrbitViewStateIterator pan = FlyToOrbitViewStateIterator.createPanToIterator((OrbitView)vw, (Globe)canvas.getModel().getGlobe(), (Position)p, (Angle)Angle.ZERO, (Angle)Angle.ZERO, (double)alt);
        vw.applyStateIterator((ViewStateIterator)pan);
    }

    public static double getCameraAltitude(LatLon upperleft, LatLon lowerright, double fovInRadians) {
        double majorDimension = 0.0;
        LatLon dim = lowerright.subtract(upperleft);
        majorDimension = dim.getLatitude().getDegrees() > dim.getLongitude().getDegrees() ? dim.getLatitude().getDegrees() : dim.getLongitude().getDegrees();
        double lengthOfDegreeInMeters = 111131.745;
        double extentInDegrees = majorDimension;
        double extentInMeters = extentInDegrees * lengthOfDegreeInMeters;
        return extentInMeters / Math.sin(fovInRadians);
    }

    public static RenderableLayer buildTextureLayer(BufferedImage image, Sector sector) {
        SurfaceImage simg = new SurfaceImage((Object)image, sector);
        RenderableLayer layer = new RenderableLayer();
        layer.addRenderable((Renderable)simg);
        return layer;
    }

    public static SurfacePolygon polygonFromFeature(SimpleFeature feature, CoordinateReferenceSystem crs, Color insideColor, Color borderColor) {
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        Coordinate[] coords = geometry.getCoordinates();
        ArrayList<LatLon> vertices = new ArrayList<LatLon>();
        for (int i = 0; i < coords.length; ++i) {
            double[] c = new double[]{coords[i].x, coords[i].y};
            vertices.add(ProjectionUtils.toLatLon(c, crs));
        }
        return new SurfacePolygon(vertices, insideColor, borderColor);
    }

    public static ComplexPolygon complexPolygonFromFeature(SimpleFeature feature, CoordinateReferenceSystem crs, Color color) {
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        Coordinate[] coords = geometry.getCoordinates();
        Position[] vertices = new Position[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            double[] c = new double[]{coords[i].x, coords[i].y};
            LatLon ll = ProjectionUtils.toLatLon(c, crs);
            vertices[i] = new Position(ll, 1000.0);
        }
        return new ComplexPolygon(vertices, color);
    }

    public static LinePath linePathFromFeature(SimpleFeature feature, CoordinateReferenceSystem crs, Color color, int width, double elevation, boolean absElevation) {
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        Coordinate[] coords = geometry.getCoordinates();
        Position[] vertices = new Position[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            double[] c = new double[]{coords[i].x, coords[i].y};
            LatLon ll = ProjectionUtils.toLatLon(c, crs);
            vertices[i] = new Position(ll, elevation);
        }
        return new LinePath(vertices, color, width, absElevation);
    }

    public static Polyline polylineFromFeature(SimpleFeature feature, CoordinateReferenceSystem crs, Color color, double elevation) {
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        Coordinate[] coords = geometry.getCoordinates();
        ArrayList<Position> vertices = new ArrayList<Position>();
        for (int i = 0; i < coords.length; ++i) {
            double[] c = new double[]{coords[i].x, coords[i].y};
            LatLon ll = ProjectionUtils.toLatLon(c, crs);
            vertices.add(new Position(ll, elevation));
        }
        Polyline polyline = new Polyline();
        polyline.setPositions(vertices);
        polyline.setColor(color);
        polyline.setFollowTerrain(true);
        polyline.setAntiAliasHint(4354);
        polyline.setPathType(1);
        polyline.setLineWidth(2.0);
        polyline.setClosed(false);
        polyline.setFilled(false);
        return polyline;
    }

    public static SurfacePolygon polygonFromBoundingBox(double lat1, double long1, double lat2, double long2) {
        return null;
    }

    public static Sector sectorFromEnvelope(Envelope env) {
        return Sector.fromDegrees((double)env.getMinimum(1), (double)env.getMaximum(1), (double)env.getMinimum(0), (double)env.getMaximum(0));
    }
}

