/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import java.awt.Color;

public class ColorBlend {
    protected float hueB;
    protected float saturationB;
    protected float brillianceB;
    protected float alphaB;
    protected double hueF;
    protected double saturationF;
    protected double brillianceF;
    protected double alphaF;
    protected double minimum;

    public static Color mixColors(Color src, Color dest, float percentage) {
        float r = (float)src.getRed() + (float)(dest.getRed() - src.getRed()) * percentage;
        float g = (float)src.getGreen() + (float)(dest.getGreen() - src.getGreen()) * percentage;
        float b = (float)src.getBlue() + (float)(dest.getBlue() - src.getBlue()) * percentage;
        float a = (float)src.getAlpha() + (float)(dest.getAlpha() - src.getAlpha()) * percentage;
        return new Color(r / 255.0f, g / 255.0f, b / 255.0f, a / 255.0f);
    }

    public ColorBlend(float[] hsbB, float[] hsbE, boolean increase, float alphaB, float alphaE, double minimum, double maximum) {
        this.hueB = hsbB[0];
        float hueE = hsbE[0];
        if (hueE <= this.hueB && increase) {
            hueE += 1.0f;
        } else if (this.hueB <= hueE && !increase) {
            hueE -= 1.0f;
        }
        this.saturationB = hsbB[1];
        this.brillianceB = hsbB[2];
        this.alphaB = alphaB;
        this.minimum = minimum;
        double range = maximum - minimum;
        this.hueF = range == 0.0 ? 0.0 : (double)(hueE - this.hueB) / range;
        this.saturationF = range == 0.0 ? 0.0 : (double)(hsbE[1] - this.saturationB) / range;
        this.brillianceF = range == 0.0 ? 0.0 : (double)(hsbE[2] - this.brillianceB) / range;
        this.alphaF = range == 0.0 ? 0.0 : (double)(alphaE - alphaB) / range;
    }

    public ColorBlend(float hueB, float hueE, boolean increase, float saturationB, float saturationE, float brillianceB, float brillianceE, float alphaB, float alphaE, double minimum, double maximum) {
        this(new float[]{hueB, saturationB, brillianceB}, new float[]{hueE, saturationE, brillianceE}, increase, alphaB, alphaE, minimum, maximum);
    }

    public ColorBlend(Color colorB, Color colorE, boolean increase, float alphaB, float alphaE, double minimum, double maximum) {
        this(ColorBlend.getHSB(colorB), ColorBlend.getHSB(colorE), increase, alphaB, alphaE, minimum, maximum);
    }

    public ColorBlend(Color colorB, Color colorE, boolean increase, double minimum, double maximum) {
        this(colorB, colorE, increase, 1.0f, 1.0f, minimum, maximum);
    }

    public final int getARGB(double value) {
        return Math.round(ColorBlend.getProportionalValue(value -= this.minimum, this.alphaB, this.alphaF) * 255.0f) << 24 | Color.HSBtoRGB(ColorBlend.getProportionalValue(value, this.hueB, this.hueF), ColorBlend.getProportionalValue(value, this.saturationB, this.saturationF), ColorBlend.getProportionalValue(value, this.brillianceB, this.brillianceF));
    }

    private static float[] getHSB(Color color) {
        return Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
    }

    private static final float getProportionalValue(double offset, double start, double factor) {
        return (float)(start + offset * factor);
    }
}

